<?php
$counters = $widget->get_setting('counters', []);
if(empty($counters)) return;

use Elementor\Icons_Manager;
// Items
$widget->add_render_attribute( 'counter-item',[
	'class' => [
		'counter-item',
		'relative',
		($settings['layout_mode'] === 'carousel') ? 'swiper-slide' : ''
	]
]);
// Title
$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', 'class', 'cms-counter-title' );
// Description
$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', 'class', 'cms-counter-desc text-16' );
// Layout mode setting
$widget->add_render_attribute('grid-settings',[
    'class' => [
        'cms-counter-grid',
        'd-grid',
        'grid-'.$widget->get_setting('col','1'),
        'grid-tablet-'.$widget->get_setting('col_tablet','1'),
        'grid-mobile-'.$widget->get_setting('col_mobile','1'),
        'gap'
    ],
    'style' => '--cms-gap:32px;--cms-gap-tablet:32px;--cms-gap-mobile:32px;'
]);
// Start layout 
	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
	<div class="cms-carousel swiper">
		<div class="swiper-wrapper">
	<?php
		break;
		default:
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('grid-settings')); ?>>
	<?php
		break;
	}
	// Start Item
	foreach ($counters as $key => $counter) {
		$counter['icon_image_size'] = $settings['icon_image_size']; // fix image size
		$counter['icon_image_custom_dimension'] = $settings['icon_image_custom_dimension']; // fix image size
		$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
	    $widget->add_render_attribute( $data_counter, [
	        'class'          => 'cms-counter-number elementor-counter-number text-75',
	        'data-duration'  => $counter['duration'],
	        'data-to-value'  => $counter['ending_number'],
	        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
	    ] );
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('counter-item')); ?>><?php
	    if($counter['show_icon'] === 'yes'){
	    ?>
		    <div class="cms-counter-icon empty-none pb-30 text-primary"><?php
			    // Counter Icon
				switch ($counter['icon_type']) {
					case 'image':
						fortis_elementor_image_render($counter, [
							'name'           => 'icon_image',
							'image_size_key' => 'icon_image',
							'custom_size'    => ['width' => 64, 'height' => 64]
						]);
						break;
					
					default:
						\Elementor\Icons_Manager::render_icon( $counter['counter_icon'], [ 'aria-hidden' => 'true' ] );
						break;
				}
			?></div>
		<?php } ?>
		<div class="cms-counter-numbers text-75 pb-30 d-flex align-items-center lh-1 heading font-400 text-heading">
		    <span class="prefix"><?php echo esc_html( $counter['prefix'] ); ?></span>
		    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
		    <span class="suffix"><?php echo esc_html( $counter['suffix'] ); ?></span>
		</div>
		<?php if ( $counter['title'] ) : ?>
		    <h4 <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></h4>
		<?php endif;
		// Description
		if ( $counter['description'] ) : ?>
		    <div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
		<?php endif; ?>
	</div>
	<?php
	} // end foreach

	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
		</div>
		<?php if ($settings['arrows'] == 'yes') : ?>
            <div class="cms-carousel-button-in-vert prev cms-carousel-button-prev">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-left',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
            <div class="cms-carousel-button-in-vert next cms-carousel-button-next">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-right',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
        <?php endif ?>
        <?php if ($settings['dots'] == 'yes') : ?>
            <div class="cms-carousel-dots cms-carousel-dots-out"></div>
        <?php endif ?>
	</div>
	<?php
		break;
		default:
	?>
	</div>
	<?php
		break;
	}
?>

