<?php
$counters = $widget->get_setting('counters', []);
if(empty($counters)) return;

use Elementor\Icons_Manager;
// Items
$widget->add_render_attribute( 'counter-item',[
	'class' => [
		'counter-item',
		'relative',
		($settings['layout_mode'] === 'carousel') ? 'swiper-slide' : '',
		'text-center'
	]
]);
// Title
$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', 'class', 'cms-counter-title heading font-600 text-19' );
// Description
$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', 'class', 'cms-counter-desc text-16' );
// Layout mode setting
$widget->add_render_attribute('grid-settings',[
    'class' => [
        'cms-counter-grid',
        'd-flex gutter gutter-grid justify-content-center',
        'flex-col-'.$widget->get_setting('col','3'),
        'flex-col-laptop-'.$widget->get_setting('col_laptop','3'),
        'flex-col-tablet-extra-'.$widget->get_setting('col_tablet_extra','3'),
        'flex-col-tablet-'.$widget->get_setting('col_tablet','2'),
        'flex-col-mobile-extra-'.$widget->get_setting('col_mobile_extra','2'),
        'flex-col-mobile-'.$widget->get_setting('col_mobile','1')
    ],
    'style' => '--cms-gutter:150px;--cms-gutter-tablet-extra:60px;--cms-gutter-mobile-extra:40px;'
]);
// Start layout 
	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
	<div class="cms-carousel swiper">
		<div class="swiper-wrapper">
	<?php
		break;
		default:
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('grid-settings')); ?>>
	<?php
		break;
	}
	// Start Item
	foreach ($counters as $key => $counter) {
		$counter['icon_image_size'] = $settings['icon_image_size']; // fix image size
		$counter['icon_image_custom_dimension'] = $settings['icon_image_custom_dimension']; // fix image size
		$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
	    $widget->add_render_attribute( $data_counter, [
	        'class'          => 'cms-counter-number heading elementor-counter-number text-75 text-primary',
	        'data-duration'  => $counter['duration'],
	        'data-to-value'  => $counter['ending_number'],
	        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
	    ] );
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('counter-item')); ?>><?php
	    if($counter['show_icon'] === 'yes'){
	    ?>
		    <div class="cms-counter-icon pb-20 empty-none"><?php
			    // Counter Icon
				switch ($counter['icon_type']) {
					case 'image':
						fortis_elementor_image_render($counter, [
							'name'           => 'icon_image',
							'image_size_key' => 'icon_image',
							'custom_size'    => ['width' => 64, 'height' => 64]
						]);
						break;
					
					default:
						\Elementor\Icons_Manager::render_icon( $counter['counter_icon'], [ 'aria-hidden' => 'true','class'=>'text-64 text-primary' ] );
						break;
				}
			?></div>
		<?php } ?>
		<div class="cms-counter-numbers pb-5">
		    <span class="prefix"><?php echo esc_html( $counter['prefix'] ); ?></span>
		    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
		    <span class="suffix"><?php echo esc_html( $counter['suffix'] ); ?></span>
		</div>
		<?php if ( $counter['title'] ) : ?>
		    <div <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></div>
		<?php endif;
		// Description
		if ( $counter['description'] ) : ?>
		    <div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
		<?php endif; ?>
	</div>
	<?php
	} // end foreach

	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
		</div>
		<?php if ($settings['arrows'] == 'yes') : ?>
            <div class="cms-carousel-button-in-vert prev cms-carousel-button-prev">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-left',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
            <div class="cms-carousel-button-in-vert next cms-carousel-button-next">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-right',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
        <?php endif ?>
        <?php if ($settings['dots'] == 'yes') : ?>
            <div class="cms-carousel-dots cms-carousel-dots-out"></div>
        <?php endif ?>
	</div>
	<?php
		break;
		default:
	?>
	</div>
	<?php
		break;
	}
?>

