<?php
$counters = $widget->get_setting('counters', []);
if(empty($counters)) return;

use Elementor\Icons_Manager;
// Items
$widget->add_render_attribute( 'counter-item',[
	'class' => [
		'cms-counter-sticky',
		'overflow-hidden',
		'd-flex gutter'
	]
]);
// Title
//$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', 'class', 'cms-counter-title cms-heading text-body text-19 empty-none' );
// Description
//$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', 'class', 'cms-counter-desc cms-heading text-heading text-17 mb-n7 empty-none' );
// Banner
$banner_custom_dimension = [
    'width'  => !empty($settings['banner_custom_dimension']['width']) ? $settings['banner_custom_dimension']['width'] : 510,
    'height' => !empty($settings['banner_custom_dimension']['height']) ? $settings['banner_custom_dimension']['height'] : 538
];
// Start layout 
?>
<div <?php etc_print_html($widget->get_render_attribute_string('counter-item')); ?>>
	<div class="col-5 col-tablet-6 col-mobile-extra-12 overflow-hidden" style="min-height:<?php echo esc_attr($banner_custom_dimension['height']); ?>px;">
	<div class="relative w-100 h-100" style="min-height:<?php echo esc_attr($banner_custom_dimension['height']); ?>px;">
		<?php 
			$count = 0;
			foreach ($counters as $key => $counter) {
				$count++;
				$count_class = ($count == 1) ? 'active' : '';
			//banner
			$counter['banner_size'] = $settings['banner_size']; // fix image size
			$counter['banner_custom_dimension'] = $banner_custom_dimension; // fix image size
		    // banner content 
		    ob_start();
			?>
				<div class="cms-contents bg-white cms-triangle-bt p-40">
					<?php 
						if($counter['show_icon'] === 'yes'){
				    ?>
					    <div class="cms-counter-icon text-primary pb-25 empty-none"><?php
						    // Counter Icon
							switch ($counter['icon_type']) {
								case 'image':
									fortis_elementor_image_render($counter, [
										'name'           => 'icon_image',
										'image_size_key' => 'icon_image',
										'custom_size'    => ['width' => 64, 'height' => 64]
									]);
									break;
								
								default:
									\Elementor\Icons_Manager::render_icon( $counter['counter_icon'], [ 'aria-hidden' => 'true' ] );
									break;
							}
						?></div>
					<?php }
					?>
					<div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
				</div>
			<?php
			$banner_content = ob_get_clean();
			// banner 
			fortis_elementor_image_render($counter, [
				'name'           => 'banner',
				'image_size_key' => '',
				'custom_size'    => $banner_custom_dimension,
				'max_height'	 => false,
				'img_class'	     => 'cms-overlay img-cover cms-radius-8',		
				'before'		 => '<div class="cms-counter-banner cms-transition absolute '.$count_class.'" style="min-height:'.$banner_custom_dimension['height'].'px;" id="cms-counter-'.$counter['_id'].'">',
				'after'          => $banner_content.'</div>'
			]);
		} // end foreach
		?>
	</div>
	</div>
	<div class="col-7 col-tablet-6 col-mobile-extra-12 pl-130 pl-tablet-20">
		<div class="cms-counter-numbers-wrapper">
			<?php 
				$count = 0;
				foreach ($counters as $key => $counter) {
					$count ++;
				//icon image
				$counter['icon_image_size'] = $settings['icon_image_size']; // fix image size
				$counter['icon_image_custom_dimension'] = $settings['icon_image_custom_dimension']; // fix image size
				//counter attr
				$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
				if($counter['ending_number'] === 0.63) {
					$counter['ending_number'] = 63;
					if(empty($counter['prefix'])) $counter['prefix'] = '0,';
				}
			    $widget->add_render_attribute( $data_counter, [
			        'class'          => 'cms-counter-number heading elementor-counter-number text-75',
			        'data-duration'  => $counter['duration'],
			        'data-to-value'  => $counter['ending_number'],
			        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
			    ] );
				?>
				<div class="counter-item <?php if($count === 1) echo 'active'; ?>" data-target="#cms-counter-<?php echo esc_attr($counter['_id']); ?>">
					<div class="counter--item d-flex justify-content-between align-items-center gutter cms-transition">
						<div class="cms-counter-numbers text-secondary flex-auto heading text-75 d-flex align-items-center">
						    <span class="cms-counter-number-prefix"><?php echo esc_html( $counter['prefix'] ); ?></span>
						    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
						    <span class="cms-counter-number-suffix"><?php echo esc_html( $counter['suffix'] ); ?></span>
						</div>
						<div class="cms-ounter-content text-end text-smobile-start flex-basic flex-smobile-100">
						    <div <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></div>
						</div>
					</div>
				</div>
			<?php
			} // end foreach
			?>
		</div>
	</div>
</div>

