<?php
$widget->add_inline_editing_attributes( 'text', 'none' );
$widget->add_inline_editing_attributes( 'text_link', 'none' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('text', [
	'class' => ['cms-desc']
]);
//Button
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta', [
	'class' => ['text-underline text-primary'],
	'href'	=> $url
]);
?>
<div class="cms-cta text-15 font-700">
	<span <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php etc_print_html($settings['text']) ?></span>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta' ) ); ?>>
		<?php 
			// text
			echo esc_html( $settings['link_text'] );
		?>
	</a>
</div>