<?php
$widget->add_render_attribute('title', [
	'class' => ['cms-title', 'cms-heading', 'text-24', 'text-white','mt-n7','pb-10','empty-none']
]);
$widget->add_inline_editing_attributes( 'title', 'none' );

// Text
$widget->add_render_attribute('text', [
	'class' => ['cms-desc', 'text-17', 'text-white', 'empty-none']
]);
$widget->add_inline_editing_attributes( 'text', 'none' );

//Button 
$widget->add_inline_editing_attributes( 'text_link', 'none' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('text', [
	'class' => ['cms-desc']
]);
//Button
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link_text', [
	'class' => ['btn btn-lg btn-white btn-hover-secondary'],
	'href'	=> $url
]);
?>
<div class="d-flex gap justify-content-between align-items-center">
	<div class="cms-cta-content flex-basic flex-mobile-extra-full">
		<div <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($settings['title']) ?></div>
		<div <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php echo nl2br($settings['text']) ?></div>
	</div>
	<div class="flex-auto">
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'link_text' ) ); ?>>
			<?php 
				// text
				echo esc_html( $settings['link_text'] );
			?>
			<i class="cms-icon cmsi-arrow-right rtl-flip text-10"></i>
		</a>
	</div>
</div>
