<?php
// Container
$widget->add_render_attribute('content_container', [
	'class' => [
		'cms-'.$widget->get_setting('content_container',''),
		'd-flex',
		'justify-content-'.$widget->get_setting('align'),
		'justify-content-laptop-'.$widget->get_setting('align_laptop'),
		'justify-content-tablet-extra-'.$widget->get_setting('align_tablet_extra'),
		'justify-content-tablet-'.$widget->get_setting('align_tablet'),
		'justify-content-mobile-extra-'.$widget->get_setting('align_mobile_extra'),
		'justify-content-mobile-'.$widget->get_setting('align_mobile'),

	]
]);
//
$widget->add_inline_editing_attributes( 'text', 'none' );
$widget->add_inline_editing_attributes( 'text_link', 'none' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('text', [
	'class' => ['cms-desc','empty-none']
]);
//Button
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta', [
	'class' => ['text-underline text-white text-hover-secondary'],
	'href'	=> $url
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('content_container')); ?>>
<div class="cms-cta text-15 font-700 text-white">
	<span <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php etc_print_html($settings['text']) ?></span>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta' ) ); ?>>
		<?php 
			// text
			echo esc_html( $settings['link_text'] );
		?>
	</a>
</div>
</div>