<?php
$widget->add_render_attribute('title', [
	'class' => ['cms-title', 'heading', 'text-21', 'font-500', 'text-white','mt-n7 pb-20','empty-none']
]);
$widget->add_inline_editing_attributes( 'title', 'none' );

$widget->add_render_attribute('description', [
	'class' => ['cms-desc', 'text-15', 'text-white', 'pb-20', 'empty-none']
]);
$widget->add_inline_editing_attributes( 'description', 'none' );
//Button
$page_link = $widget->get_setting('page_link','');
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta', [
	'class' => ['text-15 font-700 text-white text-hover-secondary d-flex gap-10 align-items-center','empty-none'],
	'href'	=> $url
]);
$widget->add_inline_editing_attributes( 'cta', 'none' );

// Banner
fortis_elementor_image_render($settings, [
	'name'        => 'banner',	
	'custom_size' => ['width' => '450','height' => '413'],
	'img_class'   => 'img-cover',
	'before'      => '<div class="cms-gradient-3 cms-overlay clip-path-3">',
	'after'       => '<div class="cms-gradient-render"></div></div>'
]);

?>
<div class="cms-cta-contents relative z-top p-80 p-tablet-40 p-lr-mobile-20">
	<div <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php etc_print_html($settings['title']) ?></div>
	<div <?php etc_print_html($widget->get_render_attribute_string('description')); ?>><?php etc_print_html($settings['text']) ?></div>
	<?php if(!empty($settings['link_text'])){ ?>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta' ) ); ?>>
		<i class="cms-icon cmsi-arrow-right fill-bg secondary size-32 circle rtl-flip"></i>
		<?php echo esc_html( $settings['link_text'] ); ?>
	</a>
	<?php } ?>
</div>