<?php
$widget->add_inline_editing_attributes( 'text', 'none' );
$widget->add_inline_editing_attributes( 'text_link', 'none' );

$widget->add_render_attribute('text', [
	'class' => ['cms-desc cms-cta text-15 font-700']
]);
//Button
$page_link = $widget->get_setting('page_link','');
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta', [
	'class' => ['btn btn-lg btn-secondary btn-hover-primary'],
	'href'	=> $url
]);
//Button2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
	case 'page':
		$page = !empty($link2_page) ? get_page_by_path($link2_page, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta2', [
	'class' => ['cms-link'],
	'href'	=> $url
]);
?>

<div <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php etc_print_html($settings['text']) ?></div>
<div class="cms-buttons d-flex gap pt-35 justify-content-<?php echo esc_attr($settings['align']); ?> justify-content-tablet-<?php echo esc_attr($settings['align_tablet']); ?>" style="--cms-gap:30px;">
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta' ) ); ?>>
		<?php 
			// text
			echo esc_html( $settings['link_text'] );
		?>
		<i class="cms-icon cmsi-arrow-right text-10 rtl-flip"></i>
	</a>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta2' ) ); ?>>
		<?php 
			// text
			echo esc_html( $settings['link2_text'] );
		?>
		<i class="cms-icon cmsi-arrow-alt-circle-right rtl-flip text-32 text-primary"></i>
	</a>
</div>
