<?php
$widget->add_inline_editing_attributes( 'text', 'none' );
$widget->add_inline_editing_attributes( 'text_link', 'none' );

$widget->add_render_attribute('text', [
	'class' => ['cms-desc cms-cta text-15']
]);
//Button
$page_link = $widget->get_setting('page_link','');
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta', [
	'class' => ['btn btn-lg btn-secondary btn-hover-primary mt-30'],
	'href'	=> $url
]);
?>

<div <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php echo nl2br($settings['text']) ?></div>
<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta' ) ); ?>>
	<?php 
		// text
		echo esc_html( $settings['link_text'] );
	?>
	<i class="cms-icon cmsi-arrow-right text-10 rtl-flip"></i>
</a>
