<?php
$widget->add_render_attribute('title', [
	'class' => ['cms-title', 'cms-heading', 'text-40 text-tablet-30', 'text-white','mt-n7 pb-145 pb-tablet-60','empty-none']
]);
$widget->add_inline_editing_attributes( 'title', 'none' );

// Text
$widget->add_render_attribute('text', [
	'class' => ['cms-desc', 'text-17', 'font-700','lh-1588', 'text-white', 'pb-35','empty-none']
]);
$widget->add_inline_editing_attributes( 'text', 'none' );

//Button 
$widget->add_inline_editing_attributes( 'text_link', 'none' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('text', [
	'class' => ['cms-desc']
]);
//Button
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link_text', [
	'class' => ['btn btn-lg text-secondary btn-hover-white'],
	'href'	=> $url
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('title')); ?>><?php echo nl2br($settings['title']) ?></div>
<div <?php etc_print_html($widget->get_render_attribute_string('text')) ?>><?php echo nl2br($settings['text']) ?></div>
<a <?php etc_print_html( $widget->get_render_attribute_string( 'link_text' ) ); ?>>
	<?php 
		// text
		echo esc_html( $settings['link_text'] );
	?>
	<i class="cmsi-arrow-right text-10 rtl-flip"></i>
</a>