<?php 
$download_lists = $widget->get_setting('download_lists', []);
?>
<div class="p-50 p-lr-tablet-extra-40 p-lr-tablet-30 p-lr-smobile-20 cms-shadow-3 divider-bot">
	<h4 class="cms-title text-heading-darken pb-7 empty-none"><?php etc_print_html($settings['title']); ?></h4>
	<div class="cms-download-list d-flex gap-20"><?php 
		foreach ($download_lists as $key => $download) {
			$download_key = $widget->get_repeater_setting_key( 'link', 'cms_download_link', $key );
            $widget->add_link_attributes( $download_key, $download['link'] );
            $widget->add_render_attribute($download_key, [
            	'class' => [
            		'cms-dowload-item',
            		'd-flex align-items-center gap-20',
            		'text-15 font-700',
            		'w-100'
            	]
            ]);
        ?>
        	<a <?php etc_print_html($widget->get_render_attribute_string($download_key)) ?>><i class="cms-icon cmsi-pdf text-32"></i><?php etc_print_html($download['name']); ?></a>
        <?php
		}
	?></div>
</div>