<?php
use Elementor\Icons_Manager;

$widget->add_render_attribute( 'title', 'class', 'cms-title text-19 font-500' );
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc text-16',
		'text-line-4'
	]
]);

if ( ! empty( $settings['btn_link']['url'] ) ) {
	$widget->add_render_attribute( 'btn_text', 'href', $settings['btn_link']['url'] );

	$widget->add_render_attribute('btn_text', [
		'class' => 'cms-fancy-btn'
	]);
}

$widget->add_inline_editing_attributes( 'title' );
$widget->add_inline_editing_attributes( 'description' );
$widget->add_inline_editing_attributes( 'btn_text' );
?>

<?php 
	switch ($settings['icon_type']) {
		case 'image':
			fortis_elementor_image_render($settings, [
				'name'           => 'icon_image',
				'image_size_key' => 'icon_image',
				'img_class'      => 'cms-icon mb-25', 
				'custom_size'    => ['width' => 64, 'height' => 64]
			]);
			break;
		
		case 'icon':
			\Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon text-64 text-heading-darken mb-25' ] );
			break;
	}
?>
<div class="cms-fb-content">
    <h3 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $settings['title'] ); ?></h3>
    <div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo wpautop( $settings['description'] ); ?></div>
	<?php if ( ! empty( $settings['btn_text'] ) ) : ?>
        <a <?php etc_print_html( $widget->get_render_attribute_string( 'btn_text' ) ); ?>><?php echo esc_attr( $settings['btn_text'] ); ?></a>
	<?php endif; ?>
</div>