<?php
use Elementor\Icons_Manager;

$widget->add_render_attribute( 'title', 'class', 'cms-title text-19' );
$widget->add_render_attribute( 'description', 'class', 'cms-desc text-16' );

if ( ! empty( $settings['btn_link']['url'] ) ) {
	$widget->add_render_attribute( 'btn_text', 'href', $settings['btn_link']['url'] );

	$widget->add_render_attribute('btn_text', [
		'class' => 'cms-fancy-btn'
	]);
}

$widget->add_inline_editing_attributes( 'title' );
$widget->add_inline_editing_attributes( 'description' );
$widget->add_inline_editing_attributes( 'btn_text' );
?>
<div class="cms-fb-content cms-shadow-2 p-40 bg-white">
    <h3 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo nl2br( $settings['title'] ); ?></h3>
    <div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo nl2br( $settings['description'] ); ?></div>
	<?php if ( ! empty( $settings['btn_text'] ) ) : ?>
        <a <?php etc_print_html( $widget->get_render_attribute_string( 'btn_text' ) ); ?>><?php echo esc_attr( $settings['btn_text'] ); ?></a>
	<?php endif; ?>
</div>