<?php 
$randGallery = $widget->get_setting('gallery', []);
if ($settings['gallery_rand'] == 'rand'){
    shuffle($randGallery);
}
$col_xl = 12 / intval($widget->get_setting('gallery_col', 3));
$col_lg = 12 / intval($widget->get_setting('gallery_col_tablet', 2));
$col_sm = 12 / intval($widget->get_setting('gallery_col_mobile', 2));

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['gallery_custom_dimension']['width']) ? $settings['gallery_custom_dimension']['width'] : 400,
    'height' => !empty($settings['gallery_custom_dimension']['height']) ? $settings['gallery_custom_dimension']['height'] : 267
];
?>
<div class="cms-image-gallery clearfix" data-show="<?php echo esc_attr($widget->get_setting('gallery_show', '6'));?>" data-loadmore="<?php echo esc_attr($widget->get_setting('gallery_loadmore_show', '6'));?>">
    <div class="d-flex gutter cms-images-light-box" style="--gutter:<?php echo esc_attr($widget->get_setting('gap',40));?>px;--gutter-mobile:20px;">
        <?php
        foreach ( $randGallery as $key => $value):
        	$value['gallery_size'] = $settings['gallery_size'];
        	$value['gallery_custom_dimension'] = $thumbnail_custom_dimension;
        	$value['gallery'] = $value;
            $item_class = "cms-gallery-item col-mobile-{$col_sm} col-tablet-{$col_lg} col-{$col_xl} col-smobile-12";
            ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <a data-elementor-lightbox-slideshow="<?php echo esc_attr($settings['element_id']);?>" class="grid-item-inner cms-galleries-light-box relative d-flex cms-gradient-hover-8" href="<?php echo esc_url(wp_get_attachment_image_url($value['id'], 'full')); ?>" title="<?php echo esc_attr(wp_get_attachment_caption($value['id']))?>">
                    <div class="cms-gradient-render"></div>
                	<?php 
                        fortis_elementor_image_render($value,[
							'name'        => 'gallery',
							'img_class'   => '',
							'custom_size' => $thumbnail_custom_dimension,
						]);
                    ?>
                    <span class="cms-icon absolute center cmsi-plus cms-transition"></span>
                </a>
            </div>
        <?php
        endforeach;
        ?>
    </div>
    <?php if(count($randGallery) > $widget->get_setting('gallery_show', '6')): ?>
        <div class="text-center pt-40">
            <a href="#" class="cms-gallery-load btn btn-lg btn-outline btn-2"><?php etc_print_html($widget->get_setting('load_more_text', 'Load More')); ?></a>
        </div>
    <?php endif; ?>
</div>