<?php 
use \Elementor\Icons_Manager;

$randGallery = $widget->get_setting('gallery', []);
if(empty($randGallery)) return;

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['gallery_custom_dimension']['width']) ? $settings['gallery_custom_dimension']['width'] : 400,
    'height' => !empty($settings['gallery_custom_dimension']['height']) ? $settings['gallery_custom_dimension']['height'] : 400
];

$arrows = $widget->get_setting('arrows');
$dots   = $widget->get_setting('dots');
?>
<div class="cms-carousel swiper">
    <div class="swiper-wrapper">
        <?php 
            foreach ( $randGallery as $key => $value):
                $value['gallery_size'] = $settings['gallery_size'];
                $value['gallery_custom_dimension'] = $thumbnail_custom_dimension;
                $value['gallery'] = $value;
                $item_class = "cms-swiper-item swiper-slide";
            ?>
                <div class="<?php echo esc_attr($item_class); ?>">
                    <a data-elementor-lightbox-slideshow="<?php echo esc_attr($settings['element_id']);?>" class="grid-item-inner cms-galleries-light-box relative d-flex cms-gradient-hover-8" href="<?php echo esc_url(wp_get_attachment_image_url($value['id'], 'full')); ?>" title="<?php echo esc_attr(wp_get_attachment_caption($value['id']))?>">
                        <div class="cms-gradient-render"></div>
                        <?php 
                            fortis_elementor_image_render($value,[
                                'name'        => 'gallery',
                                'img_class'   => 'swiper-nav-vert img-cover',
                                'custom_size' => $thumbnail_custom_dimension,
                            ]);
                        ?>
                        <span class="cms-icon absolute center cmsi-plus cms-transition"></span>
                    </a>
                </div>
            <?php
            endforeach;
        ?>
    </div>
    <?php if ($arrows == 'yes') : ?>
    <div class="cms-carousel-button-in-vert prev cms-carousel-button-prev">
        <?php
        $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
        if (empty($icon_settings['value'])) {
            $icon_settings = [
                'library' => 'eicons',
                'value'   => 'eicon-chevron-left',
            ];
        }
        Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
        ?>
    </div>
    <div class="cms-carousel-button-in-vert next cms-carousel-button-next">
        <?php
        $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
        if (empty($icon_settings['value'])) {
            $icon_settings = [
                'library' => 'eicons',
                'value'   => 'eicon-chevron-right',
            ];
        }
        Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
        ?>
    </div>
    <?php endif ?>
    <?php if ($dots == 'yes') : ?>
        <div class="cms-carousel-dots cms-carousel-dots-out justify-content-center"></div>
    <?php endif ?>
</div>