<?php
// Inline Edit
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_inline_editing_attributes( 'subheading_text' );
$widget->add_inline_editing_attributes( 'description_text' );

// Small Heading
$widget->add_render_attribute( 'subheading_text', 'class', 'cms-smalheading empty-none font-700 text-16 text-primary pl-110 pl-tablet-extra-0' );
// Large Heading
$widget->add_render_attribute( 'heading_text', [
	'class' => 'cms-heading text-heading-darken font-600 empty-none' 
]);
// Description Bold
$widget->add_render_attribute( 'description_bold_text', 'class', 'cms-desc cms-desc-bold text-heading-lighten text-17 font-700 pb-25 empty-none' );
// Description
$widget->add_render_attribute( 'description_text', 'class', 'cms-desc text-17 empty-none' );
// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
	case 'page':
		$page = !empty($link1_page) ? get_page_by_path($link1_page, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link1-attrs', [
	'class' => [
		'btn btn-lg',
		'btn-primary btn-hover-secondary text-secondary text-hover-white',
		'icon-last'
	],
	'href'	=> $url
]);
// Link 2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
	case 'page':
		$page = !empty($link2_page) ? get_page_by_path($link2_page, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link2-attrs', [
	'class' => [
		'btn btn-lg',
		'btn-outline btn-1',
		'icon-last'
	],
	'href'	=> $url
]);
// Feature
$features = $widget->get_setting('cms_feature', []);

// Start Content
?>
<div class="d-flex gutter">
	<div class="col-7 col-tablet-12">
		<?php if ( ! empty( $settings['subheading_text'] ) ) : ?>
		    <div <?php etc_print_html( $widget->get_render_attribute_string( 'subheading_text' ) ); ?>><?php echo etc_print_html( $settings['subheading_text'] ); ?></div>
		<?php endif; ?>

		<?php if ( ! empty( $settings['heading_text'] ) ) { ?>
		<<?php etc_print_html( $settings['heading_size'] ); ?> <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>>
			<?php etc_print_html( $settings['heading_text'] ); ?>
		</<?php etc_print_html( $settings['heading_size'] ); ?>>
		<?php } ?>
	</div>
	<?php 
	// Banner
	ob_start();
	if(!empty($settings['banner_icon']['value']) || !empty($settings['banner_title'])){
	?>
	<div class="banner-content">
		<?php \Elementor\Icons_Manager::render_icon( $settings['banner_icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon' ] ); ?>
		<div class="heading font-600"><?php etc_print_html($settings['banner_title']); ?></div>
	</div>
	<?php }
	$banner_content = ob_get_clean();

    fortis_elementor_image_render($settings, [
    	'name'		  => 'banner',	
    	'custom_size' => ['width' => 620,'height' => 410],
    	'max_height'  => true,		
    	'img_class'   => 'img-cover',
    	'before'	  => '<div class="cms-heading-banner col-7 col-tablet-12"><div class="cms-heading--banner relative ml-110 ml-tablet-extra-0">',		
    	'after' 	  => $banner_content.'</div></div>'	
    ]);
	?>
	<div class="cms-desc-wrap col-5 col-tablet-12 mt-n75 mt-tablet-n0">
		<div class="cms-desc--wrap pl-70 pl-tablet-extra-0">
			<?php if ( ! empty( $settings['description_bold_text'] ) ) : ?>
				<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_bold_text' ) ); ?>><?php echo wp_kses_post( $settings['description_bold_text'] ); ?></div>
			<?php endif; ?>

			<?php if ( ! empty( $settings['description_text'] ) ) : ?>
				<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo wp_kses_post( $settings['description_text'] ); ?></div>
			<?php endif; ?>
			
			<div class="cms-heading-buttons d-flex gap" style="--cms-gap:30px;">
				<?php if(!empty($settings['link1_text'])) { ?>
				<a <?php etc_print_html( $widget->get_render_attribute_string( 'link1-attrs' ) ); ?>>
					<i class="cms-btn-icon cmsi-arrow-right rtl-flip text-10"></i>
					<?php echo esc_html( $settings['link1_text'] ); ?>
				</a>
				<?php }
				if(!empty($settings['link2_text'])){ 
			 	?>
			 	<a <?php etc_print_html( $widget->get_render_attribute_string( 'link2-attrs' ) ); ?>>
					<?php echo esc_html( $settings['link2_text'] ); ?>
				</a>
				<?php } ?>
			</div>
			<div class="cms-heading-features cms-lists-1">
			<?php 
				foreach ( $features as $key => $cms_feature ):
					$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
					$widget->add_render_attribute($title_key, 'class', 'flex-basic');
					$widget->add_inline_editing_attributes( $title_key, 'none' );
				?>
			        <div class="cms-list d-flex">
			            <?php 
			            	\Elementor\Icons_Manager::render_icon( $cms_feature['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon flex-auto' ] ); 
			            ?>
			            <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_feature['title'] ) ?></span>
			        </div>
				<?php endforeach;
			?>
			</div>
		</div>
	</div>
</div>