<?php
// Inline Edit
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_inline_editing_attributes( 'subheading_text' );
$widget->add_inline_editing_attributes( 'description_bold_text' );

// Small Heading
$widget->add_render_attribute( 'subheading_text', 'class', 'cms-smalheading empty-none font-700 text-16 text-primary' );
// Large Heading
$widget->add_render_attribute( 'heading_text', [
	'class' => 'cms-heading text-white font-600 empty-none pb-20' 
]);
// Description Bold
$widget->add_render_attribute( 'description_bold_text', 'class', 'cms-desc cms-desc-bold text-white text-17 font-700 empty-none' );

// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
	case 'page':
		$page = !empty($link1_page) ? get_page_by_path($link1_page, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link1-attrs', [
	'class' => [
		'btn btn-lg',
		'btn-white btn-hover-primary',
		'icon-last'
	],
	'href'	=> $url
]);
// Link 2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
	case 'page':
		$page = !empty($link2_page) ? get_page_by_path($link2_page, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link2-attrs', [
	'class' => [
		'btn btn-lg',
		'btn-outline btn-3',
		'icon-last'
	],
	'href'	=> $url
]);

// Start Content
?>
<div <?php etc_print_html( $widget->get_render_attribute_string( 'subheading_text' ) ); ?>><?php 
	echo etc_print_html( $settings['subheading_text'] ); 
?></div>
<<?php etc_print_html( $settings['heading_size'] ); ?> <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>>
	<?php etc_print_html( $settings['heading_text'] ); ?>
</<?php etc_print_html( $settings['heading_size'] ); ?>>
<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_bold_text' ) ); ?>><?php 
	echo wp_kses_post( $settings['description_bold_text'] ); 
?></div>
<div class="cms-heading-buttons d-flex gap" style="--cms-gap:30px;">
	<?php if(!empty($settings['link1_text'])) { ?>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'link1-attrs' ) ); ?>>
		<i class="cms-btn-icon cmsi-arrow-right rtl-flip text-10"></i>
		<?php echo esc_html( $settings['link1_text'] ); ?>
	</a>
	<?php }
	if(!empty($settings['link2_text'])){ 
		?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'link2-attrs' ) ); ?>>
		<?php echo esc_html( $settings['link2_text'] ); ?>
	</a>
	<?php } ?>
</div>