<?php
use Elementor\Icons_Manager;

$settings['num_words'] = !empty($settings['num_words']) ? $settings['num_words'] : 25;
$settings['readmore_text'] = !empty($settings['readmore_text']) ? $settings['readmore_text'] : esc_html__('Explore More', 'fortis');

$html_id  = etc_get_element_id($settings);
$source   = $widget->get_setting('source', '');
$orderby  = $widget->get_setting('orderby', 'date');
$order    = $widget->get_setting('order', 'desc');
$limit    = $widget->get_setting('limit', 6);
extract(etc_get_posts_of_grid( 'cms-industry', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
]));

$arrows = $widget->get_setting('arrows');

$title_tag = $widget->get_setting('title_tag', 'h3');

$thumbnail_size             = $widget->get_setting('thumbnail_size', 'custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 570,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height'] : 380
];
$num_words                  = $widget->get_setting('num_words', '');
$readmore_text              = $settings['readmore_text'];

$posts_data = array(
    'layout'                     => $widget->get_setting('layout', '3'),
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_words'                  => $num_words,
    'readmore_text'              => $readmore_text
);
?>
<?php if (is_array($posts)) : ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="cms-post-carousel">
        <div class="cms-carousel swiper">
            <div class="swiper-wrapper">
                <?php
                    fortis_get_post_grid($settings, $posts, $posts_data,[
                        'item_class' => 'cms-swiper-item swiper-slide'
                    ]);
                ?>
            </div>
            <?php if ($arrows == 'yes') : ?>
                <div class="cms-carousel-navs d-flex gap justify-content-end" style="--cms-gap:20px;--cms-gap-tablet:20px;">
                    <div class="cms-carousel-button-circle-2 prev cms-carousel-button-prev rtl-flip">
                        <?php
                        $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
                        if (empty($icon_settings['value'])) {
                            $icon_settings = [
                                'library' => 'cmsi',
                                'value'   => 'cmsi-arrow-left',
                            ];
                        }
                        Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                        ?>
                    </div>
                    <div class="cms-carousel-button-circle-2 next cms-carousel-button-next rtl-flip">
                        <?php
                        $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
                        if (empty($icon_settings['value'])) {
                            $icon_settings = [
                                'library' => 'cmsi',
                                'value'   => 'cmsi-arrow-right',
                            ];
                        }
                        Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                        ?>
                    </div>
                </div>
            <?php endif ?>
        </div>
    </div>
<?php endif; ?>