<?php
use Elementor\Icons_Manager;

$settings['num_words'] = !empty($settings['num_words']) ? $settings['num_words'] : 25;
$settings['readmore_text'] = !empty($settings['readmore_text']) ? $settings['readmore_text'] : esc_html__('Explore More', 'fortis');

$html_id  = etc_get_element_id($settings);
$source   = $widget->get_setting('source', '');
$orderby  = $widget->get_setting('orderby', 'date');
$order    = $widget->get_setting('order', 'desc');
$limit    = $widget->get_setting('limit', 6);
extract(etc_get_posts_of_grid( 'cms-industry', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
]));

$arrows = $widget->get_setting('arrows');

$title_tag = $widget->get_setting('title_tag', 'h3');

$thumbnail_size             = $widget->get_setting('thumbnail_size', 'custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : '400',
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height'] : '498'
];
$num_words                  = $widget->get_setting('num_words', '');
$readmore_text              = $settings['readmore_text'];

$posts_data = array(
    'layout'                     => $widget->get_setting('layout', '3'),
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_words'                  => $num_words,
    'readmore_text'              => $readmore_text
);

// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
    case 'page':
        $page = !empty($link1_page) ? get_page_by_path($link1_page, OBJECT) : [];
        $url  = !empty($page) ? get_permalink($page->ID) : '#';
        break;
    
    default:
        $url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
        break;
}
$widget->add_render_attribute( 'link1-attrs', [
    'class' => [
        'btn btn-lg',
        'btn-white btn-hover-primary',
        'icon-last'
    ],
    'href'  => $url
]);
// Link 2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
    case 'page':
        $page = !empty($link2_page) ? get_page_by_path($link2_page, OBJECT) : [];
        $url  = !empty($page) ? get_permalink($page->ID) : '#';
        break;
    
    default:
        $url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
        break;
}
$widget->add_render_attribute( 'link2-attrs', [
    'class' => [
        'btn btn-lg',
        'btn-outline btn-3',
        'icon-last'
    ],
    'href'  => $url
]);

?>
<?php if (is_array($posts)) : ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="cms-post-carousel">
        <div class="cms-carousel swiper">
            <div class="swiper-wrapper">
                <?php
                    fortis_get_post_grid($settings, $posts, $posts_data,[
                        'item_class' => 'cms-swiper-item swiper-slide'
                    ]);
                ?>
            </div>
            <div class="cms-swiper-attrs">
                <div class="d-flex gutter pt-40 p-lr-tablet-20">
                    <div class="cms-custom-content flex-basic">
                        <div class="cms-desc text-15 font-700 text-white"><?php etc_print_html($settings['text']); ?></div>
                        <div class="cms-heading-buttons d-flex gap" style="--cms-gap:30px;">
                            <?php if(!empty($settings['link1_text'])) { ?>
                            <a <?php etc_print_html( $widget->get_render_attribute_string( 'link1-attrs' ) ); ?>>
                                <i class="cms-btn-icon cmsi-arrow-right rtl-flip text-10"></i>
                                <?php echo esc_html( $settings['link1_text'] ); ?>
                            </a>
                            <?php }
                            if(!empty($settings['link2_text'])){ 
                            ?>
                            <a <?php etc_print_html( $widget->get_render_attribute_string( 'link2-attrs' ) ); ?>>
                                <?php echo esc_html( $settings['link2_text'] ); ?>
                            </a>
                            <?php } ?>
                        </div>
                    </div>
                    <?php if ($arrows == 'yes') : ?>
                        <div class="cms-carousel-navsx d-flex gap justify-content-end order-tablet-first flex-auto col-tablet-12" style="--cms-gap:20px;--cms-gap-tablet:20px;">
                            <div class="cms-carousel-button-circle-2 prev cms-carousel-button-prev hover-primary rtl-flip">
                                <?php
                                $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
                                if (empty($icon_settings['value'])) {
                                    $icon_settings = [
                                        'library' => 'cmsi',
                                        'value'   => 'cmsi-arrow-left',
                                    ];
                                }
                                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                                ?>
                            </div>
                            <div class="cms-carousel-button-circle-2 next cms-carousel-button-next hover-primary rtl-flip">
                                <?php
                                $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
                                if (empty($icon_settings['value'])) {
                                    $icon_settings = [
                                        'library' => 'cmsi',
                                        'value'   => 'cmsi-arrow-right',
                                    ];
                                }
                                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                                ?>
                            </div>
                        </div>
                    <?php endif ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>