<?php
$cms_lists = $widget->get_setting('cms_list', []);
// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
    case 'page':
        $page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
        $url  = !empty($page) ? get_permalink($page->ID) : '#';
        break;
    
    default:
        $url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
        break;
}
$widget->add_render_attribute( 'link1-attrs', [
    'class' => [
        'btn btn-lg btn-secondary btn-hover-primary',
        'icon-last'
    ],
    'href'  => $url
]);
// Link 2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
    case 'page':
        $page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
        $url  = !empty($page) ? get_permalink($page->ID) : '#';
        break;
    
    default:
        $url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
        break;
}
$widget->add_render_attribute( 'link2-attrs', [
    'class' => [
        'btn btn-lg',
        'btn-outline btn-2',
        'icon-last'
    ],
    'href'  => $url
]);
// HTML
foreach ( $cms_lists as $key => $cms_list ):
	$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
	$widget->add_render_attribute( $title_key, [
        'class' => ['flex-basic']
    ]);
	$widget->add_inline_editing_attributes( $title_key, 'none' );
?>
    <div class="cms-list d-flex">
        <?php \Elementor\Icons_Manager::render_icon( $cms_list['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon flex-auto' ] ); ?>
        <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_list['title'] ) ?></span>
    </div>
<?php endforeach; ?>
<div class="cms-list-buttons d-flex gap pt-50 empty-none" style="--cms-gap:30px;"><?php 
    if(!empty($settings['link1_text'])) { ?>
    <a <?php etc_print_html( $widget->get_render_attribute_string( 'link1-attrs' ) ); ?>>
        <i class="cms-btn-icon cmsi-arrow-right rtl-flip text-10"></i>
        <?php echo esc_html( $settings['link1_text'] ); ?>
    </a>
    <?php }
    if(!empty($settings['link2_text'])){ 
        ?>
        <a <?php etc_print_html( $widget->get_render_attribute_string( 'link2-attrs' ) ); ?>>
        <?php echo esc_html( $settings['link2_text'] ); ?>
    </a>
    <?php } 
?></div>