<?php
$cms_lists = $widget->get_setting('cms_list', []);

foreach ( $cms_lists as $key => $cms_list ):
	$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
	$widget->add_render_attribute( $title_key, [
        'class' => ['flex-basic','text-16', 'mt-n7 mb-n7','text-line-3']
    ]);
	$widget->add_inline_editing_attributes( $title_key, 'none' );
?>
    <div class="cms-list d-flex gap" style="--cms-gap:40px;--cms-gap-mobile:20px;">
        <?php \Elementor\Icons_Manager::render_icon( $cms_list['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon text-64 flex-auto' ] ); ?>
        <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_list['title'] ) ?></span>
    </div>
<?php endforeach; ?>