<?php
$cms_lists = $widget->get_setting('cms_list45', []);

// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
    case 'page':
        $page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
        $url  = !empty($page) ? get_permalink($page->ID) : '#';
        break;
    
    default:
        $url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
        break;
}
$widget->add_render_attribute( 'link1-attrs', [
    'class' => [
        'btn btn-lg',
        'icon-last'
    ],
    'href'  => $url
]);
// Link 2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
    case 'page':
        $page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
        $url  = !empty($page) ? get_permalink($page->ID) : '#';
        break;
    
    default:
        $url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
        break;
}
$widget->add_render_attribute( 'link2-attrs', [
    'class' => [
        'btn btn-lg',
        'btn-outline btn-1',
        'icon-last'
    ],
    'href'  => $url
]);
?>
<div><?php
// Start Content
$count = 0;
foreach ( $cms_lists as $key => $cms_list ):
    $count ++;
    if($count < 10) $count = '0'.$count;

	$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
	$widget->add_render_attribute( $title_key, [
        'class' => ['cms-heading','text-19', 'mt-n7', 'empty-none']
    ]);
	$widget->add_inline_editing_attributes( $title_key, 'none' );
    // desc
    $desc_key = $widget->get_repeater_setting_key( 'desc', 'cms_list', $key );
    $widget->add_render_attribute( $desc_key, [
        'class' => ['cms-desc','text-16 pt-15', 'mb-n7', 'empty-none']
    ]);
    $widget->add_inline_editing_attributes( $desc_key, 'none' );
?>
    <div class="cms-list">
        <div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_list['title'] ) ?></div>
        <div <?php etc_print_html( $widget->get_render_attribute_string( $desc_key ) ); ?>><?php echo esc_html( $cms_list['desc'] ) ?></div>
        <span class="cms-list-counter"><?php etc_print_html($count); ?></span>
    </div>
<?php endforeach;
?></div>
<div class="cms-list-buttons d-flex gap pt-60" style="--cms-gap:30px;">
    <?php if(!empty($settings['link1_text'])) { ?>
    <a <?php etc_print_html( $widget->get_render_attribute_string( 'link1-attrs' ) ); ?>>
        <i class="cms-btn-icon cmsi-arrow-right rtl-flip text-10"></i>
        <?php echo esc_html( $settings['link1_text'] ); ?>
    </a>
    <?php }
    if(!empty($settings['link2_text'])){ 
        ?>
        <a <?php etc_print_html( $widget->get_render_attribute_string( 'link2-attrs' ) ); ?>>
        <?php echo esc_html( $settings['link2_text'] ); ?>
    </a>
    <?php } ?>
</div>