<?php
$cms_lists = $widget->get_setting('cms_list', []);
?>
<div class="d-flex gutter flex-col-2 flex-col-mobile-1">
<?php 
foreach ( $cms_lists as $key => $cms_list ):
	$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
	$widget->add_render_attribute( $title_key, [
        'class' => ['text-16']
    ]);
	$widget->add_inline_editing_attributes( $title_key, 'none' );
?>
    <div class="cms-list cms-anim-icon">
        <?php \Elementor\Icons_Manager::render_icon( $cms_list['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon text-64 text-primary pb-20'] ); ?>
        <div <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_list['title'] ) ?></div>
    </div>
<?php endforeach; ?>
</div>