<?php
	// Title
	$page_link = $widget->get_setting('page_link','');
	//Link
	switch ($settings['link_type']) {
		case 'page':
			$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
			$url  = !empty($page) ? get_permalink($page->ID) : '#';
			break;
		
		default:
			$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
			break;
	}
	
	$widget->add_inline_editing_attributes( 'title' );
	$widget->add_render_attribute( 'title', [
		'class' => 'cms-etitle cms-title h5',
		'href'	=> $url
	]);
	// Menu
	$menu = $widget->get_setting('menu','');
	if ( ! empty( $menu ) ) : ?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>>
			<?php echo etc_print_html( $settings['title'] ); ?>
        </a>
		<?php 
			wp_nav_menu( array(
				'fallback_cb'     => '',
				'walker'          => '',
				'container'		  => '',
				'container_class' => '',
				'menu'            => $menu,
				'menu_class'      => 'cms-dropdown-mega',
				'depth'           => 1
			)); 
		?>
<?php 
	endif; 
?>