<?php
// Title
$widget->add_render_attribute( 'title', [
	'class' => [
		'cms-title',
		'text-75 text-tablet-50 text-mobile-40 font-600',
		'text-white',
		'w-100'
	]
]);
// Description
$widget->add_render_attribute( 'description', [
	'class' => [
		'cms-desc',
		'text-17 font-700',
		'text-white'
	]
]);
// Button
$page_link = $widget->get_setting('page_link','');
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link_text', [
	'class' => [
		'btn btn-white btn-hover-primary btn-lg'
	],
	'href'	=> $url
]);

// Button #2
$page2_link = $widget->get_setting('page2_link','');
switch ($settings['link2_type']) {
	case 'page':
		$page2 = !empty($page2_link) ? get_page_by_path($page2_link, OBJECT) : [];
		$url2  = !empty($page2) ? get_permalink($page2->ID) : '#';
		break;
	
	default:
		$url2 = $widget->get_setting('custom2_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link2_text', [
	'class' => [
		'btn btn-outline white btn-lg'
	],
	'href'	=> $url2
]);

// Inline Edit
$widget->add_inline_editing_attributes( 'title', 'none' );
$widget->add_inline_editing_attributes( 'description' );
$widget->add_inline_editing_attributes( 'link_text' );

// Render Image
$settings['bg_image']['id'] = !empty($settings['bg_image']['id']) ? $settings['bg_image']['id'] : get_post_thumbnail_id();
fortis_elementor_image_render($settings,[
	'name'        => 'bg_image',
	'img_class'   => 'img-cover cms-overlay',
	'custom_size' => ['width' => '', 'height' => ''],
	'after'		  => '<div class="cms-eptitle-overlay cms-overlay"></div>'	
]);
?>
<div class="cms-content relative z-top container-full">
	<div class="cms--content d-flex justify-content-center">
		<h1 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php echo etc_print_html( $widget->get_setting('title', get_the_title()) ); ?></h1>
		<div <?php etc_print_html( $widget->get_render_attribute_string( 'description' ) ); ?>><?php echo etc_print_html( $settings['description'] ); ?></div>
		<div class="d-flex gap empty-none pt-30 justify-content-center w-100" style="--cms-gap:30px;--cms-gap-tablet:30px;--cms-gap-mobile:20px;"><?php
			// Button #1
			if ( ! empty( $settings['link_text'] ) ) : ?>
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'link_text' ) ); ?>>
				<?php  // text
					echo esc_html( $settings['link_text'] );
				?>
				<i class="cmsi-arrow-right rtl-flip text-10"></i>
			</a>
			<?php endif; 
			if ( ! empty( $settings['link2_text'] ) ) : ?>
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'link2_text' ) ); ?>>
				<?php  // text
					echo esc_html( $settings['link2_text'] );
				?>
			</a>
			<?php endif; 
			// Video
			fortis_elementor_button_video_render($widget, $settings, [
				'name'   => 'video_link',
				'icon'   => $widget->get_setting('video_icon')['value'],
				'text'   => $widget->get_setting('video_text','How it works'),
				'layout' => '3',
				'class'  => '',
				'echo'	 => true
		    ])
		?></div>
	</div>
	<?php fortis_breadcrumb(['class' => 'text-white justify-content-center']); ?>
</div>