<?php
global $post;
$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
$next     = get_adjacent_post( false, '', false );

if ( ! $next && ! $previous ) {
	return;
}
?>
<?php
$next_post     = get_next_post();
$previous_post = get_previous_post();

if ( ! empty( $settings['link']['url'] ) ) {
	$widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

	if ( $settings['link']['is_external'] ) {
		$widget->add_render_attribute( 'link', 'target', '_blank' );
	}

	if ( $settings['link']['nofollow'] ) {
		$widget->add_render_attribute( 'link', 'rel', 'nofollow' );
	}
}

$link_attributes = $widget->get_render_attribute_string( 'link' );

if ( ! empty( $next_post ) || ! empty( $previous_post ) ) { ?>
    <div class="ct-portfolio-navigation">
		<?php if ( is_a( $previous_post, 'WP_Post' ) && get_the_title( $previous_post->ID ) != '' ) { ?>
            <div class="nav-item nav-post-prev">
                <div class="nav-item-icon">
                    <a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>"><i
                                class="fac fa-angle-left"></i></a>
                </div>
                <div class="nav-item-meta">
                    <label><?php echo esc_html__( 'Previous Project', 'fortis' ); ?></label>
                    <a href="<?php echo esc_url( get_permalink( $previous_post->ID ) ); ?>"><?php echo get_the_title( $previous_post->ID ); ?></a>
                </div>
            </div>
		<?php } ?>
		<?php if ( is_a( $next_post, 'WP_Post' ) && get_the_title( $next_post->ID ) != '' ) { ?>
            <div class="nav-item nav-post-next">
                <div class="nav-item-meta">
                    <label><?php echo esc_html__( 'Next Project', 'fortis' ); ?></label>
                    <a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>"><?php echo get_the_title( $next_post->ID ); ?></a>
                </div>
                <div class="nav-item-icon">
                    <a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>"><i
                                class="fac fa-angle-right"></i></a>
                </div>
            </div>
		<?php } ?>
    </div>
<?php }