<?php 
// Feature
$features = $widget->get_setting('cms_feature', []);
// Link 1
$link1_page = $widget->get_setting('link1_page','');
switch ($settings['link1_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link1_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link1-attrs', [
	'class' => [
		'btn btn-lg',
		'btn-white btn-hover-'.$widget->get_setting('link1_hover','primary')
	],
	'href'	=> $url
]);
// Link 2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link2-attrs', [
	'class' => [
		'btn btn-lg',
		'btn-outline white btn-2'
	],
	'href'	=> $url
]);
// Background Image
$banner_gradient = $widget->get_setting('banner_gradient', 4);
fortis_elementor_image_render($settings,[
	'name'        => 'banner',
	'img_class'   => 'img-cover',
	'custom_size' => ['width' => 400, 'height' => 570],
	'before'	  => '<div class="cms-gradient cms-gradient-'.$banner_gradient.' cms-overlay">',
	'after'		  => '<div class="cms-gradient-render"></div></div>'		
]);
?>
<div class="p-tb-70 p-lr-40 p-lr-smobile-20 cms-shadow-4 relative z-top text-white">
	<div class="cms-smallheading font-700 pb-15 empty-none"><?php etc_print_html($settings['subheading_text']) ?></div>
	<div class="cms-heading text-23 text-white empty-none"><?php etc_print_html($settings['heading_text']) ?></div>
	<div class="cms-desc text-15 pt-15 empty-none"><?php etc_print_html($settings['description_text']) ?></div>
	<div class="cms-pricing-features cms-lists-8 pt-30 empty-none">
		<?php 
			foreach ( $features as $key => $cms_feature ):
				$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
				$widget->add_render_attribute($title_key, 'class', 'flex-basic');
				$widget->add_inline_editing_attributes( $title_key, 'none' );
			?>
		        <div class="cms-list d-flex">
		            <?php 
		            	\Elementor\Icons_Manager::render_icon( $cms_feature['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon flex-auto' ] ); 
		            ?>
		            <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_feature['title'] ) ?></span>
		        </div>
			<?php endforeach;
		?>
	</div>
	<div class="cms-pricing-buttons d-flex gap pt-35 empty-none" style="--cms-gap:30px;">
		<?php if(!empty($settings['link1_text'])) { ?>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'link1-attrs' ) ); ?>>
			<i class="cms-btn-icon cmsi-arrow-alt-circle-right rtl-flip text-26"></i>
			<?php echo esc_html( $settings['link1_text'] ); ?>
		</a>
		<?php }
		if(!empty($settings['link2_text'])){ 
			?>
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'link2-attrs' ) ); ?>>
			<?php echo esc_html( $settings['link2_text'] ); ?>
		</a>
		<?php } ?>
	</div>
	<div class="cms-heading text-white pt-40 pb-10 d-flex align-items-end lh-1 empty-none">
		<span class="text-30"><?php etc_print_html($settings['price']); ?></span>
		<span class="text-14"><?php etc_print_html($settings['price_pack']); ?></span>
	</div>
	<?php // Ribbon ?>
	<div class="cms-ribbon absolute top left empty-none"><span class="main"><?php etc_print_html($settings['badge_text']); ?></span></div>
</div>