<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;
use Elementor\Icons_Manager;

$process = $widget->get_setting('process', []);
if(empty($process)) return;

$arrows = $widget->get_setting('arrows', '');
$dots = $widget->get_setting('dots', '');
//
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : '620',
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : '500'
];
?>
<div class="cms-carousel swiper">
    <div class="swiper-wrapper">
        <?php
        $count = 0;
        foreach ($process as $key => $_process) {
            $count ++;
            if($count < 10) $count = '0'.$count;

            $_process['image_size'] = $settings['image_size'];
            $_process['image_custom_dimension'] = $thumbnail_custom_dimension;

            $item_key = $widget->get_repeater_setting_key( 'item', 'cms_process_item', $key );
            $widget->add_render_attribute( $item_key,[
                'class' => 'swiper-slide'
            ]);
            ?>
            <div <?php etc_print_html($widget->get_render_attribute_string( $item_key )); ?>>
                <?php
                // Image
                    fortis_elementor_image_render($_process,[
                        'name'           => 'image',
                        'image_size_key' => 'image',
                        'img_class'      => 'clip-path-2 swiper-nav-vert img-cover',
                        'custom_size'    => $thumbnail_custom_dimension,
                        'before'         => '<div class="cms-process-banner relative"><span class="cms-count absolute z-top">'.$count.'</span>',
                        'after'          => '</div>'
                    ]);
                // Title
                ?>
                <div class="cms-process-content pt-30">
                    <div class="cms-heading text-heading text-19 empty-none"><?php etc_print_html($_process['title']); ?></div>
                    <div class="cms-desc text-16 pt-15 empty-none"><?php etc_print_html($_process['desc']); ?></div>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php if ($dots == 'yes') : ?>
        <div class="cms-carousel-dots cms-carousel-dots-out empty-none"></div>
    <?php endif ?>
</div>
<?php if ($arrows == 'yes') : ?>
    <div class="cms-carousel-button-in-vert in-vert-2 prev cms-carousel-button-prev cms-carousel-button-circle-2 secondary hover-primary">
        <?php
        $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
        if (empty($icon_settings['value'])) {
            $icon_settings = [
                'library' => 'cmsi',
                'value'   => 'cmsi-arrow-left rtl-flip',
            ];
        }
        Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
        ?>
    </div>
    <div class="cms-carousel-button-in-vert in-vert-2 next cms-carousel-button-next cms-carousel-button-circle-2 secondary hover-primary">
        <?php
        $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
        if (empty($icon_settings['value'])) {
            $icon_settings = [
                'library' => 'cmsi',
                'value'   => 'cmsi-arrow-right rtl-flip',
            ];
        }
        Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
        ?>
    </div>
<?php endif ?>