<?php
if ( isset( $settings['progressbar_list'] ) && ! empty( $settings['progressbar_list'] ) ):
	foreach ( $settings['progressbar_list'] as $key => $progressbar ):
		$title_key = $widget->get_repeater_setting_key( 'title', 'progressbar_list', $key );
		$wrapper_key = $widget->get_repeater_setting_key( 'wrapper', 'progressbar_list', $key );
		$progress_bar_key = $widget->get_repeater_setting_key( 'progress_bar', 'progressbar_list', $key );
		
		$widget->add_inline_editing_attributes( $title_key );
		$widget->add_render_attribute( $title_key, 'class', 'cms-progress-bar-title' );

		$widget->add_render_attribute( $wrapper_key, [
			'class'         => 'cms-progress-wrap',
			'role'          => 'progressbar',
			'aria-valuemin' => '0',
			'aria-valuemax' => '100',
			'aria-valuenow' => $progressbar['percent']['size'],
		] );

		if ( ! empty( $progressbar['progress_type'] ) ) {
			$widget->add_render_attribute( $wrapper_key, 'class', 'progress-' . $progressbar['progress_type'] );
		}

		$widget->add_render_attribute( $progress_bar_key, [
			'class'    => 'cms-progress-bar',
			'data-max' => $progressbar['percent']['size'],
		] );

		if ( ! empty( $progressbar['title'] ) ) { ?>
            <div class="cms-progress-bar-wrap">
            <h5 <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $progressbar['title'] ); ?></h5>
		<?php } ?>

        <div <?php etc_print_html( $widget->get_render_attribute_string( $wrapper_key ) ); ?>>
            <div <?php etc_print_html( $widget->get_render_attribute_string( $progress_bar_key ) ); ?>></div>
            <span class="cms-progress-bar-progress-percentage"><?php echo esc_html( $progressbar['percent']['size'] ); ?>%</span>
        </div>
        </div>
	<?php endforeach; ?>
<?php endif; ?>