<?php
	// Title
	$widget->add_inline_editing_attributes( 'title', 'Quick Contact' );
	$widget->add_render_attribute( 'title', 'class', 'cms-title mb-30' );
	// Adress
	$widget->add_inline_editing_attributes( 'address', 'none' );
	$widget->add_render_attribute( 'address', [
		'class' => [
			'cms-address',
			'text-14',
			'pb-15'
		]
	]);
	$address = $widget->get_setting('address', '2307 Beverley Rd Brooklyn, New York 11226 U.S.');
	// Email
	$widget->add_inline_editing_attributes( 'email', 'none' );
	$email = $widget->get_setting('email', 'Fortis@cmshero.com');
	$widget->add_render_attribute( 'email', [
		'class' => [
			'cms-email',
			'text-17 font-700',
			'text-primary text-hover-secondary',
			'd-block',
			'pb-5'
		],
		'href' => 'mailto:'.$email
	]);
	// Phone
	$widget->add_inline_editing_attributes( 'phone', 'none' );
	$phone = $widget->get_setting('phone', '02 01061245741');
	$phone_link = str_replace(' ', '', $phone);
	$widget->add_render_attribute( 'phone',[ 
		'class' => [
			'cms-phone',
			'text-15 font-700',
			'd-block'
		],
		'href' => 'tel:'.$phone_link
	]);
	
?>
<h5 <?php etc_print_html( $widget->get_render_attribute_string( 'title' ) ); ?>><?php 
	echo etc_print_html( $widget->get_setting('title', 'Quick Contact') ); 
?></h5>
<div <?php etc_print_html( $widget->get_render_attribute_string( 'address' ) ); ?>><?php 
	echo etc_print_html( $address ); 
?></div>
<a <?php etc_print_html( $widget->get_render_attribute_string( 'email' ) ); ?>><?php 
	echo etc_print_html( $email ); 
?>
<a <?php etc_print_html( $widget->get_render_attribute_string( 'phone' ) ); ?>><?php 
	echo etc_print_html( $phone ); 
?></a>