<?php
	// Wrap attribute
	$widget->add_render_attribute('wraps', [
		'class' => [
			'd-flex text-13 gutter gutter-no-grid',
			'justify-content-'.$widget->get_setting('align', 'start'),
			!empty($widget->get_setting('align_latop')) ? 'justify-content-latop-'.$widget->get_setting('align_laptop') : '',
			!empty($widget->get_setting('align_tablet_extra')) ? 'justify-content-tablet-extra-'.$widget->get_setting('align_tablet_extra') : '',
			!empty($widget->get_setting('align_tablet')) ? 'justify-content-tablet-'.$widget->get_setting('align_tablet') : '',
			!empty($widget->get_setting('align_mobile_extra')) ? 'justify-content-mobile-extra-'.$widget->get_setting('align_mobile_extra') : '',
			!empty($widget->get_setting('align_mobile')) ? 'justify-content-mobile-'.$widget->get_setting('align_mobile') : ''
		],
		'style' => '--cms-gutter:30px;--cms-gutter-tablet:20px;--cms-gutter-mobile:10px;'
	]);
	// Adress
	$address     = $widget->get_setting('address', '2307 Beverley Rd Brooklyn, New York 11226 U.S.');
	$map_zoom    = 14;
	$map_api_key = fortis_get_opt('gm_api_key');
	$map_params  = [
	    rawurlencode( $address ),
	    absint( $map_zoom )
	];
	$map_url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;iwloc=near';

	//$widget->add_inline_editing_attributes( 'address' );
	$widget->add_render_attribute( 'address', [
		'class' => [
			'cms-address'
		],
		'href'   => vsprintf( $map_url, $map_params ),
		'target' => '_blank'
	]);
	$widget->add_render_attribute( 'address_text', [
		'class' => [
			'cms-address-text',
			fortis_add_hidden_device_controls_render($settings, 'title_')
		]
	]);
	// Email
	$email_title = $widget->get_setting('email_title', 'Email');
	$email       = $widget->get_setting('email', 'Fortis@cmssuperheroes.com');
	//$widget->add_inline_editing_attributes( 'email' );
	$widget->add_render_attribute( 'email', [
		'class' => [
			'cms-email'
		],
		'href'   => 'mailto:'.$email,
		'target' => '_blank'
	]);
	$widget->add_render_attribute( 'email_text', [
		'class' => [
			'cms-email-text',
			fortis_add_hidden_device_controls_render($settings, 'title_')
		]
	]);
	// Phone
	$phone_title = $widget->get_setting('phone_title', 'Customer Service');
	$phone       = $widget->get_setting('phone', '02 01061245741');
	$phone_link  = str_replace(' ', '', $phone);
	//$widget->add_inline_editing_attributes('phone');
	$widget->add_render_attribute( 'phone',[ 
		'class' => [
			'cms-phone',
		],
		'href' => 'tel:'.$phone_link
	]);
	$widget->add_render_attribute( 'phone_text',[ 
		'class' => [
			'cms-phone-text',
			fortis_add_hidden_device_controls_render($settings, 'title_')
		]
	]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wraps')); ?>>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'phone' ) ); ?>><span class="cms-icon text-primary cmsi-phone-alt text-16"></span><span <?php etc_print_html( $widget->get_render_attribute_string( 'phone_text' ) ); ?>><?php 
		echo etc_print_html( $phone_title.': '.$phone ); 
	?></a>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'email' ) ); ?>><span class="cms-icon text-primary cmsi-email text-16"></span><span <?php etc_print_html( $widget->get_render_attribute_string( 'email_text' ) ); ?>><?php 
		echo etc_print_html( $email_title.': '.$email ); 
	?></span></a>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'address' ) ); ?>><span class="cms-icon text-primary cmsi-map-marker text-16"></span><span <?php etc_print_html( $widget->get_render_attribute_string( 'address_text' ) ); ?>><?php 
		echo etc_print_html( $address ); 
	?></span></a>
</div>