<?php
$settings['num_words'] = !empty($settings['num_words']) ? $settings['num_words'] : 25;
$settings['readmore_text'] = !empty($settings['readmore_text']) ? $settings['readmore_text'] : esc_html__('Explore More', 'fortis');

$html_id     = etc_get_element_id($settings);
$tax         = array();
$source      = $widget->get_setting('source', '');
$orderby     = $widget->get_setting('orderby', 'date');
$order       = $widget->get_setting('order', 'desc');
$limit       = $widget->get_setting('limit', 6);
$layout_type = 'grid';
extract(etc_get_posts_of_grid('cms-service', [
    'source'   => $source,
    'orderby'  => $orderby,
    'order'    => $order,
    'limit'    => $limit
]));

$filter                     = $widget->get_setting('filter', 'false');
$filter_default_title       = $widget->get_setting('filter_default_title', 'All');
$filter_alignment           = $widget->get_setting('filter_alignment', 'center');
$thumbnail_size             = $widget->get_setting('thumbnail_size','custom');
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['thumbnail_custom_dimension']['width']) ? $settings['thumbnail_custom_dimension']['width'] : 400,
    'height' => !empty($settings['thumbnail_custom_dimension']['height']) ? $settings['thumbnail_custom_dimension']['height'] : 267
];
$pagination_type            = $widget->get_setting('pagination_type', 'pagination');
$num_words                  = $settings['num_words'];
$readmore_text              = $settings['readmore_text'];
$posts_data = array(
    'posttype'                   => 'cms-service',
    'taxonomy'                   => 'service-category',
    'startPage'                  => $paged,
    'maxPages'                   => $max,
    'total'                      => $total,
    'perpage'                    => $limit,
    'nextLink'                   => $next_link,
    'pagination_type'            => $pagination_type,
    //
    'layout'                     => $widget->get_setting('layout','27'),
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => $limit,
    'thumbnail_size'             => $thumbnail_size,
    'thumbnail_custom_dimension' => $thumbnail_custom_dimension,
    'num_words'                  => $num_words,
    'readmore_text'              => $readmore_text
);
// Wrap attributes
$widget->add_render_attribute('wrap',[
    'id'              => $html_id,
    'class'           => ['cms-grid', 'cms-post-grid', 'cms-post-grid-'.$widget->get_setting('layout','27')],
    'data-layout'     => $layout_type,
    'data-start-page' => $paged,
    'data-max-pages'  => $max,
    'data-total'      => $total,
    'data-perpage'    => $limit,
    'data-next-link'  => $next_link
]);
$widget->add_render_attribute('content',[
    'class' => [
        'cms-grid-content',
        'd-flex',
        'flex-col-'.$widget->get_setting('col','3'),
        'flex-col-laptop'.$widget->get_setting('col_laptop','3'),
        'flex-col-tablet-extra-'.$widget->get_setting('col_tablet_extra','3'),
        'flex-col-tablet-'.$widget->get_setting('col_tablet','2'),
        'flex-col-mobile-extra-'.$widget->get_setting('col_mobile_extra','1'),
        'flex-col-mobile-'.$widget->get_setting('col_mobile','1'),
        'gutter gutter-grid'
    ],
    'style' => '--gutter:40px;--gutter-tablet:30px;--gutter-mobile:20px;'
]);
?>

<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <?php if ($filter == "true"): ?>
        <div class="grid-filter-wrap d-flex justify-content-<?php echo esc_attr($filter_alignment); ?>">
            <span class="filter-item active" data-filter="*"><?php echo esc_html($filter_default_title); ?></span>
            <?php foreach ($categories as $category): 
                $category_arr = explode('|', $category);
                $tax[] = $category_arr[1];
                $term = get_term_by('slug', $category_arr[0], $category_arr[1]); 
            ?>
                <span class="filter-item" data-filter="<?php echo esc_attr($category); ?>">
                    <?php echo esc_html($term->name); ?>
                </span>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div <?php etc_print_html($widget->get_render_attribute_string('content')); ?>><?php
        $posts_data['tax'] = $tax;
        fortis_get_post_grid($settings , $posts, $posts_data, [
            'item_class'  => 'cms-grid-item'
        ]);
    ?></div>
    <?php if ($pagination_type == 'pagination') { ?>
        <div class="cms-grid-pagination" data-loadmore="<?php echo esc_attr(json_encode($posts_data)); ?>"
             data-query="<?php echo esc_attr(json_encode($args)); ?>">
            <?php fortis_posts_pagination($query, true); ?>
        </div>
    <?php }
    if (!empty($next_link) && $pagination_type == 'loadmore') { ?>
        <div class="cms-load-more text-center" data-loadmore="<?php echo esc_attr(json_encode($posts_data)); ?>">
            <span class="btn btn-outline">
                <i class="i-hidden"></i>
                <?php echo esc_html__('Load More', 'fortis') ?>
            </span>
        </div>
    <?php } ?>
</div>