<?php
$default_settings = [
	'image'       => '',
	'img_link'    => '',
];
$settings         = array_merge( $default_settings, $settings );
extract( $settings );
$html_id = etc_get_element_id( $settings );

if ( ! empty( $img_link['url'] ) ) {
	$widget->add_render_attribute( 'image', 'href', $img_link['url'] );

	if ( $img_link['is_external'] ) {
		$widget->add_render_attribute( 'image', 'target', '_blank' );
	}

	if ( $img_link['nofollow'] ) {
		$widget->add_render_attribute( 'image', 'rel', 'nofollow' );
	}
}

$img       = etc_get_image_by_size( array(
	'attach_id'  => $image['id'],
	'thumb_size' => 'full',
	'class'      => '',
) );
$thumbnail = $img['thumbnail'];

?>
<div class="cms-single-image <?php if (! empty($settings['align'])) { echo etc_print_html('text-'.$settings['align']); } ?>">
	<?php if ( ! empty( $img_link['url'] ) ) { ?>
    	<a <?php etc_print_html( $widget->get_render_attribute_string( 'image' ) ); ?>><?php } ?>
			<?php echo wp_kses_post( $thumbnail ); ?>
			<?php if ( ! empty( $img_link['url'] ) ) { ?>
		</a>
	<?php } ?>
</div>