<?php

use Elementor\Icons_Manager;

$cms_slides = $widget->get_setting('cms_slides', []);
$arrows     = $widget->get_setting('arrows','');
$dots       = $widget->get_setting('dots','');
$style      = $widget->get_setting('style', 'style1');

// Wrapper
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-carousel', 'swiper',
        $style
    ]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')) ?>>
    <div class="swiper-wrapper">
        <?php foreach ($cms_slides as $key => $cms_slide) { ?>
            <div class="cms-slider-item swiper-slide relative ">
                <?php 
                    // image
                    \Elementor\Group_Control_Image_Size::print_attachment_image_html($cms_slide);
                ?>
                <div class="cms-slider-content cms-overlay d-flex align-items-center">
                    <div class="container">
                        <div class="cms-slider--content">
                            <div class="cms-slider-subtitle empty-none <?php echo fortis_add_hidden_device_controls_render($settings, 'subtitle_'); ?>" data-cms-animation="subtitle_animation" data-cms-animation-delay="subtitle_animation_delay"><?php echo esc_html($cms_slide['subtitle']); ?></div>
                            <div class="cms-slider-title cms-heading font-600 empty-none <?php echo fortis_add_hidden_device_controls_render($settings, 'title_'); ?>" data-cms-animation="title_animation" data-cms-animation-delay="title_animation_delay"><?php echo esc_html($cms_slide['title']); ?></div>
                            <div class="cms-slider-desc empty-none <?php echo fortis_add_hidden_device_controls_render($settings, 'desc_'); ?>" data-cms-animation="description_animation" data-cms-animation-delay="description_animation_delay"><?php echo esc_html($cms_slide['description']); ?></div>
                            <div class="cms-slider-buttons d-flex gap empty-none" style="--cms-gap:30px;--cms-gap-tablet:30px;--cms-gap-mobile:30px;"><?php
                                if ( ! empty( $cms_slide['button_primary'] ) ) :
                                    switch ($cms_slide['button_primary_type']) {
                                        case 'page':
                                            $button_primary_page = !empty($cms_slide['button_primary_page_link']) ? get_page_by_path($cms_slide['button_primary_page_link'], OBJECT) : [];
                                            $button_primary_url  = !empty($button_primary_page) ? get_permalink($button_primary_page->ID) : '#';
                                            break;
                                        default:
                                            $button_primary_url = $cms_slide['button_primary_link']['url'];
                                            break;
                                    }
                            ?>
                                <a href="<?php echo esc_attr($button_primary_url); ?>" class="cms-slider-btn btn btn-lg icon-last btn-white btn-hover-primary <?php echo fortis_add_hidden_device_controls_render($settings, 'btn1_'); ?>" data-cms-animation="button_primary_animation" data-cms-animation-delay="button_primary_animation_delay">
                                    <i class="cmsi-arrow-right rtl-flip text-10"></i>
                                    <?php echo esc_attr( $cms_slide['button_primary'] ); ?>
                                </a>
                            <?php endif; ?>
                            <?php
                                if ( ! empty( $cms_slide['button_secondary'] ) ) :
                                    switch ($cms_slide['button_secondary_type']) {
                                        case 'page':
                                            $button_secondary_page = !empty($cms_slide['button_secondary_page_link']) ? get_page_by_path($cms_slide['button_secondary_page_link'], OBJECT) : [];
                                            $button_secondary_url  = !empty($button_secondary_page) ? get_permalink($button_secondary_page->ID) : '#';
                                            break;
                                        default:
                                            $button_secondary_url = $cms_slide['button_secondary_link']['url'];
                                            break;
                                    }
                            ?>
                                <a href="<?php echo esc_url($button_secondary_url); ?>" class="cms-slider-btn btn btn-lg btn-outline white <?php echo fortis_add_hidden_device_controls_render($settings, 'btn2_'); ?>" data-cms-animation="button_secondary_animation" data-cms-animation-delay="button_secondary_animation_delay">
                                    <?php echo esc_attr( $cms_slide['button_secondary'] ); ?>
                                </a>
                            <?php endif; 
                                // Video button
                                fortis_elementor_button_video_render($widget, $cms_slide, [
                                    'name'     => 'video_link',
                                    'icon'     => 'cmsi-play cms-transition',
                                    'text'     => $cms_slide['video_text'],
                                    'layout'   => '3',
                                    'class'    => fortis_add_hidden_device_controls_render($settings, 'btn_video_'),
                                    'echo'     => true,
                                    'loop'     => true,
                                    'loop_key' => $key, 
                                    'attrs'    => [
                                        'data-cms-animation'       => 'button_video_animation',
                                        'data-cms-animation-delay' => 'button_video_animation_delay'
                                    ]
                                ]);
                            ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
    <?php if ($arrows == 'yes') : ?>
        <div class="cms-slider-button-arrow cms-carousel-button-prev">
            <i class="cmsi-arrow-prev rtl-flip"></i>
        </div>
        <div class="cms-slider-button-arrow cms-carousel-button-next">
            <i class="cmsi-arrow-next rtl-flip"></i>
        </div>
    <?php endif ?>
    <?php if ($dots == 'yes') : ?>
        <div class="cms-carousel-dots justify-content-center"></div>
    <?php endif ?>
</div>