<?php 
	fortis_elementor_image_render($settings, [
		'name'        => 'banner',
		'img_class'   => 'img-cover',
		'custom_size' => ['width' => 370, 'height' => 485],
		'before'      => '<div class="cms-overlay cms-gradient-'.$widget->get_setting('banner_gradient').'">',
		'after'       => '<div class="cms-gradient-render"></div></div>'
	]);
	// button
	$page_link = $widget->get_setting('page_link','');

	//Button
	switch ($settings['btn_type']) {
		case 'page':
			$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
			$url  = !empty($page) ? get_permalink($page->ID) : '#';
			break;
		
		default:
			$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
			break;
	}
	$widget->add_render_attribute( 'button', [
		'class' => [
			'btn',
			'btn-white',
			'btn-lg',
			'btn-hover-'.$widget->get_setting('btn_hover', 'secondary'),
			'justify-content-between w-100',
			'mt-20'
		],
		'href'	=> $url
	]);
	// Phone
	$widget->add_render_attribute( 'phone', [
		'href'   => 'tel:'.$settings['phone']['url'],
		'target' => '_blank',
		'class'  => [
			'text-white',
			'heading',
			'font-400',
			'text-20',
			'd-flex gap-20 align-items-center',
			'text-hover-white'
		]
	]);
?>
<div class="cms-content relative z-top p-50 p-lr-tablet-extra-40 p-lr-tablet-30 p-lr-smobile-20">
	<h4 class="cms-title text-22 font-500 lh-1-5 text-white empty-none pb-10"><?php etc_print_html($settings['title']); ?></h4>
	<div class="cms-desc text-16 text-white empty-none pb-100"><?php etc_print_html($settings['description']); ?></div>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'phone' ) ); ?>><i class="cmsi-phone-alt text-15 rtl-flip"></i><?php etc_print_html($settings['phone']['url']); ?></a>
	<a <?php etc_print_html( $widget->get_render_attribute_string( 'button' ) ); ?>>
		<?php
			// text
			echo esc_html( $settings['btn_text'] );
			// icon
			\Elementor\Icons_Manager::render_icon( ['library' => 'cmsi', 'value' => 'cmsi-arrow-right'], [ 'aria-hidden' => 'true', 'class' => 'text-10 rtl-flip' ] );
		?>
	</a>
</div>