<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;
use Elementor\Icons_Manager;

$layout_mode = $widget->get_setting('layout_mode', 'carousel');
$teams       = $widget->get_setting('teams', []);
$arrows      = $widget->get_setting('arrows', '');
$dots        = $widget->get_setting('dots', '');

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : 400,
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : 400
];
?>
<div class="cms-carousel swiper">
    <div class="swiper-wrapper">
        <?php
        foreach ($teams as $key => $team) {
            $link_key = $widget->get_repeater_setting_key( 'link', 'cms_team', $key );
            $widget->add_render_attribute( $link_key, 'class', 'team-name heading text-19 text-white text-hover-secondary font-500' );
            $widget->add_link_attributes( $link_key, $team['link'] );
            ?>
            <div class="cms-swiper-item swiper-slide cms-shadow-3">
                <?php 
                    $team['image_size'] = $widget->get_setting('image_size');
                    $team['image_custom_dimension'] = $thumbnail_custom_dimension;
                    fortis_elementor_image_render($team,[
                        'name'           => 'image',
                        'image_size_key' => 'image',
                        'img_class'      => 'swiper-nav-vert',
                        'custom_size'    => $thumbnail_custom_dimension,
                        'before'         => '<a '.$widget->get_render_attribute_string( $link_key ).'>',
                        'after'          => '</a>'
                    ]);
                ?>
                <div class="team-content p-lr-40 pb-40 p-lr-smobile-20">
                    <div class="team-heading bg-primary clip-path-1 text-white p-22 text-center">
                        <a <?php etc_print_html($widget->get_render_attribute_string( $link_key )); ?>>
                            <?php echo esc_html($team['name']); ?>
                        </a>
                        <div class="team-position empty-none text-15 pt-5"><?php etc_print_html($team['position']); ?></div>
                    </div>
                    <div class="team-desc empty-none pt-35 text-15 text-center"><?php etc_print_html($team['description']); ?></div>
                    <?php
                        ob_start();
                        for ($i = 1; $i <= 4; $i++) {
                            $social_icon = isset($team["social_icon_{$i}"]) ? $team["social_icon_{$i}"] : null;
                            $social_link = isset($team["social_link_{$i}"]) ? $team["social_link_{$i}"] : null;
                            if($social_icon && $social_link){
                                if ( ! empty( $social_link['url'] ) ) {
                                    $social_link_key = $widget->get_repeater_setting_key( "social_link_{$i}", 'cms_team', $key );
                                    $widget->add_link_attributes( $social_link_key, $social_link );
                                    $widget->add_render_attribute( $social_link_key, 'class', 'team-social' );
                                    ?>
                                        <a <?php etc_print_html($widget->get_render_attribute_string( $social_link_key )); ?>>
                                            <?php
                                                Icons_Manager::render_icon( $social_icon, [ 'aria-hidden' => 'true' ] );
                                            ?>
                                        </a>
                                    <?php
                                }
                            }
                        }
                        $socials_html = ob_get_clean();

                        if(!empty($socials_html)){
                            ?>
                            <div class="d-flex justify-content-center pt-25">
                                <div class="team-socials d-flex"><?php etc_print_html($socials_html); ?></div>
                            </div>
                            <?php
                        }
                    ?>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
</div>
<?php if ($arrows == 'yes') : ?>
    <div class="cms-carousel-button-prev cms-carousel-button-in-vert prev">
        <i aria-hidden="true" class="eicon-chevron-left rtl-flip"></i>
    </div>
    <div class="cms-carousel-button-next cms-carousel-button-in-vert next">
        <i aria-hidden="true" class="eicon-chevron-right rtl-flip"></i>
    </div>
<?php endif ?>
<?php if ($dots == 'yes') : ?>
    <div class="cms-carousel-dots"></div>
<?php endif ?>