<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;
use Elementor\Icons_Manager;

$layout_mode = $widget->get_setting('layout_mode', 'carousel');
$teams       = $widget->get_setting('teams', []);
$arrows      = $widget->get_setting('arrows', '');
$dots        = $widget->get_setting('dots', '');

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : 290,
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : 370
];
?>
<div class="cms-carousel swiper">
    <div class="swiper-wrapper">
        <?php
        foreach ($teams as $key => $team) {
            $team['image_size'] = $widget->get_setting('image_size');
            $team['image_custom_dimension'] = $thumbnail_custom_dimension;
            // Socials
            ob_start();
            for ($i = 1; $i <= 4; $i++) {
                $social_icon = isset($team["social_icon_{$i}"]) ? $team["social_icon_{$i}"] : null;
                $social_link = isset($team["social_link_{$i}"]) ? $team["social_link_{$i}"] : null;
                if($social_icon && $social_link){
                    if ( ! empty( $social_link['url'] ) ) {
                        $social_link_key = $widget->get_repeater_setting_key( "social_link_{$i}", 'cms_team', $key );
                        $widget->add_link_attributes( $social_link_key, $social_link );
                        $widget->add_render_attribute( $social_link_key, 'class', 'team-social' );
                        ?>
                            <a <?php etc_print_html($widget->get_render_attribute_string( $social_link_key )); ?>>
                                <?php
                                    Icons_Manager::render_icon( $social_icon, [ 'aria-hidden' => 'true' ] );
                                ?>
                            </a>
                        <?php
                    }
                }
            }
            $socials_html = ob_get_clean();
            ?>
            <div class="cms-swiper-item swiper-slide text-center">
                <?php 
                    //
                    $link_key = $widget->get_repeater_setting_key( 'link', 'cms_team', $key );
                    $widget->add_render_attribute( $link_key, 'class', 'team-name heading text-19 font-500' );
                    $widget->add_link_attributes( $link_key, $team['link'] );

                    fortis_elementor_image_render($team,[
                        'name'           => 'image',
                        'image_size_key' => 'image',
                        'img_class'      => 'swiper-nav-vert img-cover',
                        'custom_size'    => $thumbnail_custom_dimension,
                        'before'         => '<div class="team-img relative mb-20"><a '.$widget->get_render_attribute_string( $link_key ).'>',
                        'after'          => '</a><div class="team-socials d-flex justify-content-center">'.$socials_html.'</div></div>'
                    ]);
                    
                ?><a <?php etc_print_html($widget->get_render_attribute_string( $link_key )); ?>>
                    <?php echo esc_html($team['name']); ?>
                </a>
                <div class="team-position empty-none text-15 pt-5"><?php etc_print_html($team['position']); ?></div>
                <div class="team-desc empty-none pt-15 text-15"><?php etc_print_html($team['description']); ?></div>
            </div>
            <?php
        }
        ?>
    </div>
</div>
<?php if ($arrows == 'yes') : ?>
    <div class="cms-carousel-button-prev cms-carousel-button-in-vert prev">
        <i aria-hidden="true" class="eicon-chevron-left rtl-flip"></i>
    </div>
    <div class="cms-carousel-button-next cms-carousel-button-in-vert next">
        <i aria-hidden="true" class="eicon-chevron-right rtl-flip"></i>
    </div>
<?php endif ?>
<?php if ($dots == 'yes') : ?>
    <div class="cms-carousel-dots"></div>
<?php endif ?>