<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;

$testimonials = $widget->get_setting('testimonials', []);
$arrows = $widget->get_setting('arrows', '');
$dots = $widget->get_setting('dots', '');

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : '54',
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : '54'
];

// Background
$bg_gradient = $widget->get_setting('bg_gradient', 4);
fortis_elementor_image_render($settings, [
    'name'           => 'bg_image',
    'image_size_key' => 'bg_image',
    'custom_size'    => ['width' => '620', 'height'=>'790'],
    'img_class'      => 'img-cover',
    'before'         => '<div class="cms-gradient-'.$bg_gradient.' cms-overlay">',
    'after'          => '<div class="cms-gradient-render"></div></div>'
]);
?>
<div class="cms-ttmn-content relative z-top p-70 p-lr-tablet-20">
    <span class="ttmn-icon cmsi-quote absolute"></span>
    <div class="cms-smallheading text-17 font-700 text-white mt-n7 pb-10 empty-none"><?php etc_print_html($settings['small_title']); ?></div>
    <div class="cms-heading text-white text-60 text-tablet-40 mt-n5"><?php etc_print_html($settings['title']); ?></div>
    <div class="cms-carousel swiper">
        <div class="swiper-wrapper">
            <?php
            foreach ($testimonials as $key => $testimonial) {
                $testimonial['image_size'] = $settings['image_size'];
                $testimonial['image_custom_dimension'] = $thumbnail_custom_dimension;
                ?>
                <div class="cms-carousel-item swiper-slide text-white lh-1-5">
                    <div class="cms-ttmn-desc heading font-500 text-22 text-italic empty-none text-line-6"><?php 
                        etc_print_html($testimonial['description']); 
                    ?></div>
                    <?php if($dots!=='yes'){ ?>
                    <div class="d-flex gap align-items-center" style="--cms-gap:10px;--cms-gap-tablet:10px;--cms-gap-mobile:10px;">
                        <?php
                            fortis_elementor_image_render($testimonial,[
                                'name'           => 'image',
                                'image_size_key' => 'image',
                                'img_class'      => 'cms-ttmn--img circle ',
                                'custom_size'    => $thumbnail_custom_dimension,
                                'before'         => '<div class="cms-ttmn-img">',
                                'after'          => '</div>'
                            ]);
                        
                        ?>
                        <div class="cms-ttmn-name">
                            <div class="cms-ttmn--name text-14 font-700 empty-none"><?php echo esc_html($testimonial['name']); ?></div>
                            <div class="cms-ttmn--pos text-13 empty-none"><?php echo esc_html($testimonial['position']); ?></div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
    <div class="d-flex gap empty-none pt-25 align-items-center" style="--cms-gap:30px;--cms-gap-tablet:30px;--cms-gap-mobile:30px;"><?php 
        if ($arrows == 'yes') : ?>
            <div class="cms-carousel-buttons d-flex gap flex-auto" style="--cms-gap:10px;--cms-gap-tablet:10px;--cms-gap-mobile:10px">
                <div class="cms-carousel-button cms-carousel-button-prev cmsi-arrow-circle-left-large rtl-flip"></div>
                <div class="cms-carousel-button cms-carousel-button-next cmsi-arrow-circle-right-large rtl-flip"></div>
            </div>
        <?php endif ?>
        <?php if ($dots == 'yes') : ?>
            <div class="thumbs-slider swiper flex-basic">
                <div class="swiper-wrapper cms-carousel-dots-sync-<?php echo esc_attr($settings['element_id']); ?>">
                    <?php foreach ($testimonials as $key => $testimonial) { ?>
                        <div class="swiper-slide">
                            <div class="d-flex gap align-items-center text-white" style="--cms-gap:10px;--cms-gap-tablet:10px;--cms-gap-mobile:10px;">
                                <?php
                                    fortis_elementor_image_render($testimonial,[
                                        'name'           => 'image',
                                        'image_size_key' => 'image',
                                        'img_class'      => 'cms-ttmn--img circle ',
                                        'custom_size'    => $thumbnail_custom_dimension,
                                        'before'         => '<div class="cms-ttmn-img">',
                                        'after'          => '</div>'
                                    ]);
                                
                                ?>
                                <div class="cms-ttmn-name">
                                    <div class="cms-ttmn--name text-14 font-700 empty-none"><?php echo esc_html($testimonial['name']); ?></div>
                                    <div class="cms-ttmn--pos text-13 empty-none"><?php echo esc_html($testimonial['position']); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php endif ;?>
    </div>
</div>
