<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;

$testimonials = $widget->get_setting('testimonials', []);
$arrows = $widget->get_setting('arrows', '');
$dots = $widget->get_setting('dots', '');

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : '54',
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : '54'
];
?>
<div class="cms-smallheading text-16 text-primary font-700 mt-n7 pb-10 empty-none"><?php etc_print_html($settings['small_title']); ?></div>
<h2 class="cms-heading mt-n5 pb-35"><?php etc_print_html($settings['title']); ?></h2>
<div class="bg-white cms-shadow-4 cms-radius-trl-10 cms-triangle-br p-40 p-lr-smobile-20 relative">
    <div class="cms-carousel swiper relative z-top">
        <div class="swiper-wrapper">
            <?php
            foreach ($testimonials as $key => $testimonial) {
                $testimonial['image_size'] = $settings['image_size'];
                $testimonial['image_custom_dimension'] = $thumbnail_custom_dimension;
                ?>
                <div class="cms-carousel-item swiper-slide">
                    <div class="cms-ttmn-desc heading font-600 text-21 lh-1-7 empty-none mb-30"><?php 
                        etc_print_html($testimonial['description']); 
                    ?></div>
                    <div class="d-flex gap align-items-center" style="--cms-gap:20px;--cms-gap-tablet:20px;--cms-gap-mobile:20px;">
                        <?php
                            fortis_elementor_image_render($testimonial,[
                                'name'           => 'image',
                                'image_size_key' => 'image',
                                'img_class'      => 'cms-ttmn--img circle ttmn-avatar',
                                'custom_size'    => $thumbnail_custom_dimension,
                                'before'         => '<div class="cms-ttmn-img">',
                                'after'          => '</div>'
                            ]);
                        
                        ?>
                        <div class="cms-ttmn-name">
                            <div class="cms-ttmn--name cms-heading text-16 font-700 empty-none"><?php echo esc_html($testimonial['name']); ?></div>
                            <div class="cms-ttmn--pos text-14 empty-none"><?php echo esc_html($testimonial['position']); ?></div>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
    <i class="ttmn-icon cmsi-quote"></i>
</div>
<?php 
if ($arrows == 'yes') : ?>
    <div class="cms-carousel-button cms-carousel-button-in-vert prev"><span class="cmsi-arrow-left rtl-flip"></span></div>
    <div class="cms-carousel-button cms-carousel-button-in-vert next"><span class="cmsi-arrow-right rtl-flip"></span></div>
<?php endif ?>
<?php if ($dots == 'yes') : ?>
    <div class="cms-carousel-dots cms-carousel-dots-out justify-content-start"></div>
<?php endif ;?>

