<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;

$testimonials = $widget->get_setting('testimonials', []);
$arrows = $widget->get_setting('arrows', '');
$dots = $widget->get_setting('dots', '');

$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : '110',
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : '110'
];

?>
<div class="cms-carousel swiper">
    <div class="swiper-wrapper">
        <?php
        foreach ($testimonials as $key => $testimonial) {
            $testimonial['image_size'] = $settings['image_size'];
            $testimonial['image_custom_dimension'] = $thumbnail_custom_dimension;
            ?>
            <div class="cms-carousel-item swiper-slide d-flex">
                <?php
                    fortis_elementor_image_render($testimonial,[
                        'name'           => 'image',
                        'image_size_key' => 'image',
                        'img_class'      => 'cms-ttmn--img cms-radius-8',
                        'custom_size'    => $thumbnail_custom_dimension,
                        'before'         => '<div class="cms-ttmn-img flex-auto"><div class="relative">',
                        'after'          => '<i class="avatar-icon cmsi-quote flip"></i></div></div>'
                    ]);
                ?>
                <div class="flex-basic flex-mobile-full pl-110 pl-tablet-extra-20 pt-mobile-20 pl-mobile-0">
	            	<div class="cms-ttmn-name">
	                    <div class="cms-ttmn--name cms-heading text-heading text-18 mt-n7 empty-none"><?php echo esc_html($testimonial['name']); ?></div>
	                    <div class="cms-ttmn--pos text-14 empty-none"><?php echo esc_html($testimonial['position']); ?></div>
	                </div>
	                <div class="cms-ttmn-desc heading font-500 text-25 text-heading empty-none"><?php 
	                    etc_print_html($testimonial['description']);
	                ?></div>
	            </div>
            </div>
            <?php
        }
        ?>
    </div>
</div>
<i class="ttmn-icon cmsi-quote"></i>
<div class="d-flex gap empty-none align-items-center mt-n10" style="--cms-gap:30px;--cms-gap-tablet:30px;--cms-gap-mobile:30px;"><?php 
    if ($arrows == 'yes') : ?>
        <div class="cms-carousel-buttons d-flex gap flex-auto pt-35" style="--cms-gap:10px;--cms-gap-tablet:10px;--cms-gap-mobile:10px">
            <div class="cms-carousel-button cms-carousel-button-prev cms-carousel-button-circle"><i class="cmsi-arrow-left rtl-flip"></i></div>
            <div class="cms-carousel-button cms-carousel-button-next cms-carousel-button-circle"><i class="cmsi-arrow-right rtl-flip"></i></div>
        </div>
    <?php endif ?>
    <?php if ($dots == 'yes') : ?>
        <div class="cms-carousel-dots cms-carousel-dots-out justify-content-start"></div>
    <?php endif ?>
</div>