<?php
use Elementor\Plugin;
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Embed;
$page_link = $widget->get_setting('link_page','');
switch($widget->get_setting('link_type', 'custom' )){
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	default : 
		$url = $widget->get_setting('link_custom')['url'];
	break;
}
?>
<div class="cms-drop-shadow-3">
	<div class="cms--video-1 clip-path-1 d-flex align-items-start gap">
		<?php 
	    // Video Banner
	    fortis_elementor_image_render($settings, [
	    	'custom_size' => ['width' => '140','height' => '140'],
	    	'img_class'   => '',
	    	'before'	  => '<div class="flex-auto relative">',		
	    	'after' 	  => fortis_elementor_button_video_render($widget, $settings, [
				'name'   => 'video_link',
				'icon'   => $widget->get_setting('video_icon')['value'],
				'text'   => $widget->get_setting('video_text'),
				'layout' => $widget->get_setting('btn-layout','1'),
				'class'  => 'absolute center',
				'echo'	 => false
		    ]).'</div>'	
	    ]);
		?>
		<div class="video-content flex-basic">
			<h6 class="video-title text-17"><?php etc_print_html($widget->get_setting('title')); ?></h6>
			<div class="video-desc text-line-3 text-15"><?php etc_print_html($widget->get_setting('description')); ?></div>
			<a class="video-link d-flex align-items-center text-15 font-700 gap-10" href="<?php echo esc_url($url); ?>"><i class="cmsi-arrow-circle-right text-22 text-primary rtl-flip"></i><?php etc_print_html($widget->get_setting('link_text')); ?></a>
		</div>
	</div>
</div>