<?php
use Elementor\Plugin;
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Embed;

// Button
$btn_link = $widget->get_setting('btn_page','');
switch($widget->get_setting('btn_type', 'custom' )){
	case 'page':
		$btn_page = !empty($btn_link) ? get_page_by_path($btn_link, OBJECT) : [];
		$btn_url  = !empty($btn_page) ? get_permalink($btn_page->ID) : '#';
		break;
	default : 
		$btn_url = $widget->get_setting('btn_custom')['url'];
	break;
}
// Link
$page_link = $widget->get_setting('link_page','');
switch($widget->get_setting('link_type', 'custom' )){
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	default : 
		$url = $widget->get_setting('link_custom')['url'];
	break;
}
?>
<div class="cms--video-2 d-flex gutter">
	<?php 
    // Video Banner
    fortis_elementor_image_render($settings, [
    	'custom_size' => ['width' => '730','height' => '460'],
    	'img_class'   => 'clip-path-2 img-cover',
    	'before'	  => '<div class="col-7 col-tablet-extra-6 col-mobile-12">',		
    	'after' 	  => fortis_elementor_button_video_render($widget, $settings, [
			'name'   => 'video_link',
			'icon'   => $widget->get_setting('video_icon')['value'],
			'text'   => $widget->get_setting('video_text', 'Watch Video!'),
			'layout' => $widget->get_setting('btn-layout','2'),
			'class'  => 'absolute bottom-right',
			'echo'	 => false
	    ]).'</div>'	
    ]);
	?>
	<div class="video-content col-5 col-tablet-extra-6 col-mobile-12 order-first order-mobile-last">
		<div class="video-desc text-16 mt-n7"><?php echo nl2br($widget->get_setting('description')); ?></div>
		<div class="cms-video-btns d-flex gap pt-30 pb-88 pb-mobile-0" style="--cms-gap:30px;">
			<a class="video-btn btn btn-lg btn-secondary btn-hover-primary icon-last" href="<?php echo esc_url($btn_url); ?>"><i class="cms-btn-icon cmsi-arrow-right rtl-flip text-10"></i><?php etc_print_html($widget->get_setting('btn_text')); ?></a>
			<a class="video-link d-flex align-items-center text-15 font-700 gap-10" href="<?php echo esc_url($url); ?>"><?php etc_print_html($widget->get_setting('link_text')); ?><i class="cmsi-arrow-alt-circle-right rtl-flip text-32 text-primary"></i></a>
		</div>
	</div>
</div>
