<?php
use Elementor\Plugin;
use Elementor\Control_Media;
use Elementor\Group_Control_Image_Size;
use Elementor\Embed;

// Feature
$features = $widget->get_setting('cms_feature', []);
$features2 = $widget->get_setting('cms_feature2', []);
?>
<div class="cms--video-3 d-flex gutter">
	<?php 
    // Video Banner
    fortis_elementor_image_render($settings, [
    	'custom_size' => ['width' => '510','height' => '703'],
    	'img_class'   => 'img-cover',
    	'max_height'  => true,		
    	'before'	  => '<div class="video-banner relative">',		
    	'after' 	  => fortis_elementor_button_video_render($widget, $settings, [
			'name'   => 'video_link',
			'icon'   => $widget->get_setting('video_icon')['value'],
			'text'   => $widget->get_setting('video_text'),
			'layout' => $widget->get_setting('btn-layout','3'),
			'class'  => 'absolute top-left ml-45 mt-45',
			'echo'	 => false
	    ]).'</div>'
    ]);
	?>
	<div class="video-content">
		<div class="video-desc text-17 font-700"><?php echo nl2br($widget->get_setting('description')); ?></div>
		<div class="video-features d-flex gutter text-16 font-700 pt-30" style="--gutter:30px;--gutter-tablet:30px;--gutter-mobile:30px;">
			<div class="video-features-1 col-6 col-mobile-12"><?php 
				foreach ( $features as $key => $cms_feature ):
					$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
					$widget->add_render_attribute($title_key, 'class', 'flex-basic');
					$widget->add_inline_editing_attributes( $title_key, 'none' );
				?>
			        <div class="cms-list d-flex gap" style="--cms-gap:20px;--cms-gap-tablet:20px;--cms-gap-mobile:20px;">
			            <?php 
			            	\Elementor\Icons_Manager::render_icon( $cms_feature['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon flex-auto text-26' ] ); 
			            ?>
			            <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_feature['title'] ) ?></span>
			        </div>
				<?php endforeach;
			?></div>
			<div class="video-features-2 col-6 col-mobile-12"><?php 
				foreach ( $features2 as $key => $cms_feature ):
					$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
					$widget->add_render_attribute($title_key, 'class', 'flex-basic');
					$widget->add_inline_editing_attributes( $title_key, 'none' );
				?>
			        <div class="cms-list d-flex gap" style="--cms-gap:20px;--cms-gap-tablet:20px;--cms-gap-mobile:20px;">
			            <?php 
			            	\Elementor\Icons_Manager::render_icon( $cms_feature['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon flex-auto text-26' ] ); 
			            ?>
			            <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_feature['title'] ) ?></span>
			        </div>
				<?php endforeach;
			?></div>
		</div>
	</div>
</div>
