<?php
/**
 * Functions and definitions
 *
 * @package Fortis
 * 
 */
if ( ! function_exists( 'fortis_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function fortis_setup() {
		// Make theme available for translation.
		load_theme_textdomain( 'fortis', get_template_directory() . '/languages' );
		// Theme Support
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support(
			'html5',
			[
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
				'navigation-widgets'
			]
		);
		add_theme_support(
			'custom-logo',
			[
				'height'      => 100,
				'width'       => 350,
				'flex-height' => true,
				'flex-width'  => true,
			] 
		);

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'fortis' )
		) );

		/*
		 * WooCommerce.
		 */
		if ( apply_filters( 'fortis_add_woocommerce_support', true ) ) {
			// WooCommerce in general.
			add_theme_support( 'fortis' );
			// Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
			// zoom.
			//add_theme_support( 'wc-product-gallery-zoom' );
			// lightbox.
			//add_theme_support( 'wc-product-gallery-lightbox' );
			// swipe.
			add_theme_support( 'wc-product-gallery-slider' );
		}
	}
endif;
add_action( 'after_setup_theme', 'fortis_setup' );

add_action( 'cms_locations', function ( $cms_locations ) {
	return $cms_locations;
} );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 */
function fortis_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'fortis_content_width', 840 );
}
add_action( 'after_setup_theme', 'fortis_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
function fortis_scripts() {
	$theme = wp_get_theme( get_template() );
	// Theme style
	wp_enqueue_style( 'fortis', get_template_directory_uri() . '/assets/css/theme.css', array(), $theme->get( 'Version' ) );
	wp_add_inline_style('fortis', fortis_inline_styles() );
	// theme font icon
	wp_enqueue_style( 'font-cmsi', get_template_directory_uri() . '/assets/fonts/font-cmsi/style.css', array(), $theme->get( 'Version' ) );
	// theme font icon
	wp_enqueue_style( 'font-fortis', get_template_directory_uri() . '/assets/fonts/font-theme/style.css', array('fortis'), $theme->get( 'Version' ) );
	// WP Comment
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	/* Theme JS */
	wp_enqueue_script( 'fortis-main', get_template_directory_uri() . '/assets/js/main.js', array( 'jquery' ), $theme->get( 'Version' ), true );
	wp_localize_script( 'fortis-main', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

	/*
	 * Elementor Widget JS
	 */
	// Counter Widget
	wp_register_script( 'cms-counter-widget-js', get_template_directory_uri() . '/elementor/js/cms-counter-widget.js', [ 'jquery' ], $theme->get( 'Version' ) );
	// Counter Sticky Widget
	wp_register_script( 'cms-counter-sticky-widget-js', get_template_directory_uri() . '/elementor/js/cms-counter-sticky-widget.js', [ 'jquery' ], $theme->get( 'Version' ) );
	// Progress Bar Widget
	wp_register_script( 'cms-progressbar-widget-js', get_template_directory_uri() . '/elementor/js/cms-progressbar-widget.js', [ 'jquery' ], $theme->get( 'Version' ) );
	// Clients List Widget
	wp_register_script( 'cms-clients-list-widget-js', get_template_directory_uri() . '/elementor/js/cms-clients-list-widget.js', [ 'jquery' ], $theme->get( 'Version' ) );
	// Pie Charts Widget
	wp_register_script( 'cms-piecharts-widget-js', get_template_directory_uri() . '/elementor/js/cms-piecharts-widget.js', [ 'jquery' ], $theme->get( 'Version' ) );
	// CMS Post Carousel Widget
	wp_register_script( 'cms-post-carousel-widget-js', get_template_directory_uri() . '/elementor/js/cms-post-carousel-widget.js', [ 'jquery' ], $theme->get( 'Version' ) );
	// Galleries
    wp_register_script('cms-galleries', get_template_directory_uri() . '/elementor/js/cms-galleries.js', [ 'jquery' ], $theme->get( 'Version' ), true);
	// Google Maps Widget
	$api    = fortis_get_opt( 'gm_api_key', 'AIzaSyC08_qdlXXCWiFNVj02d-L2BDK5qr6ZnfM' );
	$api_js = "https://maps.googleapis.com/maps/api/js?sensor=false&key=" . $api;
	wp_register_script( 'maps-googleapis', $api_js, [], date( "Ymd" ) );
	wp_register_script( 'custom-gm-widget-js', get_template_directory_uri() . '/elementor/js/custom-gm-widget.js', [
		'maps-googleapis',
		'jquery'
	], $theme->get( 'Version' ), true );
	wp_register_script( 'cms-post-grid-widget-js', get_template_directory_uri() . '/elementor/js/cms-post-grid-widget.js', [
		'isotope',
		'jquery'
	], $theme->get( 'Version' ), true );
	wp_register_script( 'cms-toggle-widget-js', get_template_directory_uri() . '/elementor/js/cms-toggle-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
	wp_register_script( 'cms-accordion-widget-js', get_template_directory_uri() . '/elementor/js/cms-accordion-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
	wp_register_script( 'cms-alert-widget-js', get_template_directory_uri() . '/elementor/js/cms-alert-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
	wp_register_script( 'cms-tabs-widget-js', get_template_directory_uri() . '/elementor/js/cms-tabs-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true );
	// Chartjs
    wp_register_script( 'chartjs', get_template_directory_uri() . '/elementor/js/chart.min.js', array( 'jquery' ), $theme->get( 'Version' ), true );
    wp_register_script( 'cms-chartjs', get_template_directory_uri() . '/elementor/js/cms-chart.js', array( 'chartjs' ), $theme->get( 'Version' ), true );
}

add_action( 'wp_enqueue_scripts', 'fortis_scripts' );

if(!function_exists('fortis_default_fonts')){
	function fortis_default_fonts(){
		$body_font    = fortis_configs('body')['family'];
		$heading_font = fortis_configs('heading')['family'];
	?>
		<link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=<?php echo esc_attr($heading_font);?>:wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=<?php echo esc_attr($body_font); ?>:wght@400;700&display=swap" rel="stylesheet">
	<?php
	}
}
add_action('wp_footer','fortis_default_fonts');
/**
 * Widgets
 * Just show widgets if it enable via theme option
 * **/
function fortis_widgets(){
    // Register Theme Sidebars
    if(!class_exists('Theme_Core_Options') || fortis_get_opt('sidebar_on', 'on') === 'off') return;
    if(class_exists('Theme_Core_Options')){
    	$all = apply_filters('fortis_register_sidebar_all_post_type', false);
    	if($all){
	        $all_post_type = fortis_all_post_types();
	        unset($all_post_type['product']);
	        foreach ($all_post_type as $key => $value) {
	            register_sidebar([
	                'name'          => sprintf( esc_html__( '%s Sidebar', 'fortis' ), $value ),
	                'id'            => 'sidebar-'.$key,
	                'description'   => sprintf(esc_html__( 'Add widgets here to show in %1$s archive page and single %2$s page', 'fortis' ), strtoupper(str_replace('-', ' ', $key)), $value),
	                'class'         => 'cms-post-type-widget',
	                'title_class'   => ''
	            ]);
	        }
	    } else {
	    	register_sidebar([
                'name'          => esc_html__( 'Blog Sidebar', 'fortis' ),
                'id'            => 'sidebar-post',
                'description'   => esc_html__( 'Add widgets here to show in Blog archive page and single post page', 'fortis' ),
                'class'         => 'cms-post-type-widget',
                'before_widget' => '<div id="%1$s" class="cms-widget %2$s">',
        		'after_widget'  => '</div>',
            ]);
	    }

        // WooCommerce Sidebar
        if(class_exists('WooCommerce')){
            register_sidebar([
                'name'          => esc_html__( 'Shop Sidebar', 'fortis' ),
                'id'            => 'sidebar-product',
                'description'   => esc_html__( 'Add widgets here to show in WooCommerce archive and single product page', 'fortis'),
                'class'         => 'cms-post-type-widget',
                'before_widget' => '<div id="%1$s" class="cms-shop-widget %2$s">',
        		'after_widget'  => '</div>',
            ]);
        }
    }
}
add_action( 'widgets_init', 'fortis_widgets', 11 );
/**
 * Change default widget title structure
*/
if(!function_exists('fortis_widgets_structure')){
    add_filter('widget_display_callback', 'fortis_widgets_structure');
    add_filter('register_sidebar_defaults', 'fortis_widgets_structure');
    function fortis_widgets_structure($args){
        $args = wp_parse_args($args, [
            'class'       => '',  
            'title_class' => ''
        ]);
        $widget_title_tag = 'h4';
        $title_class = [
            'cms-wgtitle',
            isset($args['title_class']) ? $args['title_class'] : ''
        ];
        $args['before_title'] = '<h3 class="'.implode(' ', array_filter($title_class)).'">';
        $args['after_title'] = '</h3>';
        return $args;
    }
}
/**
 * Remove Some CSS
 * 
*/
if(!function_exists('etc_remove_scripts')){
    add_action( 'wp_enqueue_scripts', 'etc_remove_scripts', 999 );
    add_action( 'wp_footer', 'etc_remove_styles', 999 );
    add_action( 'wp_header', 'etc_remove_styles', 999 );
    function etc_remove_scripts() {
        $default = ['isotope' ];
        $scripts  = apply_filters( 'etc_remove_scripts', $default );
        foreach ( $scripts as $script ) {
            wp_dequeue_script( $script );
            //wp_fortis_deregister_script( $script );
        }
    }
}
if(!function_exists('etc_remove_styles')){
    add_action( 'wp_enqueue_scripts', 'etc_remove_styles', 999 );
    add_action( 'wp_footer', 'etc_remove_styles', 999 );
    add_action( 'wp_header', 'etc_remove_styles', 999 );
    function etc_remove_styles() {
        $default = ['gglcptch', 'isotope' ];
        $styles  = apply_filters( 'etc_remove_styles', $default );
        foreach ( $styles as $style ) {
            wp_dequeue_style( $style );
            //wp_fortis_deregister_style( $style );
        }
    }
}
if(!function_exists('fortis_remove_styles')){
    add_filter('etc_remove_styles', 'fortis_remove_styles');
    function fortis_remove_styles($styles){
        $_styles = [
            // newsletter
            'newsletter',
            // elementor
            'elementor-frontend-legacy',
            // woo
            'woocommerce-smallscreen',
            'woocommerce-general',
            'woocommerce-layout',
            'wc-blocks-vendors-style',
            'wc-blocks-style',
            // theme core
            'oc-css',
            'etc-main-css',
            'progressbar-lib-css',
            'slick-css',
            'tco-main-css',
            // language switcher
            'trp-floater-language-switcher-style',
            'trp-language-switcher-style',
        ];
        $styles = array_merge($styles, $_styles);
        return $styles;
    }
}

/**
 *  Add admin styles 
 * 
 * */
function fortis_admin_style() {
	$theme = wp_get_theme( get_template() );
	// theme font icon
    wp_enqueue_style( 'fortis-font-cmsi', get_template_directory_uri() . '/assets/fonts/font-cmsi/style.css', array(), $theme->get( 'Version' ) );
    wp_enqueue_style( 'fortis-font-theme', get_template_directory_uri() . '/assets/fonts/font-theme/style.css', array(), $theme->get( 'Version' ) );
	//admin
	wp_enqueue_style( 'fortis-admin-style', get_template_directory_uri() . '/assets/admin/admin.css' );
	// import demo
	wp_enqueue_style( 'fortis-get-started-css', get_template_directory_uri() . '/assets/admin/get-started.css' );
	wp_enqueue_script( 'fortis-get-started-js', get_template_directory_uri() . '/assets/admin/get-started.js', [ 'jquery' ], $theme->get( 'Version' ), true );
	wp_localize_script( 'fortis-get-started-js', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
}
add_action( 'admin_enqueue_scripts', 'fortis_admin_style' );

/**
 * Check if is build with Elementor
 * 
 * **/
if(!function_exists('fortis_is_built_with_elementor')){
    function fortis_is_built_with_elementor(){
    	if(cms_is_blog()) return false;
        if ( class_exists('\Elementor\Plugin') && \Elementor\Plugin::$instance->documents->get( get_the_ID() )->is_built_with_elementor() ) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * Custom Elementor Editor
 * */
add_action( 'elementor/editor/before_enqueue_scripts', function() {
    wp_enqueue_style( 'fortis-elementor-custom-editor', get_template_directory_uri() . '/assets/admin/elementor-panel.css', array(), '1.0.0' );
});
add_action('elementor/preview/enqueue_styles',  function() {
    wp_enqueue_style( 'fortis-elementor-custom-editor', get_template_directory_uri() . '/assets/admin/elementor-preview.css', array(), '1.0.0' );
});
/**
 * Font Icons
 * 
 * */
require_once get_template_directory() . '/assets/fonts/font-cmsi.php';
require_once get_template_directory() . '/assets/fonts/font-theme.php';
/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require_once get_template_directory() . '/inc/template-functions.php';
/**
 * Custom template tags for this theme.
 * 
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 * Theme Functions
 */
require_once get_template_directory() . '/inc/template-widgets.php';
require_once get_template_directory() . '/inc/theme-functions.php';

/**
 * Breadcrumb.
 */
require_once get_template_directory() . '/inc/classes/class-breadcrumb.php';

/**
 * Add Template Woocommerce
 */
if ( class_exists( 'WooCommerce' ) ) {
	require_once( get_template_directory() . '/woocommerce/wc-function-hooks.php' );
}
/**
 * Contact Form 7
 * */
if(class_exists('WPCF7')){
	require_once( get_template_directory() . '/inc/extensions/cf7.php' );
}
/**
 * Translate Presss
 * */
if(class_exists('TRP_Translate_Press')){
	require_once( get_template_directory() . '/inc/extensions/translatepress.php' );
}
/**
 * Theme Options
 */
require get_template_directory() . '/inc/theme-options/theme-options.php';

/**
 * Post Type Options
 */
// Page Options
require get_template_directory() . '/inc/post-type-options/page-options.php';
// CMS Service Options
require get_template_directory() . '/inc/post-type-options/service-options.php';
// CMS Industry Options
require get_template_directory() . '/inc/post-type-options/industry-options.php';
// CMS Case Options
require get_template_directory() . '/inc/post-type-options/case-options.php';
// CMS Career Options
require get_template_directory() . '/inc/post-type-options/career-options.php';

/**
 * CSS Generator.
 */
if ( ! class_exists( 'CSS_Generator' ) ) {
	require_once get_template_directory() . '/inc/classes/class-css-generator.php';
}
/**
 * Contact Form 7
 * 
 * */
add_filter('wpcf7_autop_or_not', '__return_false');
/*
 * Get Started
 */
require_once get_template_directory() . '/inc/get-started.php';
