<?php
class CSS_Generator {
	/**
	 * scssc class instance
	 *
	 * @access protected
	 * @var scssc
	 */
	protected $scssc = null;

	/**
	 * Debug mode is turn on or not
	 *
	 * @access protected
	 * @var boolean
	 */
	protected $dev_mode = true;

	/**
	 * opt_name
	 *
	 * @access protected
	 * @var string
	 */
	protected $opt_name = '';

	/**
	 * Constructor
	 */
	function __construct() {
		$this->opt_name = fortis_get_opt_name();

		if ( empty( $this->opt_name ) ) {
			return;
		}
		$this->dev_mode = fortis_get_opt( 'dev_mode', '0' ) === '1' ? true : false;
		add_filter( 'cms_scssc_on', function(){ return $this->dev_mode;} );
		add_filter( 'cms_scssc_lib', function(){ return 'new'; });
		add_action( 'init', array( $this, 'init' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue' ), 20 );
	}

	/**
	 * init hook - 10
	 */
	function init() {
		
		if ( !class_exists( '\Leafo\ScssPhp\Compiler' ) )
        {
            return;
        }
		add_action( 'wp', array( $this, 'generate_with_dev_mode' ) );
	}

	function generate_with_dev_mode() {
		if ( $this->dev_mode === true ) {
			$this->generate_file();
		}
	}

	/**
	 * Generate options and css files
	 */
	function generate_file() {
		require_once(ABSPATH . 'wp-admin/includes/file.php');
        global $wp_filesystem;
        if ( ! is_a( $wp_filesystem, 'WP_Filesystem_Base') ){
            $creds = request_filesystem_credentials( site_url() );
            wp_filesystem($creds);
        }

		$scss_dir = get_template_directory() . '/assets/scss/';
		$css_dir  = get_template_directory() . '/assets/css/';

		$this->scssc = new \Leafo\ScssPhp\Compiler();
		$this->scssc->setImportPaths( $scss_dir );

		$_options = $scss_dir . 'theme_variables.scss';
		$wp_filesystem->put_contents(
            $_options,
            preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->options_output() ),
           FS_CHMOD_FILE
        );

		$css_file = $css_dir . 'theme.css';
		// scss_formatter  or scss_formatter_compressed
		$this->scssc->setFormatter( 'Leafo\ScssPhp\Formatter\Crunched' );
		$wp_filesystem->put_contents(
            $css_file,
            preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->scssc->compile( '@import "theme.scss"' ) ),
            FS_CHMOD_FILE
        );
	}

	/**
	 * Hooked wp_enqueue_scripts - 20
	 * Make sure that the handle is enqueued from earlier wp_enqueue_scripts hook.
	 */
	function enqueue() {
		//$css = $this->inline_css();
		//if ( ! empty( $css ) ) {
		//	wp_add_inline_style( 'fortis-theme', $this->dev_mode ? $css : fortis_css_minifier( $css ) );
		//}
	}

	protected function options_output() {
		ob_start();
        // single css options
        printf('%s', $this->print_single_scss_opt());

		return ob_get_clean();
	}
	protected function print_single_scss_opt() {
        ob_start();
        $theme_colors = fortis_configs('theme_colors');
        // color
        foreach ($theme_colors as $key => $value) {
            printf('$%1$s_color: %2$s;', str_replace(['#',' '], [''],$key), $value['value'] );
        }
        return ob_get_clean();
    }
	/**
	 * Minify css
	 *
	 * @param string $css
	 *
	 * @return string
	 */
	function fortis_css_minifier($css){
		// Normalize whitespace
		$css = preg_replace('/\s+/', ' ', $css);
		// Remove spaces before and after comment
		$css = preg_replace('/(\s+)(\/\*(.*?)\*\/)(\s+)/', '$2', $css);
		// Remove comment blocks, everything between /* and */, unless
		// preserved with /*! ... */ or /** ... */
		$css = preg_replace('~/\*(?![\!|\*])(.*?)\*/~', '', $css);
		// Remove ; before }
		$css = preg_replace('/;(?=\s*})/', '', $css);
		// Remove space after , : ; { } */ >
		$css = preg_replace('/(,|:|;|\{|}|\*\/|>) /', '$1', $css);
		// Remove space before , ; { } ( ) >
		$css = preg_replace('/ (,|;|\{|}|\(|\)|>)/', '$1', $css);
		// Strips leading 0 on decimal values (converts 0.5px into .5px)
		$css = preg_replace(
			'/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i',
			'${1}.${2}${3}',
			$css
		);
		// Strips units if value is 0 (converts 0px to 0)
		$css = preg_replace(
			'/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i',
			'${1}0',
			$css
		);
		// Converts all zeros value into short-hand
		$css = preg_replace('/0 0 0 0/', '0', $css);
		// Shortern 6-character hex color codes to 3-character where possible
		$css = preg_replace(
			'/#([a-f0-9])\\1([a-f0-9])\\2([a-f0-9])\\3/i',
			'#\1\2\3',
			$css
		);

		return trim($css);
	}
}

new CSS_Generator();