<?php
// Silence is golden.
$args = [
    'title' => esc_html__('Header', 'fortis'),
    'fields' => [
        'header_custom' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Custom Header','fortis'),
            'default'       => false,
            'default_value' => 'off'
        ]),
        'header_layout' => fortis_theme_header_layout_opts([
            'default'       => $default,
            'default_value' => $default_value,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'header_height' => [
            'type'     => 'dimensions',
            'title'    => esc_html__('Header Height', 'fortis'),
            'subtitle' => esc_html__('Set height for your Header', 'fortis'),
            'width'    => false,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'header_width' => fortis_theme_content_width_opts([
            'title'         => esc_html__('Header Width', 'fortis'),
            'default'       => $default,
            'default_value' => $default_width,
            'required'      => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'header_sticky' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Header Sticky', 'fortis'),
            'subtitle'      => esc_html__('Header will be sticked when applicable.', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'header_transparent' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Header Transparent', 'fortis'),
            'subtitle'      => esc_html__('Header transparent use with background.', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ]),

        'custom_logo' => [
            'type'  => Theme_Core_Options::HEADING_FIELD,
            'title' => esc_html__('Logo Settings', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'logo' => [
            'type'  => Theme_Core_Options::MEDIA_FIELD,
            'title' => esc_html__('Logo', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'logo_maxh' => [
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Dimensions', 'fortis'),
            'subtitle' => esc_html__('Enter number.', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'logo_mobile' => [
            'type'  => Theme_Core_Options::MEDIA_FIELD,
            'title' => esc_html__('Logo Tablet & Mobile', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'logo_maxh_sm' => [
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Tablet & Mobile Dimensions', 'fortis'),
            'subtitle' => esc_html__('Enter number.', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],

        'logo_light' => [
            'type' => Theme_Core_Options::MEDIA_FIELD,
            'title' => esc_html__('Logo - Header Transparent', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'logo_light_mobile' => [
            'type'  => Theme_Core_Options::MEDIA_FIELD,
            'title' => esc_html__('Logo Tablet & Mobile - Header Transparent', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],

        'custom_attribute' => [
            'type'  => Theme_Core_Options::HEADING_FIELD,
            'title' => esc_html__('Attributes Settings', 'fortis'),
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ],
        'search_icon' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Search Icon', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'cart_icon' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Cart Icon', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'h_phone_on' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Show/Hide Phone', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'h_btn_on' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Show/Hide Button', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ]),
        'h_btn2_on' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Show/Hide Button #2', 'fortis'),
            'default'       => $default,
            'default_value' => $default_value,
            'required' => [
                'header_custom',
                '=',
                'on'
            ]
        ])
    ]
];
return $args;