<?php
// Silence is Golden
add_filter('tco_page_page_options_args', 'fortis_page_options_args');
function fortis_page_options_args(){
    $default       = true;
    $default_value = $default_on = $default_off = $default_width = '-1';
    $custom_opts   = true;

    $header_top = include get_template_directory() . '/inc/theme-options/args/header-top.php';
    $header     = include get_template_directory() . '/inc/post-type-options/args-page/header.php';
    $page_title = include get_template_directory() . '/inc/theme-options/args/page-title.php';
    $footer     = include get_template_directory() . '/inc/theme-options/args/footer.php';

    $general = [
        'title' => esc_html__('General','fortis'),
        'sections' => [
            'colors' => [
                'title' => esc_html__('Colors', 'fortis'),
                'fields' => [
                    'color_custom' => fortis_theme_on_off_opts([
                        'title'         => esc_html__('Custom Color','fortis'),
                        'default'       => false,
                        'default_value' => 'off'
                    ]),
                    'primary_color' => [
                        'type'     => Theme_Core_Options::COLOR_FIELD,
                        'title'    => esc_html__('Primary Color', 'fortis'),
                        'required' => ['color_custom', '=', 'on']
                    ],
                    'secondary_color' => [
                        'type'     => Theme_Core_Options::COLOR_FIELD,
                        'title'    => esc_html__('Secondary Color', 'fortis'),
                        'required' => ['color_custom', '=', 'on']
                    ],
                    'link_color' => [
                        'type'     => Theme_Core_Options::LINK_COLOR_FIELD,
                        'title'    => esc_html__('Link Color', 'fortis'),
                        'required' => ['color_custom', '=', 'on']
                    ]
                ]
            ],
            'typos'    => fortis_typography_opts(),
            'advanced' => fortis_general_advanced_opts()
        ]
    ];

    $content = [
        'title'  => esc_html__('Content', 'fortis'),
        'fields' => [
            'content_width' => fortis_theme_content_width_opts([
                'default'       => $default,
                'default_value' => $default_value
            ])
        ]
    ];

    $args = [  
        'general'    => $general,
        'header-top' => $header_top,
        'header'     => $header,
        'page-title' => $page_title,
        'content'    => $content,
        'footer'     => $footer,
    ];

    return $args;
}