<?php
/**
 * Helper functions for the theme
 *
 * @package Fortis
 */

/**
 * Check is Blog page
 * 
 * */
if(!function_exists('cms_is_blog')){
    function cms_is_blog(){
        if(is_home() || is_archive() || is_category() || is_tag() || is_author() || is_date() || is_post_type_archive() || is_tax() || is_search() ){
            return true;
        } else {
            return false;
        }
    }
}
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 *
 * @return array
 */
function fortis_body_classes($classes){
    $classes[] = fortis_is_built_with_elementor() ? 'cms-is-elementor' : 'cms-not-elementor';
    $classes[] = (fortis_get_opt('sidebar_on', 'off') === 'on') ? 'cms-has-sidebar' : 'cms-not-sidebar';
    $classes[] = cms_is_blog() ? 'cms-blog' : '';
    $classes[] = fortis_get_opts('btn_style','', 'on');
    return $classes;
}
add_filter('body_class', 'fortis_body_classes');


function fortis_archive_title_remove_label($title){
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_tag()) {
        $title = single_tag_title('', false);
    } elseif (is_author()) {
        $title = get_the_author();
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title('', false);
    } elseif (is_tax()) {
        $title = single_term_title('', false);
    } elseif (is_home()) {
        $title = single_post_title('', false);
    }
    return $title;
}
add_filter('get_the_archive_title', 'fortis_archive_title_remove_label');
/**
 * Custom Post Type
 * 
 * **/
add_filter('cms_extra_post_types', 'fortis_add_posttype');
if(!function_exists('fortis_add_posttype')){
    function fortis_add_posttype($postypes){
        $portfolio      = fortis_get_opt('portfolio_slug', 'portfolio');
        $portfolio_name = fortis_get_opt(
            'portfolio_name',
            esc_attr__('Portfolio', 'fortis')
        );
        $postypes['portfolio'] = [
            'status'     => apply_filters('fortis_enable_portfolio', false),
            'item_name'  => $portfolio_name,
            'items_name' => $portfolio_name,
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor','excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => $portfolio,
                ],
            ],
            'labels' => [],
        ];
        // Service
        $postypes['cms-service'] = [
            'status'     => apply_filters('fortis_enable_service', true),
            'item_name'  => esc_html__('Service', 'fortis'),
            'items_name' => esc_html__('Services', 'fortis'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('fortis_cms_service_slug', 'service'),
                ],
            ],
            'labels' => [],
        ];
        // Industry
        $postypes['cms-industry'] = [
            'status'     => apply_filters('fortis_enable_industry', true),
            'item_name'  => esc_html__('Industry', 'fortis'),
            'items_name' => esc_html__('Industrys', 'fortis'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('fortis_cms_industry_slug', 'industry'),
                ],
            ],
            'labels' => [],
        ];
        // Case
        $postypes['cms-case'] = [
            'status'     => apply_filters('fortis_enable_case', true),
            'item_name'  => esc_html__('Case', 'fortis'),
            'items_name' => esc_html__('Cases', 'fortis'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('fortis_cms_case_slug', 'cases'),
                ],
            ],
            'labels' => [],
        ];
        // career
        $postypes['cms-career'] = [
            'status'     => apply_filters('fortis_enable_career', true),
            'item_name'  => esc_html__('Career', 'fortis'),
            'items_name' => esc_html__('Careers', 'fortis'),
            'args' => [
                'menu_icon'          => 'dashicons-admin-post',
                'supports'           => ['title', 'thumbnail', 'editor', 'excerpt'],
                'public'             => true,
                'publicly_queryable' => true,
                'rewrite'            => [
                    'slug' => apply_filters('fortis_cms_career_slug', 'case'),
                ],
            ],
            'labels' => [],
        ];
        // Header Top
        $postypes['cms-header-top'] = [
            'status'     => apply_filters('fortis_enable_header_top', true),
            'item_name'  => esc_html__('Header Top', 'fortis'),
            'items_name' => esc_html__('Headers Top', 'fortis'),
            'args'       => [
                'menu_icon'          => 'dashicons-editor-insertmore',
                'supports'           => ['title', 'editor', 'thumbnail'],
                'public'             => true,
                'publicly_queryable' => true,
            ],
            'labels' => [],
        ];
        // Footer
        $postypes['cms-footer'] = [
            'status'     => apply_filters('fortis_enable_footer', true),
            'item_name'  => esc_html__('Footer', 'fortis'),
            'items_name' => esc_html__('Footers', 'fortis'),
            'args'       => [
                'menu_icon'          => 'dashicons-editor-insertmore',
                'supports'           => ['title', 'editor', 'thumbnail'],
                'public'             => true,
                'publicly_queryable' => true,
            ],
            'labels' => [],
        ];

        return $postypes;
    }
}
add_filter('cms_extra_taxonomies', 'fortis_add_tax');
if(!function_exists('fortis_add_tax')){
    function fortis_add_tax($taxonomies){
        $taxonomies['portfolio-category'] = [
            'status'      => apply_filters('fortis_enable_portfolio', false),
            'post_type'   => ['portfolio'],
            'taxonomy'    => esc_html__('Portfolio Category', 'fortis'),
            'taxonomies'  => esc_html__('Portfolio Categories', 'fortis'),
            'args'        => [],
            'labels'      => [],
        ];
        $taxonomies['service-category'] = [
            'status'      => apply_filters('fortis_enable_service', true),
            'post_type'   => ['cms-service'],
            'taxonomy'    => esc_html__('Service Category', 'fortis'),
            'taxonomies'  => esc_html__('Service Categories', 'fortis'),
            'args'        => [],
            'labels'      => [],
        ];
        $taxonomies['industry-category'] = [
            'status'      => apply_filters('fortis_enable_industry', true),
            'post_type'   => ['cms-industry'],
            'taxonomy'    => esc_html__('Industry Category', 'fortis'),
            'taxonomies'  => esc_html__('Industry Categories', 'fortis'),
            'args'        => [],
            'labels'      => [],
        ];
         $taxonomies['case-category'] = [
            'status'      => apply_filters('fortis_enable_case', true),
            'post_type'   => ['cms-case'],
            'taxonomy'    => esc_html__('Case Category', 'fortis'),
            'taxonomies'  => esc_html__('Case Categories', 'fortis'),
            'args'        => [],
            'labels'      => [],
        ];
        return $taxonomies;
    }
}

/**
 * Enable mega menu
 **/
add_filter('cms_enable_megamenu', 'fortis_enable_megamenu');
if(!function_exists('fortis_enable_megamenu')){
    function fortis_enable_megamenu(){
        return true;
    }
}
/* Enable onepage */
add_filter('cms_enable_onepage', 'fortis_enable_onepage');
if(!function_exists('fortis_enable_onepage')){
    function fortis_enable_onepage(){
        return false;
    }
}
/**
 * Pagination Ajax
 * **/
add_action('wp_ajax_fortis_get_pagination_html', 'fortis_get_pagination_html');
add_action('wp_ajax_nopriv_fortis_get_pagination_html', 'fortis_get_pagination_html');
if (!function_exists('fortis_get_pagination_html')) {
    function fortis_get_pagination_html()
    {
        try {
            if (!isset($_POST['query_vars'])) {
                throw new Exception(__('Something went wrong while requesting. Please try again!', 'fortis'));
            }
            $query = $_POST['query_vars'];
            if(isset($_POST['filter']) && !empty($_POST['filter'])){
                $query['tax_query'] = [
                    'relation'       => 'OR',
                ];
                $tmp = explode('|', $_POST['filter']);
                if (isset($tmp[0]) && isset($tmp[1])) {
                    $query['tax_query'][] = array(
                        'taxonomy' => $tmp[1],
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => array($tmp[0]),
                    );
                }
            }
            $query = new WP_Query($query);
            ob_start();
            fortis_posts_pagination($query, true);
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Successfully!', 'fortis'),
                    'data' => array(
                        'html' => $html,
                        'query_vars' => $_POST['query_vars'],
                        'post' => $query->have_posts()
                    ),
                )
            );
        } catch (Exception $e) {
            wp_send_json(array('status' => false, 'message' => $e->getMessage()));
        }
        die;
    }
}
add_action('wp_ajax_fortis_load_more_post_grid', 'fortis_load_more_post_grid');
add_action('wp_ajax_nopriv_fortis_load_more_post_grid', 'fortis_load_more_post_grid');
if (!function_exists('fortis_load_more_post_grid')) {
    function fortis_load_more_post_grid()
    {
        try {
            if (!isset($_POST['settings'])) {
                throw new Exception(__('Something went wrong while requesting. Please try again!', 'fortis'));
            }
            $settings = $_POST['settings'];
            set_query_var('paged', $settings['paged']);
            extract(etc_get_posts_of_grid($settings['posttype'], [
                'source' => isset($settings['source']) ? $settings['source'] : '',
                'orderby' => isset($settings['orderby']) ? $settings['orderby'] : 'date',
                'order' => isset($settings['order']) ? $settings['order'] : 'desc',
                'limit' => isset($settings['limit']) ? $settings['limit'] : '6',
                'post_ids' => '',
            ]));
            ob_start();
            fortis_get_post_grid($settings, $posts, $settings);
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Successfully!', 'fortis'),
                    'data' => array(
                        'html' => $html,
                        'paged' => $settings['paged'],
                        'posts' => $posts,
                        'max' => $max,
                    ),
                )
            );
        } catch (Exception $e) {
            wp_send_json(array('status' => false, 'message' => $e->getMessage()));
        }
        die;
    }
}

/**
 * ================================================
 * All function for Demo Data
 * 
 * @package CMS Theme
 * @subpackage Fotis
 * @since 1.0
 * ================================================
 * 
*/
/* Create Demo Data */
if(!function_exists('fortis_enable_export_mode')){
    function fortis_enable_export_mode() {
        return defined('DEV_MODE') && DEV_MODE == true ? true : false;
    }
}
add_filter('swa_ie_export_mode', 'fortis_enable_export_mode');
if (!function_exists('fortis_cpt_dev_mode')) {
    function fortis_cpt_dev_mode()
    {
        return defined('DEV_MODE') && DEV_MODE == true ? true : false;
    }
}
add_filter('cpt_dev_mode', 'fortis_cpt_dev_mode');
/**
 * Update custom post type edit with Elementor
 * **/
if (!function_exists('fortis_elementor_cpts')) {
    add_action('theme_core_ie_after_import', 'fortis_elementor_cpts');
    add_action('after_switch_theme', 'fortis_elementor_cpts');
    function fortis_elementor_cpts(){
        $default = (array)get_option('elementor_cpt_support');
        $cpt_support = array_merge(
            $default, 
            [
                //core
                'post',
                'page',
                'cms-footer',
                'cms-header-top',
                'cms-mega-menu',
                'portfolio',
                // theme
                'cms-career',
                'cms-case',
                'cms-industry',
                'cms-service',
                // WooCommerce
                //'product'
            ]
        );
        update_option( 'elementor_cpt_support', $cpt_support );
    }
}
/**
 * Update Option TranslatePress
 * 
 * */
if(!function_exists('fortis_translatepress_configs')){
    add_action('plugins_loaded', 'fortis_translatepress_configs');
    add_action('activate_translatepress-multilingual/index.php', 'fortis_translatepress_configs');
    add_action('theme_core_ie_after_import', 'fortis_translatepress_configs');
    function fortis_translatepress_configs(){
        $trp_settings = (array)get_option('trp_settings');
        $trp_settings['trp-ls-floater'] = 'no'; // Hide Floating language selection
        $trp_settings['trp-ls-show-poweredby'] = 'no'; // Hide "Powered by TranslatePress"
        update_option( 'trp_settings', $trp_settings );
    }
}

/**
 * Update Wordpress Configs
 * Change Permalink
 * 
 * */
add_action('after_switch_theme', 'fortis_permalink');
if(!function_exists('fortis_permalink')){
    function fortis_permalink(){
        if (isset($_GET['activated']) && is_admin()) {
            global $wp_rewrite;
            $wp_rewrite->set_permalink_structure('');
            $wp_rewrite->flush_rules();
        }
    }
}
add_action('theme_core_ie_after_import', 'fortis_permalink_postname');
if(!function_exists('fortis_permalink_postname')){
    function fortis_permalink_postname(){
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
        $wp_rewrite->flush_rules();
    }
}

/*
 *  Dashboard Configurations
 */
if (!function_exists('fortis_cpt_dashboard_config')) {
    add_filter('cpt_dashboard_config', 'fortis_cpt_dashboard_config');
    function fortis_cpt_dashboard_config()
    {
        return [
            'documentation_link'  => 'https://cmssuperheroes.gitbook.io/fortis-wordpress-theme/',
            'ticket_link'         => 'https://cmssuperheroes.ticksy.com/',
            'video_tutorial_link' => 'https://www.youtube.com/c/CMSSuperheroes',
            'demo_link'           => 'http://demo.cmssuperheroes.com/themeforest/fortis/',
        ];
    }
}
add_filter('cms_documentation_link', function(){ return 'https://cmssuperheroes.gitbook.io/fortis-wordpress-theme/';});
add_filter('cms_ticket_link', function(){ return ['type' => 'url', 'link' => 'https://cmssuperheroes.ticksy.com/'];});
add_filter('cms_video_tutorial_link', function(){ return 'https://www.youtube.com/c/CMSSuperheroes';});
/**
 * =========================
 * End Demo Data
 * =========================
 * */

/* ------Disable Lazy loading---- */
add_filter('wp_lazy_loading_enabled', '__return_false');
