<?php
/**
 * Custom template tags for this theme.
 *
 * @package Fortis
 */

/**
 * Page loading.
 **/
function fortis_page_loading(){
    $page_loading = fortis_get_opt('show_page_loading', false);
    if ($page_loading) { ?>
        <section id="cms-loadding" class="cms-loader">
            <div class="loading-spinner">
                <div class="cms-bounce1"></div>
                <div class="cms-bounce2"></div>
                <div class="cms-bounce3"></div>
            </div>
        </section>
    <?php }
}
/**
 * Header Top
 * 
 * **/
if(!function_exists('fortis_header_top')){
    function fortis_header_top($args = []){
        if(is_singular('cms-header-top') || is_singular('cms-footer')  || is_singular('cms-mega-menu') ) return;
        $args = wp_parse_args($args, []);
        $header_top_layout = fortis_get_opts('header_top_layout', '', 'header_top_custom');
        $cms_post = get_post($header_top_layout);
        if(in_array($header_top_layout, ['-1', '0', 'none', ''])) return;
        if (!is_wp_error($cms_post) && $cms_post->ID == $header_top_layout && class_exists('Elementor_Theme_Core') && class_exists('\Elementor\Plugin')){
            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $header_top_layout );
            if(empty($content)){
                $content = $cms_post->post_content;
            }
        } else {
            $content = $cms_post->post_content;
        }
    ?>
    <div id="cms-header-top" class="cms-header-top empty-none"><?php 
        printf('%s', $content); 
    ?></div>
    <?php
    }
}
/**
 * Header layout.
 **/
function fortis_header_layout(){
    $header_layout = fortis_get_opts('header_layout', '1', 'header_custom');
    if ($header_layout == '0' || is_singular('cms-header-top') || is_singular('cms-footer')  || is_singular('cms-mega-menu')) return;
    get_template_part('template-parts/header/header-layout', $header_layout);
}
/**
 * Header
 * Header Class
 * **/
if(!function_exists('fortis_header_classes')){
    function fortis_header_classes($class = ''){
        $classes = [
            'cms-header',
            'header-layout-'.fortis_get_opts('header_layout','1', 'header_custom'),
            'sticky-'.fortis_get_opts( 'header_sticky', 'off', 'header_custom'),
            'transparent-'.fortis_get_opts( 'header_transparent', 'off', 'header_custom'),
            $class
        ];
        if(fortis_get_opts( 'header_transparent', 'off', 'header_custom') === 'on'){
            $classes[] = 'header-transparent';
        }
        return implode(' ', array_filter($classes));
    }
}
/**
 * Header Container class 
 * 
 * **/
if(!function_exists('fortis_header_container_classes')){
    function fortis_header_container_classes($class = ''){
        $classes = [
            'cms-header-main',
            fortis_get_opts( 'header_width', 'container', 'header_custom'),
            $class
        ];
        return implode(' ', array_filter($classes));
    }
}
/**
 * Header Search 
 * 
 * */
if(!function_exists('fortis_header_search')){
    function fortis_header_search($args = []){
        $args = wp_parse_args($args, [
            'class' => '',
            'echo'  => true
        ]);
        $search_on = fortis_get_opts('search_icon', 'off', 'header_custom');
        if($search_on != 'on') return;
        add_action('wp_footer', 'fortis_search_popup');
        $classes = ['site-header-item site-header-search menu-color cms-modal', $args['class']];
    ob_start();
?>
    <div class="<?php echo implode(' ', array_filter($classes)); ?>" data-modal="#cms-modal-search" data-focus=".cms-search-input"><i class="cmsi-search search-toggle"></i></div>
<?php
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
/**
 * Header Search Popup
 */
function fortis_search_popup(){ 
    $placeholder = fortis_get_opt('search_field_placeholder', esc_html__('Type Words Then Enter', 'fortis'));
    ?>
    <div id="cms-modal-search" class="cms-modal-html cms-modal-fade cms-modal-search">
        <i class="cms-modal-close cms-close cmsi-remove"></i>
        <div class="cms-modal-content">
            <form role="search" method="get" class="search-popup relative" action="<?php echo esc_url(home_url('/')); ?>">
                <input type="text" placeholder="<?php echo esc_attr($placeholder); ?>" name="s" class="cms-search-popup-input"/>
                <button type="submit" class="cms-search-popup-submit"><i class="cmsi-search"></i></button>
            </form>
        </div>
    </div>
<?php }
/**
 * Header Cart
 * 
 * */
if(!function_exists('fortis_header_cart')){
    function fortis_header_cart($args = []){
        $args = wp_parse_args($args, [
            'class' => '',
            'echo'  => true,
            'icon'  => 'cmsi-shopping-cart',
            'position' => 'dropdown' // modal
        ]);
        $cart_on = fortis_get_opts('cart_icon', 'off', 'header_custom');
        if(!class_exists('Woocommerce') || $cart_on != 'on') return;
        $classes  =['site-header-item site-header-cart menu-color', $args['class']];

        switch ($args['position']) {
            case 'modal':
                $classes[] = 'cms-modal';
                add_action('wp_footer', 'fortis_cart_content');
                break;
            
            default:
                $classes[] = 'cms-touchedside';
                add_action('fortis_cart_dropdown', 'fortis_cart_content_dropdown');
                break;
        }
    ob_start();
?>
    <div class="<?php  echo implode(' ', array_filter($classes)); ?>" data-modal="#cms-modal-cart">
        <div class="relative cms-cart-icon">
            <i class="cart-icon <?php echo esc_attr($args['icon']) ?> rtl-flip"></i>
            <span class="cart-counter cart_total"><?php echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'fortis' ), WC()->cart->cart_contents_count ); ?></span>
        </div>
        <?php do_action('fortis_cart_dropdown'); ?>
    </div>
<?php
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
/**
 * Header Cart
 * Update cart count
 * 
 * */
if(!function_exists('fortis_woocommerce_add_to_cart_fragments')){
    add_filter('woocommerce_add_to_cart_fragments', 'fortis_woocommerce_add_to_cart_fragments', 10, 1 );
    function fortis_woocommerce_add_to_cart_fragments( $fragments ) {
        if(!class_exists('WooCommerce')) return;
        ob_start();
        ?><span class="cart-counter cart_total">
            <?php echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'fortis' ), WC()->cart->cart_contents_count ); ?>
        </span>
        <?php
        $fragments['.cart_total'] = ob_get_clean();

        return $fragments;
    }
}

/**
 * 
 * Cart Content
 * 
 */
function fortis_cart_content(){
    if (!class_exists('Woocommerce')) return;
?>
    <div id="cms-modal-cart" class="cms-modal-html cms-modal-slide cms-modal-cart cms-shadow-1">
        <span class="cms-modal-close cms-close cmsi-remove"></span>
        <div class="cms-modal-content">
            <div class="widget_shopping_cart cms-mousewheel">
                <div class="widget_shopping_cart_content">
                    <?php woocommerce_mini_cart(); ?>
                </div>
            </div>
        </div>
    </div>
<?php
}
function fortis_cart_content_dropdown(){
    if (!class_exists('Woocommerce')) return;
?>
    <div class="cms-header-cart-dropdown cms--touchedside overflow-hidden">
        <div class="widget_shopping_cart cms-mousewheel">
            <div class="widget_shopping_cart_content">
                <?php woocommerce_mini_cart(); ?>
            </div>
        </div>
    </div>
<?php
}
/**
 * Header Phone
 * */
if(!function_exists('fortis_header_phone_render')){
    function fortis_header_phone_render($args = []){
        $args = wp_parse_args($args, [
            'name'  => '',
            'class' => 'btn btn-outline btn-sm',
            'icon'  => 'cmsi-phone-alt',
            'data'  => [
                'default'     => 'btn-1',
                'transparent' => 'btn-white-25'
            ],
            'style' => ''
        ]);
        $phone_number = fortis_get_opt('h_phone'.$args['name'].'_number', '');
        if(fortis_get_opts('h_phone'.$args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($phone_number) ) return;
        $tel = str_ireplace(' ', '', $phone_number); // remove space for link

        $classes = ['h-btn', $args['class'], $args['style']];
    ?>
        <div class="site-header-item site-header-button site-header-phone d-flex">
            <a class="<?php echo implode(' ', array_filter($classes)); ?>" data-classes='<?php echo wp_json_encode($args['data']); ?>' href="tel:<?php echo esc_attr($tel);?>"><?php 
                if(!empty($args['icon'])) echo '<i class="phone-icon '.esc_attr($args['icon']).' rtl-flip"></i>';
                printf('<span class="cms-hidden-laptop">%s</span>', $phone_number);
            ?></a>
        </div>
    <?php
    }
}
/**
 * Header Button
 * */
if(!function_exists('fortis_header_button_render')){
    function fortis_header_button_render($args = []){
        $args = wp_parse_args($args, [
            'name'  => 'h_btn',
            'class' => 'btn btn-outline btn-sm',
            'icon'  => '',
            'data'  => [
                'default'     => '',
                'transparent' => ''
            ]
        ]);
        $h_btn_text        = fortis_get_opt( $args['name'].'_text' );
        if(fortis_get_opts($args['name'].'_on', 'off', 'header_custom') !== 'on' || empty($h_btn_text)) return;

        $h_btn_link_type   = fortis_get_opt( $args['name'].'_link_type', 'page' );
        $h_btn_link        = fortis_get_opt( $args['name'].'_link' );
        $h_btn_link_custom = fortis_get_opt( $args['name'].'_link_custom' );
        $h_btn_target      = fortis_get_opt( $args['name'].'_target', '_self' );
        if ( $h_btn_link_type == 'page' ) {
            $h_btn_url = get_permalink( $h_btn_link );
        } else {
            $h_btn_url = $h_btn_link_custom;
        }

        $attrs = [
            'class'        => $args['class'],
            'data-classes' => $args['data']
        ];
    ?>
    <div class="site-header-item site-header-button">
        <a class="h-btn <?php echo esc_attr($attrs['class']); ?>" data-classes='<?php echo wp_json_encode($attrs['data-classes']); ?>' href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr( $h_btn_target ); ?>">
            <?php printf( '%1$s<span class="cms-hidden-laptop">%2$s</span>', $args['icon'], $h_btn_text ); ?>        
        </a>
    </div>
    <?php
    }
}
/**
 * Header
 * Mega Menu
 * */
add_filter('cms_megamenu_render', 'fortis_cms_megamenu_render');
if(!function_exists('fortis_cms_megamenu_render')){
    function fortis_cms_megamenu_render($content, $before, $after){
        $before = $after = '';
        return $before.$content.$after;
    }
}
/**
 * Page title layout
 **/
function fortis_page_title_layout($args = []){
    // remove page title on some custom post type
    if(in_array(get_post_type(), ['cms-service','cms-industry','cms-case', 'cms-career'])) return;

    $args = wp_parse_args($args, [
        'show'            => fortis_get_opts('pagetitle', 'on', 'custom_ptitle'),
        'layout'          => fortis_get_opts('ptitle_layout', '', 'custom_ptitle'),
        'show_title'      => fortis_get_opts('show_title', 'on', 'custom_ptitle'),
        'show_breadcrumb' => fortis_get_opts('show_breadcrumb', 'on', 'custom_ptitle'),
        'ptitle_align'    => fortis_get_opts('ptitle_align', 'start', 'custom_ptitle'),
        'container'       => fortis_get_opts('content_width', 'container', 'on'),
        'class'           => ''
    ]);
    // Configs
    $ptitle_bg = fortis_get_opts('page_title_bg', ['background-color' => '#f9f9f9', 'background-image' => ''], 'custom_ptitle');
    $args['class'] = implode(' ', array_filter([
        'cms-ptitle',
        'text-'.$args['ptitle_align'],
        !empty($ptitle_bg['background-image']) ? 'custom' : '',
        $args['class']
    ]));

    if($args['show'] === 'off' || is_404() || is_singular('cms-header-top') || is_singular('cms-footer')  || is_singular('cms-mega-menu')) return;
    get_template_part('template-parts/page-title', $args['layout'], $args);
}
/**
 * Get page title and description.
 *
 * @return array Contains 'title'
 */
function fortis_get_page_titles(){
    $title = '';

    // Default titles
    if (!is_archive()) {
        // Posts page view
        if (is_home()) {
            // Only available if posts page is set.
            if (
                !is_front_page() &&
                ($page_for_posts = get_option('page_for_posts'))
            ) {
                $title = get_post_meta($page_for_posts, 'custom_title', true);
                if (empty($title)) {
                    $title = get_the_title($page_for_posts);
                }
            }
            if (is_front_page()) {
                $title = esc_html__('Blog', 'fortis');
            }
        }
        // Single page view
        elseif (is_page()) {
            $title = get_post_meta(get_the_ID(), 'custom_title', true);
            if (!$title) {
                $title = get_the_title();
            }
        } elseif (is_404()) {
            $title = esc_html__('404', 'fortis');
        } elseif (is_search()) {
            $title = esc_html__('Search results', 'fortis');
        } else {
            $title = get_post_meta(get_the_ID(), 'custom_title', true);
            if (!$title) {
                $title = get_the_title();
            }
        }
    } elseif (is_author()) {
        $title = esc_html__('Author:', 'fortis') . ' ' . get_the_author();
    }
    // Author
    else {
        $title = get_the_archive_title();
        if (class_exists('WooCommerce') && is_shop()) {
            $title = esc_html__('Our Shop', 'fortis');
        }
    }

    return [
        'title' => $title,
    ];
}
/**
 * Prints HTML for breadcrumbs.
 */
function fortis_breadcrumb($args= []){
    if (!class_exists('CMS_Breadcrumb')) {
        return;
    }

    $breadcrumb = new CMS_Breadcrumb();
    $entries = $breadcrumb->get_entries();

    if (empty($entries)) {
        return;
    }
    $args = wp_parse_args($args, ['class' => '']);

    ob_start();

    foreach ($entries as $entry) {
        $entry = wp_parse_args($entry, array(
            'label' => '',
            'url' => ''
        ));

        if (empty($entry['label'])) {
            continue;
        }

        echo '<li>';

        if (!empty($entry['url'])) {
            printf(
                '<a class="breadcrumb-entry" href="%1$s">%2$s</a>',
                esc_url($entry['url']),
                esc_attr($entry['label'])
            );
        } else {
            printf('<span class="breadcrumb-entry" >%s</span>', esc_html($entry['label']));
        }

        echo '</li>';
    }

    $output = ob_get_clean();

    if ($output) {
        printf('<ul class="%1$s">%2$s</ul>',implode(' ', array_filter(['cms-breadcrumb unstyled', $args['class']])), $output);
    }
}
/**
 * Main Content 
 * 
 * **/
if(!function_exists('fortis_main_content_classes')){
    function fortis_main_content_classes($args = []){
        $args = wp_parse_args($args, [
            'class' => '',
            'sidebar' => ''
        ]);
        $classes = [
            'cms-main',
            $args['class']
        ];
        if(fortis_is_built_with_elementor()){
            $classes[] = 'is-elementor';
        } else {
            $classes[] = fortis_get_opts('content_width', 'container', 'on');
            // Search page
            $classes[] = is_search() ? 'cms-main-sidebar d-flex' : '';
            // Post type archive 
            $classes[] = (fortis_get_opt('sidebar_on','off') === 'on' && (is_post_type_archive() || is_tax()) ) ? 'cms-main-sidebar d-flex' : '';
            // Shop page
            if(class_exists('WooCommerce') && is_shop() && is_active_sidebar('sidebar-product')){
                $classes[] = 'cms-main-sidebar d-flex';
            }
            // single post type
            $classes[] = (fortis_get_opt('sidebar_on','off') === 'on' && !in_array(get_post_type(), ['cms-footer','cms-header-top','page', 'cms-service','cms-industry', 'cms-case','cms-porfolio','cms-career','portfolio']) ) ? 'cms-main-sidebar d-flex' : '';
        }
        echo implode(' ', array_filter($classes));
    }
}
function fortis_content_has_sidebar_open($sidebar=''){
    if(!is_active_sidebar($sidebar)) return;
    ?>
    <div class="cms-main-content">
    <?php
}
function fortis_content_has_sidebar_close($sidebar=''){
    if(!is_active_sidebar($sidebar)) return;
    ?>
    </div>
    <?php
}

/**
 * Footer layout
 **/
function fortis_footer(){
    if(is_singular('cms-header-top') || is_singular('cms-footer')  || is_singular('cms-mega-menu')) return;
    //get_template_part('template-parts/footer-layout','');
    $footer_layout = fortis_get_opts('footer_layout', '1', 'footer_custom');

    switch ($footer_layout){
        case 'none':
            break;
        case '1':
            fortis_footer_copyright();
            break;
        default : 
            fortis_footer_elementor_builder();
            break;
    }
}
/*
 * Footer css class
*/
if(!function_exists('fortis_footer_css_class')){
    function fortis_footer_css_class($args = []){
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
        $footer_layout = fortis_get_opts( 'footer_layout', '1' );
        $footer_fixed = fortis_get_opts('footer_fixed', '0');
        $css_classes = [
            'cms-footer',
            'relative'
        ];
        if(!in_array($footer_layout, ['-1', '0', '1', 'none'])) {
            $css_classes[] = 'cms-footer-elementor';
        } else {
            $css_classes[] = fortis_get_opts('content_width', 'container', 'on');
        }

        if($footer_fixed == '1') $css_classes[] = 'cms-footer-fixed';
        echo implode(' ', array_filter($css_classes));
    }
}
if(!function_exists('fortis_default_copyright_text')){
    function fortis_default_copyright_text($text = '', $args = []){
        $args = wp_parse_args($args, [
            'link_color'       => '',
            'link_hover_color' => ''
        ]);
        if(!empty($text)){
            $default_copyright_text = $text;
        } else {
            $default_copyright_text = sprintf( esc_html__('&copy;%s %s, All Rights Reserved. With Love by %s ','fortis'), date('Y') , get_bloginfo('name'), '<a href="'.esc_url('https://cmssuperheroes.com/').'" target="_blank" rel="nofollow" class="'.$args['link_color'].' '.$args['link_hover_color'].'">'.esc_html__('CMSSuperHeroes.com','fortis').'</a>');
        }
        return $default_copyright_text;
    }
}
if(!function_exists('fortis_footer_copyright')){
    function fortis_footer_copyright($args = []){
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
        $classes = ['cms-copyright-text cms-footer-copyright', $args['class']];

        if(is_404()) $classes[] = 'text-center';
    ?>
    <div class="<?php echo implode(' ', array_filter($classes));?>">
        <?php echo fortis_default_copyright_text(); ?>
    </div>
    <?php
    }
}
/**
* Footer elementor builder
*
*/
if(!function_exists('fortis_footer_elementor_builder')){
    function fortis_footer_elementor_builder(){
        if(!class_exists('Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $footer_layout = fortis_get_opts('footer_layout', '1', 'footer_custom');
        if(in_array($footer_layout, ['-1', '0', '1', 'none'])) return;
        $cms_post = get_post($footer_layout);
        if (!is_wp_error($cms_post) && $cms_post->ID == $footer_layout){
            $content = \Elementor\Plugin::$instance->frontend->get_builder_content( $footer_layout );
            if(!empty($content)){
                etc_print_html($content);
            } else {
            ?>
            <div class="<?php etc_print_html(fortis_get_opts('content_width', 'container', 'on'));  ?> cms-copyright-text cms-footer-copyright">
                <?php etc_print_html($cms_post->post_content); ?>
            </div>
            <?php 
            }
        }
    }
}

/**
 * Post Title
 * 
 * */
if(!function_exists('fortis_entry_title')){
    function fortis_entry_title(){
    ?>
        <h2 class="cms-post-title lh-1-225">
            <a href="<?php echo esc_url( get_permalink() ); ?>">
                <?php if ( is_sticky() ) { ?>
                    <i class="cmsi-thumbtack"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h2>
    <?php
    }
}
if(!function_exists('fortis_entry_single_title')){
    function fortis_entry_single_title(){
    ?>
        <h2 class="cms-post-title cms-post-single-title">
            <?php the_title(); ?>
        </h2>
    <?php
    }
}

/**
 * Post Thumbnail
 * 
 * */
if(!function_exists('fortis_entry_thumbnail')){
    function fortis_entry_thumbnail($args = []){
        if ( !has_post_thumbnail() ) return;
        $args = wp_parse_args($args, [
            'class' => '',
            'size'  => 'medium',
            'lazy'  => true,
            'tax'   => 'category'
        ]);
        $classes = implode(' ', array_filter(['cms-post-thumbnail', 'relative',$args['class']]));
        
        $opt_prefix = is_singular('post')?'post_':'archive_';
        $categories_on = (bool) fortis_get_opt($opt_prefix.'categories_on', true);
    ?>
        <div class="<?php echo esc_attr($classes); ?>">
            <?php
            fortis_the_post_thumbnail($args['size']);
            if($categories_on) {
            ?>
                 <div class="cms-thumb-meta empty-none absolute"><?php the_terms(get_the_ID(), $args['tax'], '', ', '); ?></div>
            <?php
            }
        ?></div>
    <?php
    }
}
if(!function_exists('fortis_the_post_thumbnail')){
    function fortis_the_post_thumbnail($size='medium'){
        $image_size_w = get_option($size.'_size_w');
        $image_size_h = get_option($size.'_size_h');
        printf(
            '<img width="%1$s" height="%2$s" class="%3$s" data-src="%4$s" />',
            $image_size_w,
            $image_size_h,
            'cms-lazy loading',
            get_the_post_thumbnail_url(null, $size)
        );
    }
}
/**
 * Get excerpt
 * The excerpt with custom length.
 * @return string      
 */
function fortis_get_the_excerpt($length = 55, $post = null){
    $post = get_post($post);

    if (empty($post) || 0 >= $length) {
        return '';
    }

    if (post_password_required($post)) {
        return esc_html__('Post password required.', 'fortis');
    }

    $content = apply_filters(
        'the_content',
        strip_shortcodes($post->post_content)
    );
    $content = str_replace(']]>', ']]&gt;', $content);

    $excerpt_more = apply_filters('fortis_excerpt_more', '&hellip;');
    $excerpt = wp_trim_words($content, $length, $excerpt_more);

    return $excerpt;
}
/**
* Print post excerpt based on length.
*
* @param integer $length
*/
if (!function_exists('fortis_entry_excerpt')) :
    function fortis_entry_excerpt($length = 55)
    {
        $cms_the_excerpt = get_the_excerpt();
        if (!empty($cms_the_excerpt)) {
            echo esc_html($cms_the_excerpt);
        } else {
            echo wp_kses_post(fortis_get_the_excerpt($length));
        }
    }
endif;
/**
 * Post Page Link
 * */
function fortis_entry_link_pages(){
    wp_link_pages(array(
        'before'      => '<div class="cms-page-links d-flex gap" style="--cms-gap:20px;">',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
    ));
}
/**
 * Post Readmore
 * */
if(!function_exists('fortis_entry_readmore')){
    function fortis_entry_readmore(){
    ?>
        <div class="cms-readmore">
            <a class="btn btn-secondary btn-hover-primary" href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__( 'Read More', 'fortis' ); ?></a>
        </div>
    <?php
    }
}
/**
 * Prints post meta
 */
if (!function_exists('fortis_post_meta')) :
    function fortis_post_meta($args = [])
    {
        $args = wp_parse_args($args, [
            'opt_prefix' => 'archive_',
            'class'      => '',
            'gap'        => '--cms-gap:0px;',
            'tax'        => 'category' 
        ]);
        $classes = ['cms-post-meta', $args['class'], 'd-flex'];
        if(!empty($args['gap'])) $classes[] = 'gap';
        $author_on     = (bool) fortis_get_opt($args['opt_prefix'].'author_on', true);
        $categories_on = (bool) fortis_get_opt($args['opt_prefix'].'categories_on', true);
        $date_on       = (bool) fortis_get_opt($args['opt_prefix'].'date_on', true);
        $comments_on   = (bool) fortis_get_opt($args['opt_prefix'].'comments_on', false);
        if ($author_on || $comments_on || $categories_on || $date_on) : ?>
            <div class="<?php echo implode(' ', array_filter($classes)); ?>" style="<?php echo esc_attr($args['gap']); ?>">
                <?php if ($author_on) : ?>
                    <div class="meta-item author empty-none">
                        <?php fortis_the_author_posts_link([
                            'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                            'link_class' => 'text-primary text-hover-secondary'
                        ]); ?>
                    </div>
                <?php endif; ?>
                <?php if ($categories_on && !has_post_thumbnail() ) : ?>
                    <div class="meta-item category empty-none"><?php the_terms(get_the_ID(), $args['tax'], '', ', '); ?></div>
                <?php endif; ?>
                <?php if ($date_on) : ?>
                    <div class="meta-item date empty-none"><?php echo get_the_date(); ?></div>
                <?php endif; ?>
                <?php if ($comments_on) : ?>
                    <div class="meta-item comment empty-none"><?php fortis_comment_number(['link_class' => 'text-primary']); ?></div>
                <?php endif; ?>
            </div>
        <?php endif;
    }
endif;
/**
 * Author Post link
 * 
 * */
if(!function_exists('fortis_the_author_posts_link')){
    function fortis_the_author_posts_link($args = []){
        $args = wp_parse_args($args, [
            'id'         => '',   
            'text'       => '',
            'link_class' => '',
            'object'     => ''
        ]);
        if(! is_object($args['object'])){
            global $authordata;
            if ( ! is_object( $authordata ) ) {
                return '';
            }
            $user_id = $authordata->ID;
        } else {
            $user_id = $args['object']->post_author;
        }

        

        $link = sprintf(
            '%1$s<a href="%2$s" title="%3$s" class="%4$s" rel="author">%5$s</a>',
            $args['text'],
            esc_url( get_author_posts_url( $user_id , get_the_author_meta('user_nicename',$user_id ) ) ),
            /* translators: %s: Author's display name. */
            esc_attr( sprintf( esc_html__( 'Posts by %s', 'fortis' ), get_the_author_meta('display_name', $user_id ) ) ),
            $args['link_class'],
            get_the_author_meta('display_name', $user_id )
        );
        echo apply_filters( 'fortis_the_author_posts_link', $link );
    }
}
/**
 * Post Comment Count
 * */
if(!function_exists('fortis_comments_link')){
    function fortis_comment_number($args=[]){
        $args = wp_parse_args($args, [
            'title_class' => 'text-meta text-hover-primary',
            'link_class'  => ''  
        ]);
        $number = get_comments_number();
        switch ($number) {
            case '1':
                $html = '<span class="'.$args['title_class'].'">'.esc_html__('Comment','fortis').':&nbsp;</span>'.number_format_i18n($number);
                break;
            default:
                $html = '<span class="'.$args['title_class'].'">'.esc_html__('Comments','fortis').':&nbsp;</span>'.number_format_i18n($number);
                break;
        }
    ?>
        <a href="<?php the_permalink(); ?>" class="<?php echo esc_attr($args['link_class']); ?>"><?php printf('%s', $html);?></a>
    <?php
    }
}
/**
 * Prints tag list
 */
if (!function_exists('fortis_entry_tagged_in')){
    function fortis_entry_tagged_in($args = []) {
        $show_tag  = (bool)fortis_get_opt('post_tags_on', true);
        $tags_list = get_the_tag_list('', ' ');
        if (!$tags_list || !$show_tag) return;
        $args = wp_parse_args($args, [
            'class' => ''
        ]);
    ?>
        <div class="<?php echo implode(' ', array_filter(['cms-post-tags', $args['class']])) ?>">
            <div class="label w-100"><?php esc_html_e('Post Tags','fortis'); ?>:</div>
            <div class="tagcloud">
                <?php printf('%2$s', '', $tags_list); ?>
            </div>
        </div>
    <?php 
    }
}

/**
 * List socials share for post.
 * 
 */

function fortis_socials_share_default($args = []) {
    $args = wp_parse_args($args, [
        'class' => ''
    ]);
    $img_url = get_the_post_thumbnail_url();
    ob_start();
    ?>
    <a title="<?php echo esc_attr__('Pinterest', 'fortis'); ?>" target="_blank"
               href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url); ?>&description=<?php the_title(); ?>" 
               class="cmsi-pinterest-p d-none"></a>
    <?php $pinterest = ob_get_clean(); ?>
    <div class="<?php echo implode(' ', array_filter(['cms-social-share', $args['class']])) ?>">
        <div class="label w-100"><?php echo esc_html__('Share:', 'fortis'); ?></div>
        <div class="d-flex gap" style="--cms-gap:10px;--cms-gap-mobile:10px;">
            <a title="<?php echo esc_attr__('Facebook', 'fortis'); ?>" target="_blank"
               href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" 
               class="cmsi-facebook"></a>
            <a title="<?php echo esc_attr__('Twitter', 'fortis'); ?>" target="_blank"
               href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>" 
               class="cmsi-twitter-circle"></a>
            <a title="<?php echo esc_attr__('LinkedIn', 'fortis'); ?>" target="_blank"
               href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" 
               class="cmsi-linkedin-circle"></a>
        </div>
    </div>
    <?php
}

/**
 * Custom Comment List
 */
function fortis_comment_list($comment, $args, $depth){
    $add_below = 'comment'; 
    $comment_classes = [empty($args['has_children'])?'':'parent'];
    ?>
    <div id="comment-<?php comment_ID(); ?>" <?php comment_class(implode(' ', array_filter($comment_classes)));?> >
        <div class="d-flex gap" style="--cms-gap-mobile:20px;">
            <div class="comment-avatar flex-auto"><?php if ($args['avatar_size'] != 0) {
                echo get_avatar($comment, 80);
            } ?></div>
            <div class="comment-content flex-basic flex-mobile-auto">
                <div class="comment-heading d-flex gap align-items-center">
                    <div class="comment-name font-700 text-heading">
                        <?php printf('%s', get_comment_author_link()); ?>
                    </div>
                    <div class="comment-meta text-meta">
                        <?php echo get_comment_date() . ' - ' . get_comment_time(); ?>
                    </div>
                </div>
                <div class="comment-text"><?php comment_text(); ?></div>
                <div class="comment-reply">
                    <?php comment_reply_link(
                          array_merge($args, [
                              'add_below' => $add_below,
                              'depth'     => $depth,
                              'max_depth' => $args['max_depth']
                          ])
                      ); ?>
                </div>
            </div>
        </div>

<?php }

/* Author Social */
function fortis_get_user_social(){
    $user_facebook = get_user_meta(get_the_author_meta('ID'), 'user_facebook', true);
    $user_twitter = get_user_meta(get_the_author_meta('ID'), 'user_twitter', true);
    $user_linkedin = get_user_meta(get_the_author_meta('ID'), 'user_linkedin', true);
    $user_skype = get_user_meta(get_the_author_meta('ID'), 'user_skype', true);
    $user_youtube = get_user_meta(get_the_author_meta('ID'), 'user_youtube', true);
    $user_vimeo = get_user_meta(get_the_author_meta('ID'), 'user_vimeo', true);
    $user_tumblr = get_user_meta(get_the_author_meta('ID'), 'user_tumblr', true);
    $user_rss = get_user_meta(get_the_author_meta('ID'), 'user_rss', true);
    $user_pinterest = get_user_meta(get_the_author_meta('ID'), 'user_pinterest', true);
    $user_instagram = get_user_meta(get_the_author_meta('ID'), 'user_instagram', true);
    $user_yelp = get_user_meta(get_the_author_meta('ID'), 'user_yelp', true);

    ?>
    <div class="user-social unstyled d-flex gap" style="--cms-gap:10px;--cms-gap-mobile:10px;">
        <?php if (!empty($user_facebook)) { ?>
            <a href="<?php echo esc_url($user_facebook); ?>" class="cmsi-facebook"></a>
        <?php } ?>
        <?php if (!empty($user_twitter)) { ?>
            <a href="<?php echo esc_url($user_twitter); ?>" class="cmsi-twitter-circle"></a>
        <?php } ?>
        <?php if (!empty($user_linkedin)) { ?>
            <a href="<?php echo esc_url($user_linkedin); ?>" class="cmsi-linkedin-circle"></a>
        <?php } ?>
        <?php if (!empty($user_rss)) { ?>
            <a href="<?php echo esc_url($user_rss); ?>" class="cmsi-rss"></a>
        <?php } ?>
        <?php if (!empty($user_instagram)) { ?>
            <a href="<?php echo esc_url($user_instagram); ?>" class="cmsi-instagram"></a>
        <?php } ?>
        <?php if (!empty($user_skype)) { ?>
            <a href="<?php echo esc_url($user_skype); ?>" class="cmsi-skype"></a>
        <?php } ?>
        <?php if (!empty($user_pinterest)) { ?>
            <a href="<?php echo esc_url($user_pinterest); ?>" class="cmsi-pinterest"></a>
        <?php } ?>
        <?php if (!empty($user_vimeo)) { ?>
            <a href="<?php echo esc_url($user_vimeo); ?>" class="cmsi-vimeo-v"></a>
        <?php } ?>
        <?php if (!empty($user_youtube)) { ?>
            <a href="<?php echo esc_url($user_youtube); ?>" class="cmsi-youtube"></a>
        <?php } ?>
        <?php if (!empty($user_yelp)) { ?>
            <a href="<?php echo esc_url($user_yelp); ?>" class="cmsi-yelp"></a>
        <?php } ?>
        <?php if (!empty($user_tumblr)) { ?>
            <a href="<?php echo esc_url($user_tumblr); ?>" class="cmsi-tumblr"></a>
        <?php } ?>

    </div> <?php
}
/**
 * Prints posts pagination based on query
 *
 * @param WP_Query $query Custom query, if left blank, this will use global query ( current query )
 *
 * @return void
 */
if(!function_exists('fortis_posts_pagination')){
    function fortis_posts_pagination($query = null, $ajax = false){
        if ($ajax) {
            add_filter('paginate_links', 'fortis_ajax_paginate_links');
        }

        $classes = array();

        if (empty($query)) {
            $query = $GLOBALS['wp_query'];
        }

        if (empty($query->max_num_pages) || !is_numeric($query->max_num_pages) || $query->max_num_pages < 2) {
            return;
        }

        $paged = $query->get('paged', '');

        if (!$paged && is_front_page() && !is_home()) {
            $paged = $query->get('page', '');
        }

        $paged = $paged ? intval($paged) : 1;

        $pagenum_link = html_entity_decode(get_pagenum_link());
        $query_args = array();
        $url_parts = explode('?', $pagenum_link);

        if (isset($url_parts[1])) {
            wp_parse_str($url_parts[1], $query_args);
        }

        $pagenum_link = remove_query_arg(array_keys($query_args), $pagenum_link);
        $pagenum_link = trailingslashit($pagenum_link) . '%_%';

        $html_prev = '<i class="cmsi-arrow-left text-10 rtl-flip"></i>';
        $html_next = '<i class="cmsi-arrow-right text-10 rtl-flip"></i>';
        $paginate_links_args = array(
            'base' => $pagenum_link,
            'total' => $query->max_num_pages,
            'current' => $paged,
            'mid_size' => 1,
            'add_args' => array_map('urlencode', $query_args),
            'prev_text' => $html_prev,
            'next_text' => $html_next,
        );
        if ($ajax) {
            $paginate_links_args['format'] = '?page=%#%';
        }
        $links = paginate_links($paginate_links_args);
        if ($links):
            ?>
            <nav class="navigation posts-pagination <?php echo esc_attr($ajax ? 'ajax' : ''); ?>">
                <div class="posts-page-links d-flex gap" style="--cms-gap:20px;--cms-gap-mobile:10px;">
                    <?php
                        printf($links);
                    ?>
                </div>
            </nav>
        <?php
        endif;
    }
}

/**
 * Single Post
 * 
 * Display navigation to next/previous post when applicable.
 */
function fortis_post_nav_default(){
    if(!fortis_get_opt('post_navigation_on', true)) return;
    global $post;
    $previous = (is_attachment()) ? get_post($post->post_parent) : get_adjacent_post(false, '', true);
    $next = get_adjacent_post(false, '', false);

    if (!$next && !$previous) {
        return;
    }
    ?>
    <?php
    $next_post = get_next_post();
    $previous_post = get_previous_post();

    if (!empty($next_post) || !empty($previous_post)) {
        ?>
        <div class="cms-nav-links d-flex gap justify-content-between" style="--cms-gap:40px;">
            <?php if (is_a($previous_post, 'WP_Post') && get_the_title($previous_post->ID) != '') {
                $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                $prev_img_url = wp_get_attachment_image_src($prev_img_id, 'thumbnail');
                ?>
                <a class="nav-item nav-post-prev" href="<?php echo esc_url(get_permalink($previous_post->ID)); ?>">
                    <i class="nav-icon cmsi-arrow-left rtl-flip"></i>
                    <span><?php echo esc_html__('Prev Post', 'fortis'); ?></span>
                </a>
            <?php } ?>
            <?php if (is_a($next_post, 'WP_Post') && get_the_title($next_post->ID) != '') {
                $next_img_id = get_post_thumbnail_id($next_post->ID);
                $next_img_url = wp_get_attachment_image_src($next_img_id, 'thumbnail');
                ?>
                <a class="nav-item nav-post-next" href="<?php echo esc_url(get_permalink($next_post->ID)); ?>">
                    <span><?php echo esc_html__('Next Post', 'fortis'); ?></span>
                    <i class="nav-icon cmsi-arrow-right rtl-flip"></i>
                </a>
            <?php } ?>
        </div>
    <?php }
}
/**
 * Single Post Comments
 * 
 * Comment Form
 * Move comment field to bottom
 * 
 * **/
function fortis_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    unset( $fields['cookies'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'fortis_comment_field_to_bottom' );
/**
 * Single Post Comments
 * 
 * Comment Form
 * Comment form fields
**/
if(!function_exists('fortis_comment_form_args')){
    function fortis_comment_form_args($args = []){
        $args = wp_parse_args($args, []);
        $commenter = [
            'comment_author' => '',
            'comment_author_email' => ''
        ];
        $cms_comment_fields = array(
            'id_form'              => 'commentform',
            'title_reply_before'   => '<h3 id="reply-title" class="comment-reply-title text-heading-darken">',
            'title_reply'          => is_singular('product') ? esc_attr__('Leave A Review','fortis') : esc_attr__( 'Leave A Reply', 'fortis'),
            'title_reply_to'       => is_singular('product') ? esc_attr__('Leave A Review To','fortis').'%s' : esc_attr__('Leave A Reply To','fortis').'%s',
            'cancel_reply_link'    => is_singular('product') ? esc_attr__( 'Cancel Review', 'fortis') : esc_attr__( 'Cancel Reply', 'fortis'),
            'id_submit'            => 'submit',
            'class_submit'         => 'btn-cmt-submit btn',
            'label_submit'         => is_singular('product') ? esc_attr__('Post Review','fortis') : esc_attr__('Post Comment','fortis'),
            'submit_button'        => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s">%4$s</button>', 
            'comment_notes_before' => '',
            'comment_field'        =>  '',
        );

        $cms_fields = [];
        $cms_fields['open'] = '';
        if(!is_user_logged_in()){
            $cms_fields['open'] .= fortis_comment_rating_fields([
                'echo' => false,
                'class' => 'mb-20'
            ]);
            $cms_fields['open'] .= fortis_woocommerce_comment_rating_fields([
                'echo' => false,
                'class' => 'mb-20'
            ]);
        }
        //open
        $cms_fields['open'] .= '<div class="cms-comment-form-fields-wrap d-flex gutter" style="--gutter-mobile:20px;">';
        // author
        $cms_fields['author'] = '<div class="comment-form-field comment-form-author col-4 col-mobile-12">'.
                    '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
                    '" size="30" placeholder="'.esc_attr__('Name', 'fortis').'"/></div>';
        // email 
        $cms_fields['email'] = '<div class="comment-form-field comment-form-email col-4 col-mobile-12">'.
                    '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                    '" size="30" placeholder="'.esc_attr__('Email', 'fortis').'"/></div>';
        // website
        $cms_fields['website'] = '<div class="comment-form-field comment-form-website col-4 col-mobile-12">'.
                    '<input id="website" name="website" type="text" value="" size="30" placeholder="'.esc_attr__('Website', 'fortis').'"/></div>';
        // cookies (remove default cookies field)
        //$cms_fields['cookies'] = '';
        //Close 
        //$cms_fields['close'] = '</div>';

        $fields =  apply_filters( 'comment_form_default_fields', $cms_fields);
        $cms_comment_fields['fields'] = $fields;

        // Comment Field Message
        $cms_comment_fields['comment_field'] = '';
        if(is_user_logged_in()){
            $cms_comment_fields['comment_field'] .= fortis_comment_rating_fields([
                'echo' => false,
                'class' => 'col-12'
            ]);
            $cms_comment_fields['comment_field'] .= fortis_woocommerce_comment_rating_fields([
                'echo' => false,
                'class' => 'col-12'
            ]);
        }
        $cms_comment_fields['comment_field'] .= '<div class="comment-form-field comment-form-comment col-12"><textarea id="comment-msg" name="comment" cols="45" rows="8" placeholder="'.esc_attr__('Comment', 'fortis').'" aria-required="true">' .'</textarea></div>';
        // Close
        $cms_comment_fields['comment_field'] .= '</div>';

        // Note
        //$cms_comment_fields['comment_field'] .= '<div class="cmt-note pt-15">'.__('Please note, comments must be approved before they are published', 'fortis').'</div>';

        // Cookies
        if ( has_action( 'set_comment_cookies', 'wp_set_comment_cookies' ) && get_option( 'show_comments_cookies_opt_in' ) ) {
            $consent = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';
     
            $cms_comment_fields['comment_field'] .= sprintf(
                '<p class="comment-form-cookies-consent">%s %s</p>',
                sprintf(
                    '<input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"%s />',
                    $consent
                ),
                sprintf(
                    '<label for="wp-comment-cookies-consent">%s</label>',
                    __( 'Save my name, email, and website in this browser for the next time I comment.','fortis' )
                )
            );
        }
        return $cms_comment_fields;
    }
}
// function for inline style
// make some configs
if (!function_exists('fortis_configs')) {
    function fortis_configs($value)
    {
        $body_font    = apply_filters('fortis_body_font','Roboto');
        $body_color   = apply_filters('fortis_body_color','#9b9b9b');

        $heading_font    = apply_filters('fortis_heading_font', 'Prompt');
        $heading_color   = apply_filters('fortis_heading_color', [
            'regular' => '#002e6d', 
            'darken'  => '#001c41', 
            'lighten' => '#004e6d'
        ]);

        $btn_font     = apply_filters('fortis_btn_font', 'Roboto');

        $logo_w       = '110';
        $logo_h       = '29';
        $logo_w_sm    = '55';
        $logo_h_sm    = '29';

        $primary_color   = apply_filters('fortis_primary_color', '#00c881');
        $secondary_color = apply_filters('fortis_secondary_color', '#1b1a1a');
        $link_color = ['regular' => 'var(--cms-secondary-color)', 'hover' => 'var(--cms-primary-color)', 'active' => 'var(--cms-primary-color)'];
        $meta_color = '#505458';
        $transparent_menu_color = ['regular' => '#ffffff', 'hover' => '#ffffff', 'active' => '#ffffff'];

        $header_height = '110';
        $header_width = '320';

        $configs = [
            // color
            'theme_colors' => [
                'primary' => [
                    'title' => esc_html__('Primary', 'fortis'),
                    'value' => fortis_get_opts('primary_color', $primary_color, 'color_custom')
                ],
                'secondary' => [
                    'title' => esc_html__('Secondary', 'fortis'),
                    'value' => fortis_get_opts('secondary_color', $secondary_color, 'color_custom')
                ]
            ],
            // link color
            'link_color' => [
                'regular' => fortis_get_opts('link_color', $link_color, 'color_custom')['regular'],
                'hover'   => fortis_get_opts('link_color', $link_color, 'color_custom')['hover'],
                'active'  => fortis_get_opts('link_color', $link_color, 'color_custom')['active'],
            ],
            // body typo
            'body' => [
                'bg'     => '#fff',
                'family' => fortis_get_opts('body_font_typo', ['font_family' => $body_font])['font_family'],
                'size'   => '17px',
                'weight' => substr(fortis_get_opts('body_font_typo', ['font_style' => '400normal'])['font_style'], 0, 3),
                'style'  => substr(fortis_get_opts('body_font_typo', ['font_style' => '400normal'])['font_style'], 3),
                'color'  => fortis_get_opts('body_color', $body_color),
                'line-height' => 1.66667,
            ],
            // Heading typo
            'heading' => [
                'family'        => fortis_get_opts('heading_font_typo', ['font_family' => $heading_font],'on')['font_family'],
                'weight'        => substr(fortis_get_opts('heading_font_typo', ['font_style' => '500normal'],'on')['font_style'], 0, 3),
                'style'         => substr(fortis_get_opts('heading_font_typo', ['font_style' => '500normal'],'on')['font_style'], 3),
                'color'         => fortis_get_opts('heading_color', $heading_color, 'color_custom')['regular'],
                'darken-color'  => fortis_get_opts('heading_color', $heading_color, 'color_custom')['darken'],
                'lighten-color' => fortis_get_opts('heading_color', $heading_color, 'color_custom')['lighten'],
                'line-height'   => fortis_get_opts('heading_font_typo', ['line_height' => '1.3'],'on')['line_height']
            ],
            // Meta
            'meta'  => [
                'color' => fortis_get_opts('meta_color', $meta_color)
            ],
            // Header 
            'header'    => [
                'height' => fortis_get_opts('header_height', ['height' => $header_height], 'header_custom')['height'].'px'
            ],
            // logo
            'logo'  => [
                'width'     => fortis_get_opts('logo_maxh',['width' => $logo_w, 'height' => $logo_h], 'header_custom')['width'],
                'height'    => fortis_get_opts('logo_maxh',['width' => $logo_w, 'height' => $logo_h], 'header_custom')['height'],
                'width-mobile'  => fortis_get_opts('logo_maxh_sm',['width' => $logo_w_sm, 'height' => $logo_h_sm],'header_custom')['width'],
                'height-mobile' => fortis_get_opts('logo_maxh_sm',['width' => $logo_w_sm, 'height' => $logo_h_sm],'header_custom')['height']
            ],
            // menu color
            'menu_color' => [
                'regular' => fortis_get_opts('main_menu_color', $link_color)['regular'],
                'hover'   => fortis_get_opts('main_menu_color', $link_color)['hover'],
                'active'  => fortis_get_opts('main_menu_color', $link_color)['active'],
            ],
            // transparent menu color
            'transparent_menu_color' => [
                'regular' => fortis_get_opts('transparent_menu_color', $transparent_menu_color)['regular'],
                'hover'   => fortis_get_opts('transparent_menu_color', $transparent_menu_color)['hover'],
                'active'  => fortis_get_opts('transparent_menu_color', $transparent_menu_color)['active'],
            ],
            // Page title
            'ptitle'  => [
                'color'      => '#fff',   
                'bg-image'   => 'url('.fortis_get_opts('page_title_bg', ['background-color' => '#f9f9f9', 'background-image' => ''], 'custom_ptitle')['background-image'].')',
                'bg-color'   => fortis_get_opts('page_title_bg', ['background-color' => '#f9f9f9', 'background-image' => ''], 'custom_ptitle')['background-color'],
                'bg-overlay' => fortis_get_opts('page_title_overlay', 'rgba(var(--cms-color-secondary-rgb), 0.25)', 'custom_ptitle')
            ]
        ];
        return $configs[$value];
    }
}
if (!function_exists('fortis_hex_to_rgb')) {
    function fortis_hex_to_rgb($color)
    {

        $default = '0,0,0';

        //Return default if no color provided
        if (empty($color))
            return $default;

        //Sanitize $color if "#" is provided 
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }

        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        //Convert hexadec to rgb
        $rgb = array_map('hexdec', $hex);

        $output = implode(",", $rgb);

        //Return rgb(a) color string
        return $output;
    }
}

if (!function_exists('fortis_inline_styles')) {
    function fortis_inline_styles()
    {
        ob_start();
        // CSS Variable
        $theme_colors           = array_merge(fortis_configs('theme_colors'), fortis_custom_colors());
        $body                   = fortis_configs('body');
        $heading                = fortis_configs('heading');
        $meta                   = fortis_configs('meta');
        $link_color             = fortis_configs('link_color');

        $header                 = fortis_configs('header');
        $logo                   = fortis_configs('logo');
        $menu_color             = fortis_configs('menu_color');
        $transparent_menu_color = fortis_configs('transparent_menu_color');
        $ptitle                 = fortis_configs('ptitle');
 
        echo ':root{';
        // color rgb
        foreach ($theme_colors as $color => $value) {
            printf('--cms-color-%1$s-rgb: %2$s;', str_replace('#', '', $color), fortis_hex_to_rgb($value['value']));
        }
        // color hex
        foreach ($theme_colors as $color => $value) {
            printf('--cms-color-%1$s: %2$s;', str_replace('#', '', $color), $value['value']);
        }
        // Body
        foreach ($body as $key => $value) {
            if($key === 'family') $value = '\''.$value.'\', sans-serif';
            printf('--cms-body-%1$s: %2$s;', $key, $value);
        }
        // Heading
        foreach ($heading as $key => $value) {
            if($key === 'family') $value = '\''.$value.'\', sans-serif';
            printf('--cms-heading-%1$s: %2$s;', $key, $value);
        }
        // meta
        foreach ($meta as $key => $value) {
            printf('--cms-meta-%1$s: %2$s;', $key, $value);
        }
        // link color
        foreach ($link_color as $color => $value) {
            printf('--cms-link-%1$s-color: %2$s;', $color, $value);
        }
        // Header
        foreach ($header as $key => $value) {
            printf('--cms-header-%1$s: %2$s;', $key, $value);
        }
        // Logo
        foreach ($logo as $key => $value) {
            printf('--cms-logo-%1$s: %2$s;', $key, $value.'px');
        }
        // Menu color
        foreach ($menu_color as $color => $value) {
            printf('--cms-menu-%1$s: %2$s;', $color, $value);
        }
        // Menu color rgb
        foreach ($menu_color as $color => $value) {
            printf('--cms-menu-%1$s-rgb: %2$s;', str_replace('#', '', $color), fortis_hex_to_rgb($value));
        }
        // Transparent Menu color
        foreach ($transparent_menu_color as $color => $value) {
            printf('--cms-menu-transparent-%1$s: %2$s;', $color, $value);
        }
        // Transparent Menu color rgb
        foreach ($transparent_menu_color as $color => $value) {
            printf('--cms-menu-transparent-%1$s-rgb: %2$s;', str_replace('#', '', $color), fortis_hex_to_rgb($value));
        }
        // Page title
        foreach ($ptitle as $key => $value) {
            printf('--cms-ptitle-%1$s: %2$s;', $key, $value);
        }
        echo '}';
        return ob_get_clean();
    }
}
// end function for inline style

/**
 * Render Attributes
 * 
 * */
if(!function_exists('fortis_render_attrs')){
    function fortis_render_attrs($attrs = []){
        if(!is_array($attrs) || empty($attrs)) return;
        $atts = [];
        foreach ($attrs as $key => $attr) {
            $atts[] = $key.'="'.implode(' ', array_filter((array)$attr)).'"';
        }
        echo implode(' ', array_filter($atts));
    }
}

/**
 *
 * Get Theme Color
 *
 * @return array
 */
function fortis_theme_colors(){
    $_theme_color = fortis_configs('theme_colors');
    $theme_color = [];
    foreach ($_theme_color as $key => $color) {
        $key = str_replace('#', '', $key);
        if(is_array($color['value'])){
            foreach ($color['value'] as $color_key => $color_value) {
                $theme_color[$color_key] = $color_value;
            }
        } else {
            $theme_color[$key] = $color['value'];
        }
    }
    return $theme_color;
}

/**
 *
 * Theme Custom Color
 *
 * @return array
 */
function fortis_custom_colors(){
    $custom_color = fortis_get_opts('custom_color', []);
    $fortis_custom_colors = [];
    foreach ($custom_color as $color) {
        $_custom_color = explode('|', $color);
        $fortis_custom_colors[$_custom_color[1]] = [
            'title' => $_custom_color[0]. ' ('.$_custom_color[1].')',
            'value' => $_custom_color[1]
        ];
    }
    return $fortis_custom_colors;
}

/**
 * Theme Options
 * 
 * **/
/**
 * Get Page List
 * @return array
 */
if (!function_exists('fortis_list_page')) {
    function fortis_list_page($default = [])
    {
        $page_list = array();
        if (!empty($default))
            $page_list[$default['value']] = $default['label'];
        $pages = get_pages(array('hierarchical' => 0, 'posts_per_page' => '-1'));
        foreach ($pages as $page) {
            $page_list[$page->ID] = $page->post_title;
        }
        return $page_list;
    }
}

/**
 * Get Post List
 * @return array
 */
if (!function_exists('fortis_list_post')) {
    function fortis_list_post($post_type = 'post', $default = false)
    {
        $post_list = array();
        if ($default) {
            $post_list['none'] = esc_html__('None', 'fortis');
            $post_list['-1'] = esc_html__('Default', 'fortis');
        }
        $posts = get_posts(array('post_type' => $post_type, 'posts_per_page' => '-1'));
        foreach ($posts as $post) {
            $post_list[$post->ID] = $post->post_title;
        }
        return $post_list;
    }
}

/**
 * Get theme option based on its id.
 *
 * @param string $opt_id Required. the option id.
 * @param mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 */
function fortis_get_opt($opt_id, $default = false){
    $opt_name = fortis_get_opt_name();
    if (empty($opt_name)) {
        return $default;
    }
    global ${$opt_name};
    if (!isset(${$opt_name}) || !isset(${$opt_name}[$opt_id])) {
        $options = get_option($opt_name);
    } else {
        $options = ${$opt_name};
    }
    if (
        !isset($options) ||
        !isset($options[$opt_id]) ||
        $options[$opt_id] === ''
    ) {
        return $default;
    }
    if (is_array($options[$opt_id]) && is_array($default)) {
        foreach ($options[$opt_id] as $key => $value) {
            if (isset($default[$key]) && $value === '') {
                $options[$opt_id][$key] = $default[$key];
            }
        }
    }
    return $options[$opt_id];
}

/**
 * Get theme option based on its id.
 *
 * @param string $opt_id Required. the option id.
 * @param mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 */
function fortis_get_page_opt($opt_id, $default = false){
    $page_opt_name = fortis_get_page_opt_name();
    if (empty($page_opt_name)) {
        return $default;
    }
    $id = get_the_ID();
    if (!is_archive() && is_home()) {
        if (!is_front_page()) {
            $page_for_posts = get_option('page_for_posts');
            $id = $page_for_posts;
        }
    }

    // Get page option for Shop Page
    if (class_exists('WooCommerce') && is_shop()) {
        $id = get_option('woocommerce_shop_page_id');
    }

    return $options = !empty($id)
        ? get_post_meta(intval($id), $opt_id, true)
        : $default;
}

/**
 *
 * Get post format values.
 *
 * @param $post_format_key
 * @param bool $default
 *
 * @return bool|mixed
 */
function fortis_get_post_format_value( $id = null, $post_format_key = '', $default = '' ) {
    global $post;
    if ( $id === null ) {
        $id = $post->ID;
    }

    return $value = ( ! empty( $id ) && '' !== get_post_meta( $id, $post_format_key, true ) ) ? get_post_meta( $id, $post_format_key, true ) : $default;
}

/**
 * Get option based on its id.
 * get option of theme and page
 *
 * @param  string $opt_id Required. the option id.
 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 * @return mixed
 */
function fortis_get_opts($opt_id, $default = false, $dependency = ''){
    $theme_opt = fortis_get_opt($opt_id, $default);
    $_dependency = fortis_get_page_opt($dependency);
    if($dependency === 'on' || $_dependency === 'on'){
        $page_opt = fortis_get_page_opt($opt_id, $theme_opt);
        if ($page_opt !== null && $page_opt !== '' && $page_opt !== '-1') {
            if (is_array($page_opt) && is_array($theme_opt)) {
                foreach ($page_opt as $key => $value) {
                    foreach ($theme_opt as $key => $value) {
                        if (empty($page_opt[$key]) || $page_opt[$key] === 'px') {
                            $page_opt[$key] = $theme_opt[$key];
                        }
                    }
                }
            }
            $theme_opt = $page_opt;
        }
    }
    return $theme_opt;
}

/**
 * Get opt_name for options instance args and for
 * getting option value.
 *
 * @return string
 */
function fortis_get_opt_name_default(){
    return apply_filters('fortis_opt_name', 'cms_theme_options');
}
function fortis_get_opt_name(){
    if (isset($_POST['opt_name']) && !empty($_POST['opt_name'])) {
        return $_POST['opt_name'];
    }
    $opt_name = fortis_get_opt_name_default();
    if (defined('ICL_LANGUAGE_CODE')) {
        if (ICL_LANGUAGE_CODE != 'all' && !empty(ICL_LANGUAGE_CODE)) {
            $opt_name = $opt_name . '_' . ICL_LANGUAGE_CODE;
        }
    }

    return $opt_name;
}

/**
 * Get opt_name for options instance args and for
 * getting option value.
 *
 * @return string
 */
function fortis_get_page_opt_name(){
    return apply_filters('fortis_page_opt_name', 'cms_page_options');
}

/**
 * Get opt_name for options instance args and for
 * getting option value.
 *
 * @return string
 */
function fortis_get_post_opt_name(){
    return apply_filters('fortis_post_opt_name', 'fortis_post_options');
}
/*====== End Theme Option ==========*/
/**
 * Elementor
 * All function for Elementor
 * 
 * **/
/**
 * Theme Color for Elementor
 * */
if(!function_exists('fortis_elementor_theme_color_opts')){
    function fortis_elementor_theme_color_opts($args = []){
        $args = wp_parse_args($args, [
            'custom' => true
        ]);
        $theme_colors = wp_parse_args(fortis_custom_colors(), fortis_configs('theme_colors'));
        $option = ['' => esc_html('Default', 'fortis')];
        foreach ($theme_colors as $key => $color) {
            $key = str_replace('#', '', $key);
            if(is_array($color['value'])){
                foreach ($color['value'] as $color_key => $color_value) {
                    $option[$color_key] = str_replace(['#', '-', '_'], ' ', $color_key).' ('.$color_value.')';
                }
            } else {
                $option[$key] = $color['title'];
            }
        }
        if($args['custom']) $option['custom'] = esc_html('Custom', 'fortis');
        return $option;
    }
}
if (!function_exists('fortis_elementor_theme_color_opts')) {
    function fortis_elementor_theme_color_opts($args = [])
    {
        $args = wp_parse_args($args, [
            'custom' => true
        ]);
        $theme_colors = wp_parse_args(fortis_custom_colors(), fortis_configs('theme_colors'));
        $option = ['' => esc_html('Default', 'fortis')];
        foreach ($theme_colors as $key => $color) {
            $key = str_replace('#', '', $key);
            $option[$key] = $color['title'];
        }
        if ($args['custom']) $option['custom'] = esc_html('Custom', 'fortis');
        return $option;
    }
}
/**
 * Ajax Pagination
 * Use in Element Post Grid/Blog
 * 
 * */
if (!function_exists('fortis_ajax_paginate_links')) {
    function fortis_ajax_paginate_links($link)
    {
        $parts = parse_url($link);
        parse_str($parts['query'], $query);
        if (isset($query['page']) && !empty($query['page'])) {
            return '#' . $query['page'];
        } else {
            return '#1';
        }
    }
}