<?php 
/**
 * Change Theme Options
 *  
 * */
// change color
add_filter('fortis_primary_color', function(){ return '#c10230';} );
add_filter('fortis_secondary_color', function(){ return '#002e6d';} );
add_filter('fortis_body_color', function(){ return '#64696e';} );
add_filter('fortis_heading_color', function(){ return ['regular' => '#002e6d','darken'  => '#001c41','lighten' => '#19427b'];} );

/**
 * Create the rating interface.
 * 
 * 
*/
if(!function_exists('fortis_comment_rating_fields')){
    //add_action( 'comment_form_logged_in_after', 'fortis_comment_rating_fields' );
    //add_action( 'comment_form_after_fields', 'fortis_comment_rating_fields' );
    function fortis_comment_rating_fields ($args =[]) {
        $args = wp_parse_args($args, [
            'echo'  => true,
            'class' => ''
        ]);
        $show_rating = fortis_get_opt('post_comments_rating_on','0');
        $rating = '';
        if('1' === $show_rating && is_singular('post')){
            $rating .= '<div class="cms-comment-form-rating cms-comment-form-fields-wrap d-flex gap '.esc_attr($args['class']).'">';
                $rating .= '<div  class="comment-form-field flex-auto">'. esc_html__('Your Rating','fortis').'<span class="required">*</span></div>';
                $rating .= '<div class="comment-form-field comments-rating flex-basic">';
                    $rating .= '<span class="rating-container stars">';
                        for ( $i = 5; $i >= 1; $i-- ) :
                            $rating .= '<input type="radio" id="rating-'.$i.'" class="star-'.$i.'" name="rating" value="'.$i.'" />
                                        <label for="rating-'.$i.'"><span class="d-none">'.$i.'</span></label>';
                        endfor;
                        $rating .= '<input type="radio" id="rating-0" class="star-cb-clear star-0" name="rating" value="0" /><label for="rating-0"><span class="d-none">0</span></label>';
                    $rating .= '</span>
                </div>
            </div>';
        }
        if($args['echo']){
            printf('%s', $rating);
        } else {
            return $rating;
        }
    }
}
if(!function_exists('fortis_woocommerce_comment_rating_fields')){
    function fortis_woocommerce_comment_rating_fields($args =[]){
        $args = wp_parse_args($args, [
            'echo' => true,
            'class' => ''
        ]);
        $rating = '';
        if(!function_exists('wc_review_ratings_enabled')) return;
        if (wc_review_ratings_enabled() && is_singular('product') ) {
            $rating .= '<div class="cms-comment-form-rating cms-comment-form-fields-wrap d-flex gap align-items-center '.esc_attr($args['class']).'">';
                $rating .= '<div class="comment-form-field flex-auto cms-heading font-700">' . esc_html__( 'Your rating', 'fortis' ) . ( wc_review_ratings_required() ? '&nbsp;<span class="required">*</span>' : '' ) . '</div>';
                $rating .= '<div class="comment-form-field comments-rating flex-basic">';
                    $rating .= '<select name="rating" id="rating" required>
                        <option value="">' . esc_html__( 'Rate&hellip;', 'fortis' ) . '</option>
                        <option value="5">' . esc_html__( 'Perfect', 'fortis' ) . '</option>
                        <option value="4">' . esc_html__( 'Good', 'fortis' ) . '</option>
                        <option value="3">' . esc_html__( 'Average', 'fortis' ) . '</option>
                        <option value="2">' . esc_html__( 'Not that bad', 'fortis' ) . '</option>
                        <option value="1">' . esc_html__( 'Very poor', 'fortis' ) . '</option>
                    </select>';
                $rating .= '</div>';
            $rating .= '</div>';
        }
        if($args['echo']){
            printf('%s', $rating);
        } else {
            return $rating;
        }
    }
}
// add rating to after comment form fields
if(!function_exists('fortis_comment_rating_default_fields')){
    //add_filter('comment_form_default_fields', 'fortis_comment_rating_default_fields' );
    function fortis_comment_rating_default_fields ($fields) {
        $fields_rating = [];
        ob_start();
            fortis_comment_rating_fields();
            fortis_woocommerce_comment_rating_fields();
        $fields_rating['rating'] = ob_get_clean();
        $fields = array_merge($fields_rating, $fields);
        return $fields;
    }
}

//Save the new meta added by theme  submitted by the user.
if(!function_exists('fortis_comment_rating_save_comment_meta')){
    add_action( 'comment_post', 'fortis_comment_rating_save_comment_meta' );
    function fortis_comment_rating_save_comment_meta( $comment_id ) {
        $rating = $address = '';
        // rating
        if ( ( isset( $_POST['rating'] ) ) && ( '' !== $_POST['rating'] ) )
        $rating = intval( $_POST['rating'] );
        // address
        if ( ( isset( $_POST['address'] ) ) && ( '' !== $_POST['address'] ) )
        $address = $_POST['address'];
        add_comment_meta( $comment_id, 'rating', $rating );
        add_comment_meta( $comment_id, 'address', $address );
    }
}
// Make the rating required.
if(!function_exists('fortis_comment_rating_require_rating')){
    add_filter( 'preprocess_comment', 'fortis_comment_rating_require_rating' );
    function fortis_comment_rating_require_rating( $commentdata ) {
        $show_rating = fortis_get_opt('post_comments_rating_on','0');
        if('1' !== $show_rating) return $commentdata;

        if ( ! is_admin() && ( ! isset( $_POST['rating'] ) || 0 === intval( $_POST['rating'] ) ) )
        wp_die( esc_html__( 'Error: You did not add a rating. Hit the Back button on your Web browser and resubmit your comment with a rating.','fortis' ) );
        return $commentdata;
    }
}

//Display the rating on a submitted comment.
if(!function_exists('fortis_comment_rating_display_rating')){
    //add_filter( 'comment_text', 'fortis_comment_rating_display_rating');
    function fortis_comment_rating_display_rating( $comment_text ){
        if ( $rating = get_comment_meta( get_comment_ID(), 'rating', true ) ) {
            $stars = '<div class="stars">';
            for ( $i = 1; $i <= $rating; $i++ ) {
                $stars .= '<span class="rating-icon cms-rating-icon-filled"></span>';
            }
            $stars .= '</div>';
            $comment_text = $comment_text . $stars;
            return $comment_text;
        } else {
            return $comment_text;
        }
    }
}

//Get the average rating of a post.
if(!function_exists('fortis_comment_rating_get_average_ratings')){
    function fortis_comment_rating_get_average_ratings( $id ) {
        $comments = get_approved_comments( $id );
        if ( $comments ) {
            $i = 0;
            $total = 0;
            foreach( $comments as $comment ){
                $rate = get_comment_meta( $comment->comment_ID, 'rating', true );
                if( isset( $rate ) && '' !== $rate ) {
                    $i++;
                    $total += $rate;
                }
            }

            if ( 0 === $i ) {
                return false;
            } else {
                return round( $total / $i, 1 );
            }
        } else {
            return false;
        }
    }
}
// Display the star average rating only
if(!function_exists('fortis_comment_rating_display_average')){
    function fortis_comment_rating_display_average($args = []) {

        global $post;

        if ( false === fortis_comment_rating_get_average_ratings( $post->ID ) ) {
            return false;
        }
        $args = wp_parse_args($args, [
            'width' => 20,
            'class' => ''
        ]);
        $stars   = '';
        $average = fortis_comment_rating_get_average_ratings( $post->ID );

        for ( $i = 1; $i <= $average + 1; $i++ ) {
            
            $width = intval( $i - $average > 0 ? $args['width'] - ( ( $i - $average ) * $args['width'] ) : $args['width'] );

            if ( 0 === $width ) {
                continue;
            }
            $stars .= '<span style="overflow:hidden; width:' . $width . 'px" class="rating-icon cms-rating-icon-filled"></span>';

            if ( $i - $average > 0 ) {
                $stars .= '<span style="overflow:hidden; position:relative; left:-' . ($width - 1) .'px;" class="cms-rating-icon cms-rating-icon-empty"></span>';
            }
        }
        $classes = ['cms-average-rating cms-average-rating-star', $args['class']];
        $custom_content  = '<div class="'.implode(' ', $classes).'">' . $stars .'</div>';
        return $custom_content;
    }
}

//Display the average rating above the content.
if(!function_exists('fortis_comment_rating_display_average_rating')){
    //add_filter( 'the_content', 'fortis_comment_rating_display_average_rating' );
    function fortis_comment_rating_display_average_rating( $content ) {

        global $post;

        if ( false === fortis_comment_rating_get_average_ratings( $post->ID ) ) {
            return $content;
        }
        
        $stars   = '';
        $average = fortis_comment_rating_get_average_ratings( $post->ID );

        for ( $i = 1; $i <= $average + 1; $i++ ) {
            
            $width = intval( $i - $average > 0 ? 20 - ( ( $i - $average ) * 20 ) : 20 );

            if ( 0 === $width ) {
                continue;
            }

            $stars .= '<span style="overflow:hidden; width:' . $width . 'px" class="rating-icon cms-rating-icon-filled"></span>';

            if ( $i - $average > 0 ) {
                $stars .= '<span style="overflow:hidden; position:relative; left:-' . $width .'px;" class="rating-icon cms-rating-icon-empty"></span>';
            }
        }
        
        $custom_content  = '<div class="average-rating">This post\'s average rating is: ' . $average .' ' . $stars .'</div>';
        $custom_content .= $content;
        return $custom_content;
    }
}
if(!function_exists('fortis_comment_rating_display_feedback')){
    function fortis_comment_rating_display_feedback($args=[]){
        $args = wp_parse_args($args,[
            'id'        => get_the_ID(),
            'mode'      => 'good', //bad
            'good_text' => esc_html__('positive feedback', 'fortis'),
            'bad_text'  => esc_html__('negative feedback', 'fortis'),
            'good_icon' => 'icofont-simple-smile',
            'bad_icon'  => 'icofont-sad'
        ]);
        $comments = get_approved_comments( $args['id'] );
        if ( $comments ) {
            $i = 0;
            $total = 0;
            $good_rate = $bad_rate = 0;
            foreach( $comments as $comment ){
                $rate = get_comment_meta( $comment->comment_ID, 'rating', true );
                if( isset( $rate ) && '' !== $rate ) {
                    $i++;
                    $total += $rate;
                }
                if(isset($rate) && $rate > 3){
                    $good_rate ++;
                }
                if(isset($rate) && $rate <= 3){
                    $bad_rate ++;
                }
            }

            if ( 0 === $i ) {
                return false;
            } else {
                //return  $total .' good:'.$good_rate.' bad:'.$bad_rate ;
                if($args['mode'] == 'good'){
                    return '<span class="cms-rating-good text-accent text-17 '.$args['good_icon'].'"></span> <span class="cms-rating-percent text-accent font-700">'.number_format_i18n( $good_rate*100 / $i, 2 ).'%</span> '.$args['good_text'];
                } else {
                    return '<span class="cms-rating-bad text-accent text-17 '.$args['bad_icon'].'"></span> <span class="cms-rating-percent text-accent font-700">'.number_format_i18n( $bad_rate*100 / $i, 2 ).'%</span> '.$args['bad_text'];
                }
            }
        } else {
            return false;
        }
    }
}
// Display the address on a submitted comment.
if(!function_exists('fortis_comment_display_address')){
    //add_filter( 'comment_text', 'fortis_comment_rating_display_rating');
    function fortis_comment_display_address(){
        $address =  get_comment_meta( get_comment_ID(), 'address', true ) ;
        if(empty($address)) return;
        ?>
            <div class="cms-comment-address"><?php echo esc_html($address); ?></div>
        <?php
    }
}


/**
 * Update Wordpress Configs
 * Change thumbnail size
 * 
 * */
add_action('after_switch_theme', 'fortis_thumbnail_size');
if(!function_exists('fortis_thumbnail_size')){
    function fortis_thumbnail_size(){
        /* Change default image thumbnail sizes in wordpress */
        $thumbnail_size = array(
            'large_size_w'        => '840',
            'large_size_h'        => '562',
            'large_crop'          => 1, 
            'medium_large_size_w' => '570',
            'medium_large_size_h' => '380',
            'medium_large_crop'   => 1, 
            'medium_size_w'       => '400',
            'medium_size_h'       => '267',
            'medium_crop'         => 1, 
            'thumbnail_size_w'    => '80',
            'thumbnail_size_h'    => '80',
            'thumbnail_crop'      => 1
        );
        foreach ($thumbnail_size as $option => $value) {
            if (get_option($option, '') != $value)
                update_option($option, $value);
        }
    }
}

/**
 * Custom Elementor Row
 * Columns Presets
 * 
 * **/
if(!function_exists('fortis_custom_section_presets')){
    add_filter('etc-custom-section/custom-presets', 'fortis_custom_section_presets');
    function fortis_custom_section_presets(){
        return [
            2 => [
                [
                    'preset' => ['auto', 'basic']
                ],
                [
                    'preset' => ['basic', 'auto']
                ]
            ],
            3 => [
                [
                    'preset' => ['50', '50', '100']
                ],
                [
                    'preset' => ['100', '50', '50']
                ],
                [
                    'preset' => ['100', '33', '66']
                ],
                [
                    'preset' => ['50', '100', '50']
                ]
            ],
            4 => [
                [
                    'preset' => ['100', '33', '33', '33']
                ],
                [
                    'preset' => ['66', '100', '33', '66']
                ]
            ],
            5 => [
                [
                    'preset' => ['25', '25', '25', '25', '100']
                ],
                [
                    'preset' => ['66', '100', '33', '33', '33']
                ],
                [
                    'preset' => ['50', '100', '33', '33', '33']
                ],
                [
                    'preset' => ['100', '25', '25', '25', '25']
                ]
            ],
            6 => [
                [
                    'preset' => ['50', '100', '33', '33', '33', '50']
                ],
                [
                    'preset' => ['100', '25', '25', '25', '25', '100']
                ]
            ]
        ];
    }
}
// Add custom field to section
if(!function_exists('fortis_custom_section_params')){
    add_filter('etc-custom-section/custom-params', 'fortis_custom_section_params'); 
    function fortis_custom_section_params(){
        return array(
            'sections' => array(
                // add more
                array(
                    'name'     => 'cms_custom_layout',
                    'label'    => esc_html__( 'Fortis Custom Settings', 'fortis' ),
                    'tab'      => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array_merge(
                        array(
                            // make section full content with a space on start / end
                            array(
                                'name'         => 'full_content_with_space',
                                'label'        => esc_html__( 'Full Content with space from?', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-full-content-with-space-',
                                'options'      => array(
                                    'none'       => esc_html__( 'None', 'fortis' ),
                                    'start'      => esc_html__( 'Start', 'fortis' ),
                                    'end'        => esc_html__( 'End', 'fortis' ),
                                    'start-wide' => esc_html__( 'Start (Container Wide)', 'fortis' ),
                                    'end-wide'   => esc_html__( 'End (Container Wide)', 'fortis' ),
                                    'both-30'    => esc_html__( 'Container Fluid', 'fortis' ),
                                    'both-45'    => esc_html__( 'Container Fluid #2', 'fortis' ),
                                ),
                                'default'      => 'none',
                                'condition' => [
                                    'layout' => 'full_width'
                                ]
                            ),
                            array(
                                'name'         => 'horiz_align',
                                'label'        => esc_html__( 'Horizontal Align', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-esection-horiz-align-',
                                'options'      => array(
                                    ''        => esc_html__('Default', 'fortis' ),
                                    'start'   => esc_html__('Start','fortis'),
                                    'end'     => esc_html__('End','fortis'),
                                    'center'  => esc_html__('Center', 'fortis' ),
                                    'between' => esc_html__('Between', 'fortis' )
                                ),
                                'default' => '',
                                'separator' => 'before'
                            ),
                            array(
                                'name'         => 'boxed_bg',
                                'label'        => esc_html__( 'Boxed Background?', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-boxed-bg-',
                                'options'      => array(
                                    ''           => esc_html__( 'None', 'fortis' ),
                                    'both'       => esc_html__('Both','fortis'),
                                    'both-large' => esc_html__('Both Large','fortis'),
                                    'both-wide'  => esc_html__('Both Wide','fortis'),
                                    'both-wide2'  => esc_html__('Both Wide #2','fortis'),
                                    'start'      => esc_html__( 'Start', 'fortis' ),
                                    'end'        => esc_html__( 'End', 'fortis' ),
                                    'start-wide' => esc_html__( 'Start Wide', 'fortis' ),
                                    'end-wide'   => esc_html__( 'End Wide', 'fortis' ),
                                ),
                                'default' => '',
                                'separator' => 'before'
                            ),
                            array(
                                'name'         => 'show_edge',
                                'label'        => esc_html__( 'Show Edge on?', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-edge-',
                                'options'      => array(
                                    ''          => esc_html__( 'None', 'fortis' ),
                                    'top-left'  => esc_html__( 'Top Left', 'fortis' ),
                                    'top-right' => esc_html__( 'Top Right', 'fortis' ),
                                    'bot-left'  => esc_html__( 'Bottom Left', 'fortis' ),
                                    'bot-right' => esc_html__( 'Bottom Right', 'fortis' ),
                                ),
                                'default' => '',
                                'separator' => 'before'
                            ),
                            array(
                                'name'         => 'edge_size',
                                'label'        => esc_html__( 'Edge size?', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-edge-size-',
                                'options'      => array(
                                    '50'  => esc_html__( 'Small', 'fortis' ),
                                    '100' => esc_html__( 'Medium', 'fortis' ),
                                    '150' => esc_html__( 'Large', 'fortis' )
                                ),
                                'default'   => '100',
                                'condition' => [
                                    'show_edge!' => ''
                                ]
                            ),
                            array(
                                'name'         => 'edge_color',
                                'label'        => esc_html__( 'Edge color?', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-edge-',
                                'options'      => array(
                                    'primary'   => esc_html__( 'Primary', 'fortis' ),
                                    'secondary' => esc_html__( 'Secondary', 'fortis' ),
                                    'white'     => esc_html__( 'White', 'fortis' )
                                ),
                                'default' => 'primary',
                                'condition' => [
                                    'show_edge!' => ''
                                ]
                            ),
                            array(
                                'name'         => 'show_gradient',
                                'label'        => esc_html__( 'Gradient Style', 'fortis' ),
                                'type'         => \Elementor\Controls_Manager::SELECT,
                                'prefix_class' => 'cms-gradient-',
                                'options'      => array(
                                    ''    => esc_html__( 'None', 'fortis' ),
                                    '1'   => esc_html__( 'Primary - Top to Bottom', 'fortis' ),
                                    '2'   => esc_html__( 'Secondary - Top to Bottom', 'fortis' ),
                                    '3'   => esc_html__( 'Primary - Bottom to Top', 'fortis' ),
                                    '4'   => esc_html__( 'Secondary - Bottom to Top', 'fortis' ),
                                    '5'   => esc_html__( 'Secondary - Bottom to Top #2', 'fortis' ),
                                    '6'   => esc_html__( 'Primary - Bottom to Top #2', 'fortis' ),
                                    '7'   => esc_html__( 'Gray - Bottom to Top', 'fortis' ),
                                    '7-2' => esc_html__( 'Gray - Top to Bottom', 'fortis' ),
                                    '8'   => esc_html__( 'Secondary - Bottom to Top #3', 'fortis' ),
                                    '9'   => esc_html__( 'Secondary - Bottom to Top #4', 'fortis' ),
                                    '11'  => esc_html__( 'Secondary - Bottom to Top #5', 'fortis' ),
                                ),
                                'default' => '',
                                'separator' => 'before'
                            )
                        )
                    )
                )
            )
        );
    }
}
// add html to before row settings
if(!function_exists('fortis_before_row_custom_html_setting')){
    add_filter('etc-custom-section/before-elementor-row-settings', 'fortis_before_row_custom_html_setting', 10 , 2);
    function fortis_before_row_custom_html_setting( $html, $settings){
        $html .= '<div class="cms-gradient-render"></div>';
        return $html;
    }
}
// Custom HTML Elementor ROW (Frontend)
if(!function_exists('fortis_before_row_custom_html_render')){
    add_filter('etc-custom-section/before-elementor-row-render', 'fortis_before_row_custom_html_render', 11 , 2);
    function fortis_before_row_custom_html_render( $html, $settings){
        // Overlay Gradient
        if(isset($settings['show_gradient']) && $settings['show_gradient'] != ''){
            $html .= '<div class="cms-gradient-render"></div>';
        }
        // Return
        return $html;
    }
}
/**
 * Custom Elementor Column
 * Add options horizontal element
 * 
 * **/
if(!function_exists('fortis_custom_column_params')){
    add_filter('etc-custom-column/custom-params', 'fortis_custom_column_params');
    function fortis_custom_column_params(){
        return array(
            'sections' => array(
                array(
                    'name'     => 'custom_section',
                    'label'    => esc_html__( 'Custom Settings', 'fortis' ),
                    'tab'      => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'element_display',
                            'label'   => esc_html__( 'Element Display Settings', 'fortis' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                ''           => __( 'Default', 'fortis' ),
                                'vert'   => __( 'Vertical', 'fortis' ),
                                'horiz' => __( 'Horizontal', 'fortis' ),
                            ),
                            //'control_type' => 'responsive',
                            'label_block'  => true, 
                            'default'      => '',
                            'prefix_class' => 'cms-column-'
                        ),
                        array(
                            'name' => 'element_display_gap',
                            'label'   => esc_html__( 'Element Gap', 'fortis' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                '10' => '10',
                                '20' => '20',
                                '30' => '30',
                                '40' => '40'
                            ),
                            'label_block'  => true, 
                            'default'      => '40',
                            'prefix_class' => 'gap-',
                            'condition'    => [
                                'element_display' => ['horiz']
                            ]
                        )
                    )
                )
            )
        );
    }
}
// Change html tag for Elementor image render
if(!function_exists('fortis_elementor_image_size_get_attachment_image_html')){
    add_filter('elementor/image_size/get_attachment_image_html','fortis_elementor_image_size_get_attachment_image_html', 10, 4);
    function fortis_elementor_image_size_get_attachment_image_html($html, $settings, $image_size_key, $image_key){

        if ( ! $image_key ) {
            $image_key = $image_size_key;
        }

        $image = $settings[ $image_key ];

        // Old version of image settings.
        if ( ! isset( $settings[ $image_size_key . '_size' ] ) ) {
            $settings[ $image_size_key . '_size' ] = 'custom';
        }

        $size = $settings[ $image_size_key . '_size' ];

        $image_class = [];
        $image_class[] = isset($settings['img_class']) ?$settings['img_class'] : '';
        $image_class[] = ! empty( $settings['hover_animation'] ) ? 'elementor-animation-' . $settings['hover_animation'] : '';
        $image_class = implode(' ', array_filter($image_class));

        $html = '';

        // If is the new version - with image size.
        $image_sizes = get_intermediate_image_sizes();

        $image_sizes[] = 'full';

        if ( ! empty( $image['id'] ) && ! wp_attachment_is_image( $image['id'] ) ) {
            $image['id'] = '';
        }
        $is_static_render_mode = \Elementor\Plugin::$instance->frontend->is_static_render_mode();
        // On static mode don't use WP responsive images.
        if ( ! empty( $image['id'] ) && in_array( $size, $image_sizes ) && ! $is_static_render_mode ) {
            $image_class .= " attachment-$size size-$size wp-image-{$image['id']}";
            $image_attr = [
                'class'  => trim( $image_class ),
                'width'  => get_option($size.'_size_w'),
                'height' => get_option($size.'_size_h')
            ];
            // if have max-height style
            if(isset($settings['cms_style']) && $settings['cms_style']){
                $image_attr['style'] = 'max-height:'.get_option($size.'_size_h').'px';
            }
            $html = wp_get_attachment_image( $image['id'], $size, false, $image_attr );
        } else {
            $custom_dimension = isset($settings[ $image_key . '_custom_dimension' ]) ? $settings[ $image_key . '_custom_dimension' ] : ['width' => get_option('full_size_w'), 'height' => get_option('full_size_h')];
            $settings[$image_key . '_custom_dimension'] = isset($settings[ $image_key . '_custom_dimension' ]) ? $settings[ $image_key . '_custom_dimension' ] : $custom_dimension;
            $image_src = \Elementor\Group_Control_Image_Size::get_attachment_image_src( $image['id'], $image_size_key, $settings );

            if ( ! $image_src && isset( $image['url'] ) ) {
                $image_src = $image['url'];
            }

            if ( ! empty( $image_src ) ) {
                $image_class_html = ! empty( $image_class ) ? ' class="' . $image_class . '"' : '';

                // if have max-height style
                $image_style = '';
                if(isset($settings['cms_style']) && $settings['cms_style']){
                    $image_style = ' style="max-height:'.$settings[$image_key . '_custom_dimension']['height'].'px;"';
                }

                $html = sprintf( '<img width="%s" height="%s" src="%s" title="%s" alt="%s"%s%s loading="lazy" />', 
                    $custom_dimension['width'],
                    $custom_dimension['height'],
                    esc_attr( $image_src ), 
                    \Elementor\Control_Media::get_image_title( $image ), 
                    \Elementor\Control_Media::get_image_alt( $image ), 
                    $image_class_html,
                    $image_style
                );
            }
        }

        return $html;
    }
}
// Elementor Image Render
if(!function_exists('fortis_elementor_image_render')){
    function fortis_elementor_image_render( $settings = [], $args = []){
        if(!class_exists('\Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $args = wp_parse_args($args, [
            'name'           => 'image',
            'image_size_key' => '',
            'img_class'      => '',
            'custom_size'    => ['width' => get_option('medium_size_w'), 'height' => get_option('medium_size_h')],
            'max_height'     => false,   
            'before'         => '',
            'after'          => ''
        ]);
        if(empty($args['image_size_key'])) $args['image_size_key'] = $args['name'];

        $settings['img_class'] = $args['img_class'];
        
        if(!isset($settings[$args['name'].'_custom_dimension'])){
            $settings[$args['name'].'_custom_dimension'] = $args['custom_size'];
        } else {
            $settings[$args['name'].'_custom_dimension']['width'] = !empty($settings[$args['name'].'_custom_dimension']['width']) ? $settings[$args['name'].'_custom_dimension']['width'] : $args['custom_size']['width'];
            
            $settings[$args['name'].'_custom_dimension']['height'] = !empty($settings[$args['name'].'_custom_dimension']['height']) ? $settings[$args['name'].'_custom_dimension']['height'] : $args['custom_size']['height'];
        }
        // set max height
        if($args['max_height']) $settings['cms_style'] = true;
        printf('%s', $args['before']);
        // Print image
        \Elementor\Group_Control_Image_Size::print_attachment_image_html( $settings, $args['image_size_key'], $args['name'] );
        printf('%s', $args['after']);
    }
}
// Elementor Button Video Render
if(!function_exists('fortis_elementor_button_video_render')){
    function fortis_elementor_button_video_render($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            'name'     => 'video_link',
            'layout'   => '1',
            'text'     => '',
            'icon'     => 'cmsi-play',   
            'class'    => '',
            'echo'     => true,
            'attrs'    => [],
            'loop'     => false,
            'loop_key' => ''
        ]);
        if(empty($settings[$args['name']])) return;

        $lightbox_id = 'cms-lightbox-'.$widget->get_setting('element_id');
        $video_url = $settings['video_link'];
        $embed_params = [
            'loop'           => '0',
            'controls'       => '1',
            'mute'           => '0',
            'rel'            => '0',
            'modestbranding' => '0'
        ];
        $embed_options = [];
        $lightbox_options = [
            'type'         => 'video',
            'videoType'    => 'youtube',
            'url'          => \Elementor\Embed::get_embed_url( $video_url, $embed_params, $embed_options ),
            'modalOptions' => [
                'id'                       => $lightbox_id,
                'entranceAnimation'        => '',
                'entranceAnimation_tablet' => '',
                'entranceAnimation_mobile' => '',
                'videoAspectRatio'         => 169
            ]
        ];
        switch ($args['layout']) {
            case '2':
                $layout_class = 'btn btn-lg btn-hover-white';
                break;
            
            default:
                $layout_class = '';
                break;
        }
        if(!$args['loop']){
            $video_key = 'video-attrs';
            $widget->add_render_attribute($video_key, [
                'class'                        => implode(' ', array_filter(['cms-btn-video', 'layout-'.$args['layout'], $layout_class, $args['class']])),
                'data-elementor-open-lightbox' => 'yes',
                'data-elementor-lightbox'      => wp_json_encode( $lightbox_options )
            ]);
            $widget->add_render_attribute($video_key, $args['attrs']);
        } else {
            $video_key = $widget->get_repeater_setting_key( 'video_key', 'cms_video', $args['loop_key'] );
            $widget->add_render_attribute($video_key, [
                'class'                        => implode(' ', array_filter(['cms-btn-video', 'layout-'.$args['layout'], $layout_class, $args['class']])),
                'data-elementor-open-lightbox' => 'yes',
                'data-elementor-lightbox'      => wp_json_encode( $lightbox_options )
            ]);
            $widget->add_render_attribute($video_key, $args['attrs']);
        }
        ob_start();
        ?>
            <div <?php etc_print_html($widget->get_render_attribute_string($video_key)); ?>>
                <i class="<?php echo implode(' ', array_filter(['cms-icon','cms-transition', 'rtl-flip', $args['icon']])) ?>"></i>
                <span class="cms-text empty-none"><?php etc_print_html($args['text']) ?></span>
            </div>
        <?php
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}

// Elementor Post Image Render
if(!function_exists('fortis_elementor_post_thumbnail_render')){
    function fortis_elementor_post_thumbnail_render( $settings = [], $args = []){
        if(!class_exists('\Elementor\Plugin') || !class_exists('Elementor_Theme_Core')) return;
        $args = wp_parse_args($args, [
            'post_id'        => '',
            'image_size_key' => 'thumbnail',
            'max_height'     => false,   
            'img_class'      => '',
            'custom_size'    => ['width' => get_option('medium_size_w'), 'height' => get_option('medium_size_h')],
            'before'         => '',
            'after'          => '',
        ]);

        $settings['img_class'] = $args['img_class'];
        $settings['max_height'] = $args['max_height'];
        // set max height
        if($args['max_height']) $settings['cms_style'] = true;
        // post thumbnail or placeholder image
        $settings[$args['image_size_key']] = [
            'id'  => get_post_thumbnail_id($args['post_id']),
            'url' => !empty(get_the_post_thumbnail_url($args['post_id'])) ? get_the_post_thumbnail_url($args['post_id']) : \Elementor\Utils::get_placeholder_image_src()
        ];
        $settings[$args['image_size_key'].'_size'] = isset($settings[$args['image_size_key'].'_size']) ? $settings[$args['image_size_key'].'_size'] : 'custom';

        if(!isset($settings[$args['image_size_key'].'_custom_dimension'])){
            $settings[$args['image_size_key'].'_custom_dimension'] = $args['custom_size'];
        } else {
            $settings[$args['image_size_key'].'_custom_dimension']['width'] = !empty($settings[$args['image_size_key'].'_custom_dimension']['width']) ? $settings[$args['image_size_key'].'_custom_dimension']['width'] : $args['custom_size']['width'];
            
            $settings[$args['image_size_key'].'_custom_dimension']['height'] = !empty($settings[$args['image_size_key'].'_custom_dimension']['height']) ? $settings[$args['image_size_key'].'_custom_dimension']['height'] : $args['custom_size']['height'];
        }
        printf('%s', $args['before']);
        // Print image
        \Elementor\Group_Control_Image_Size::print_attachment_image_html( $settings, $args['image_size_key'], $args['image_size_key'] );
        printf('%s', $args['after']);
    }
}
// Elementor Build Post Layout 
if(!function_exists('fortis_get_post_grid')){
    function fortis_get_post_grid($settings = [], $posts = [], $posts_data = [], $args = []){
        if(empty($posts) || !is_array($posts) || empty($posts_data) || !is_array($posts_data)){
            return false;
        }
        $posts_data['tax'] = isset($posts_data['tax']) ? $posts_data['tax'] : [];
        extract($posts_data);
        $args = wp_parse_args($args, [
            'item_class' => ''
        ]); 

        // Start build post item 
        $count = 0;
        foreach ($posts as $post):
            $count ++;
            $filter_class = etc_get_term_of_post_to_class($post->ID, array_unique($tax));
            ?>
            <div class="<?php echo implode(' ', array_filter(['cms-item relative', $args['item_class'], $filter_class, 'item-'.$count])); ?>">
                <?php switch ($settings['layout']) {
                    case '27':
                ?>
                    <div class="cms-shadow-4 cms-radius-8 overflow-hidden">
                    <?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'before'      => '<div class="overflow-hidden">',
                            'after'       => '</div>'
                        ]);
                    ?>
                        <div class="cms--content bg-white p-40 p-lr-smobile-20">
                            <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4 text-15 mb-20"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-secondary btn-hover-primary">
                                <?php etc_print_html($settings['readmore_text']); ?>
                                <i class="cmsi-arrow-right rtl-flip text-10"></i>
                            </a>
                        </div>
                    </div>
                    <?php
                        break;
                    case '26':
                ?>
                <div class="cms-shadow-4 cms-radius-8"><?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'img-cover cms-radius-8',
                            'max_height'  => true,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'before'      => '<div class="overflow-hidden cms-radius-8">',
                            'after'       => '</div>'
                        ]);
                    ?>
                    <div class="cms-content relative z-top">
                        <?php 
                            // post category
                            the_terms($post->ID, 'category', '<div class="cms-post-meta bg-primary cms-radius-6">', ', ','</div>');
                        ?>
                        <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <div class="cms-meta d-flex justify-content-between align-items-center">
                            <div class="meta">
                                <div class="author"><?php fortis_the_author_posts_link([
                                    'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                    'link_class' => 'text-primary text-hover-secondary',
                                    'object'     => $post   
                                ]); ?></div>
                                <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                            </div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                <i class="cmsi-arrow-right rtl-flip"></i>
                                <?php etc_print_html($settings['readmore_text']); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php
                    break;
                    case '25':
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'cms-radius-8 img-cover',
                            'max_height'  => true,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'before'      => '<div class="cms-overlay overflow-hidden cms-radius-8">',
                            'after'       => '</div>'
                        ]);
                ?>
                    <div class="cms-content relative z-top swiper-nav-vert">
                        <div class="cms--content bg-white cms-shadow-3 cms-radius-8">
                            <?php 
                                // post taxonomy
                                the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post--meta">', ', ','</div>');
                            ?>
                            <div class="cms-heading text-line-2 text-21 mb-n5"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></div>
                        </div>
                    </div>
                <?php
                    break;
                    case '24':
                ?>
                    <div class="cms-shadow-4 cms-radius-8">
                    <?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'img-cover cms-radius-8',
                            'max_height'  => true,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'before'      => '<div class="overflow-hidden">',
                            'after'       => '</div>'
                        ]);
                    ?>
                        <div class="cms--content bg-white p-40 p-lr-smobile-20">
                            <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4 text-15 mb-20"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn">
                                <?php etc_print_html($settings['readmore_text']); ?>
                                <i class="cmsi-arrow-right rtl-flip text-10"></i>
                            </a>
                        </div>
                    </div>
                    <?php
                        break;
                    case '23':
                    // post category
                    ob_start();
                        the_terms($post->ID, 'category', '<div class="cms-post-meta bg-primary absolute top-left-60">', ', ','</div>');
                    $post_meta = ob_get_clean();
                    // post image
                    fortis_elementor_post_thumbnail_render($settings, [
                        'post_id'     => $post->ID,
                        'img_class'   => 'w-100',
                        'max_height'  => true,  
                        'custom_size' => $posts_data['thumbnail_custom_dimension'],
                        'after'       => $post_meta,
                        'before'      => '<div class="overflow-hidden">',
                        'after'       => '</div>' 
                    ]);
                ?>
                <div class="cms-content">
                    <div class="cms--content bg-white cms-shadow-4">
                        <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <div class="cms-meta d-flex justify-content-between align-items-center">
                            <div class="meta">
                                <div class="author"><?php fortis_the_author_posts_link([
                                    'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                    'link_class' => 'text-primary text-hover-secondary',
                                    'object'     => $post   
                                ]); ?></div>
                                <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                            </div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                <i class="cmsi-arrow-right rtl-flip"></i>
                                <?php etc_print_html($settings['readmore_text']); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php
                    break;
                    case '22':
                        ob_start();
                    ?>
                        <div class="cms-contents relative z-top text-white d-flex align-items-end">
                            <div class="cms--contents text-15">
                                <?php fortis_post_icon_render([
                                    'id'         => $post->ID,
                                    'class'      => 'pb-35',
                                    'icon_color' => 'white'
                                ]); ?>
                                <h4 class="cms-heading text-21 text-white"><a class="text-white text-hover-secondary" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                                <div class="cms-excerpt text-line-3"><?php 
                                    echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                ?></div>
                            </div>
                        </div>
                    <?php
                        $content = ob_get_clean();
                    ?>
                        <div class="cms--item cms-shadow-3 relative cms-gradient-5">
                        <?php 
                            // post image
                            fortis_elementor_post_thumbnail_render($settings, [
                                'post_id'     => $post->ID,
                                'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                'img_class'   => 'cms-overlay img-cover',
                                'max_height'  => true,
                                'before'      => '<div class="relative overflow-hidden">',
                                'after'       => '<div class="cms-gradient-render z-top"></div>'.$content.'</div>'     
                            ]);
                        ?>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link justify-content-between p-tb-30 p-lr-40 w-100">
                                <?php etc_print_html($settings['readmore_text']); ?>
                                <i class="cmsi-arrow-circle-right text-32 rtl-flip"></i>
                            </a>
                        </div>
                        <?php
                        break;
                    case '21':
                    // post image
                    fortis_elementor_post_thumbnail_render($settings, [
                        'post_id'     => $post->ID,
                        'img_class'   => 'cms-radius-4 img-cover',
                        'max_height'  => true,
                        'custom_size' => $posts_data['thumbnail_custom_dimension'],
                        'before'      => '<div class="overflow-hidden">',
                        'after'       => '</div>'
                    ]);
                ?>
                <div class="cms-content">
                    <?php 
                        // post category
                        the_terms($post->ID, 'category', '<div class="cms-post-meta bg-primary cms-radius-2">', ', ','</div>');
                    ?>
                    <div class="cms--content bg-white cms-shadow-4 cms-radius-4">
                        <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <div class="cms-meta d-flex justify-content-between align-items-center">
                            <div class="meta">
                                <div class="author"><?php fortis_the_author_posts_link([
                                    'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                    'link_class' => 'text-primary text-hover-secondary',
                                    'object'     => $post   
                                ]); ?></div>
                                <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                            </div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                <i class="cmsi-arrow-right rtl-flip"></i>
                                <?php etc_print_html($settings['readmore_text']); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php
                    break;
                    case '20':
                        // post image
                    fortis_elementor_post_thumbnail_render($settings, [
                        'post_id'     => $post->ID,
                        'img_class'   => 'cms-radius-4 img-cover',
                        'max_height'  => true,
                        'custom_size' => $posts_data['thumbnail_custom_dimension'],
                        'before'      => '<div class="overflow-hidden">',
                        'after'       => '</div>'
                    ]);
                ?>
                <div class="cms-content relative z-top">
                    <div class="cms--content bg-white cms-shadow-3 cms-radius-4">
                        <?php 
                            // post taxonomy
                            the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post--meta">', ', ','</div>');
                        ?>
                        <h4 class="cms-heading text-line-2"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                    </div>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore2" title="<?php etc_print_html($settings['readmore_text']); ?>">
                        <i class="cmsi-arrow-right rtl-flip"></i>
                    </a>
                </div>
                <?php
                    break;
                    case '19':
                        ob_start();
                    ?>
                        <div class="cms-contents relative z-top text-white d-flex align-items-end">
                            <div class="cms--contents text-15">
                                <?php fortis_post_icon_render([
                                    'id'         => $post->ID,
                                    'class'      => 'pb-35',
                                    'icon_color' => 'white'
                                ]); ?>
                                <h4 class="cms-heading text-21 text-white"><a class="text-white text-hover-secondary" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                                <div class="cms-excerpt text-line-3"><?php 
                                    echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                ?></div>
                            </div>
                        </div>
                    <?php
                        $content = ob_get_clean();
                    ?>
                        <div class="cms--item cms-shadow-3 relative cms-radius-4 cms-gradient-8 cms-gradient-hover-6">
                        <?php 
                            // post image
                            fortis_elementor_post_thumbnail_render($settings, [
                                'post_id'     => $post->ID,
                                'custom_size' => $posts_data['thumbnail_custom_dimension'],
                                'img_class'   => 'cms-radius-4 cms-overlay img-cover',
                                'max_height'  => true,
                                'before'      => '<div class="relative cms-radius-4 overflow-hidden">',
                                'after'       => '<div class="cms-gradient-render cms-radius-4 z-top"></div>'.$content.'</div>'     
                            ]);
                        ?>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link justify-content-between p-tb-30 p-lr-40 w-100">
                                <?php etc_print_html($settings['readmore_text']); ?>
                                <i class="cmsi-arrow-circle-right text-32 rtl-flip"></i>
                            </a>
                        </div>
                        <?php
                        break;
                    case '18':
                    ?>
                    <div class="cms-content cms-shadow-3">
                        <div class="cms--content bg-white cms-transition d-flex align-items-start">
                            <div class="w-100 align-self-start">
                                <?php fortis_post_icon_render([
                                    'id'         => $post->ID,
                                    'class'      => 'pb-30 w-100',
                                    'icon_color' => 'secondary'
                                ]); ?>
                                <h4 class="cms-heading text-21 text-ellipsis w-100"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                                <div class="cms-excerpt text-line-4 mb-22 w-100"><?php 
                                    echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                    // Read More
                                ?></div>
                            </div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-secondary btn-hover-primary text-hover-secondary align-self-end">
                                <?php etc_print_html($settings['readmore_text']); ?>
                                <i class="cmsi-arrow-right text-10 rtl-flip"></i>
                            </a>
                        </div>
                    </div>
                    <?php
                        break;
                    case '17':
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'before'      => '<div class="overflow-hidden cms-overlay">',
                            'after'       => '</div>'
                        ]);
                        ?>
                        <div class="cms-content relative z-top bg-white cms-radius-10 p-40 p-lr-smobile-20 cms-transition">
                            <?php 
                                // post taxonomy
                                the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post--meta text-14 pb-5 mt-n7">', ', ','</div>');
                            ?>
                            <a class="cms-heading text-line-2 text-21 mb-n10" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a>
                        </div>
                    <?php
                        break;
                    case '16':
                    ?>
                    <div class="cms--content bg-white cms-transition cms-radius-10 cms-shadow-3">
                        <?php fortis_post_icon_render([
                            'id'         => $post->ID,
                            'class'      => 'pb-30 pt-25',
                            'icon_color' => 'secondary'
                        ]); ?>
                        <h4 class="cms-heading text-21 text-ellipsis"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4 mb-22"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link text-hover-primary">
                            <i class="cmsi-arrow-circle-right text-32 rtl-flip"></i>
                            <?php etc_print_html($settings['readmore_text']); ?>
                        </a>
                    </div>
                    <?php
                        break;
                    case '15':
                ?>
                <div class="cms-gradient-hover-8">
                    <?php
                    // post category
                    ob_start();
                        the_terms($post->ID, 'category', '<div class="cms-post-meta cms-post-meta4 bg-primary absolute top-left">', ', ','</div>');
                    $category = ob_get_clean();
                    // post image
                    fortis_elementor_post_thumbnail_render($settings, [
                        'post_id'     => $post->ID,
                        'img_class'   => 'img-cover',
                        'max_height'  => true,
                        'custom_size' => $posts_data['thumbnail_custom_dimension'],
                        'before'      => '<div class="relative overflow-hidden"><div class="cms-gradient-render cms-radius-3"></div>',
                        'after'       => $category.'</div>'
                    ]);
                    ?>
                    <div class="cms-content">
                        <div class="cms--content bg-white cms-shadow-4">
                            <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <div class="cms-meta d-flex justify-content-between align-items-center">
                                <div class="meta">
                                    <div class="author"><?php fortis_the_author_posts_link([
                                        'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                        'link_class' => 'text-secondary text-hover-primary',
                                        'object'     => $post   
                                    ]); ?></div>
                                    <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                                </div>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                    <i class="cmsi-arrow-right rtl-flip"></i>
                                    <?php etc_print_html($settings['readmore_text']); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                    break;
                    case '14':
                ?>
                <div class="cms-gradient-hover-8">
                    <?php
                        // post category
                        ob_start();
                            the_terms($post->ID, 'category', '<div class="cms-post-meta bg-primary absolute top-left cms-radius-3">', ', ','</div>');
                        $category = ob_get_clean();
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'cms-radius-3', 
                            'max_height'  => true,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'before'      => '<div class="relative overflow-hidden"><div class="cms-gradient-render cms-radius-3"></div>',
                            'after'       => $category.'</div>'
                        ]);
                    ?>
                    <div class="cms-content">
                        <div class="cms--content bg-white cms-shadow-4 cms-radius-3">
                            <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <div class="cms-meta d-flex justify-content-between align-items-center">
                                <div class="meta">
                                    <div class="author"><?php fortis_the_author_posts_link([
                                        'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                        'link_class' => 'text-primary text-hover-secondary',
                                        'object'     => $post   
                                    ]); ?></div>
                                    <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                                </div>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                    <i class="cmsi-arrow-right rtl-flip"></i>
                                    <?php etc_print_html($settings['readmore_text']); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                        break;
                    case '13':
                ?>
                    <div class="cms-shadow-4 cms-gradient-hover-8 cms-radius-3 overflow-hidden">
                    <?php
                        ob_start();
                    ?>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore3 absolute center cms-radius-3" title="<?php etc_print_html($settings['readmore_text']); ?>">
                            <i class="cmsi-plus text-10"></i>
                        </a>
                    <?php
                        $readmore = ob_get_clean();
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'img_class'   => 'cms-radius-3 img-cover',
                            'max_height'  => true, 
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'before'      => '<div class="relative overflow-hidden">',
                            'after'       => '<div class="cms-gradient-render"></div>'.$readmore.'</div>'  
                        ]);
                    ?>
                        <div class="cms--content bg-white p-40 p-lr-smobile-20">
                            <?php 
                            // post category
                            the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post-meta3 text-14 pb-7">', ', ','</div>');
                            ?>
                            <h4 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4 text-16 pt-20 empty-none"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'],'');
                                // Read More
                            ?></div>
                        </div>
                    </div>
                    <?php
                        break;
                    case '12':
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover cms-radius-3',
                            'max_height'  => true,
                            'before'      => '<div class="overflow-hidden cms-overlay">',
                            'after'       => '</div>' 
                        ]);
                    ?>
                        <div class="cms-content relative z-top p-lr-40 p-lr-smobile-20 pb-40  cms-gradient-5 cms-gradient-hover-3 cms-radius-3 d-flex align-items-end">
                            <div class="cms-gradient-render cms-transition cms-radius-3"></div>
                            <div class="cms--content bg-white cms-radius-3 relative z-top text-center">
                                <?php fortis_post_icon_render([
                                    'id'         => $post->ID,
                                    'class'      => 'cms-radius-3 cms-transition',
                                    'icon_color' => 'white'
                                ]); ?>
                                <h4 class="cms-heading text-21"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                                <div class="cms-excerpt text-line-3 cms-transition"><?php 
                                    echo wp_trim_words($post->post_excerpt, $settings['num_words'], '');
                                    // Read More
                                ?></div>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link text-primary text-hover-secondary">
                                    <?php etc_print_html($settings['readmore_text']); ?>
                                    <i class="cmsi-arrow-right text-10 rtl-flip"></i>
                                </a>
                            </div>
                        </div>
                    <?php
                        break;
                    case '11':
                    ?>
                        <div class="cms--content bg-white p-40 p-lr-smobile-20 cms-shadow-3">
                            <?php 
                                // Career 
                                fortis_post_career_render([
                                    'id' => $post->ID,
                                    'class' => 'mb-30'
                                ]);
                            ?>
                            <h4 class="cms-heading text-22"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4 text-15 empty-none"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'],'');
                            ?></div>
                            <?php // Read More ?>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-md btn-outline btn-1 mt-20" title="<?php etc_print_html($settings['readmore_text']); ?>">
                                <i class="cmsi-arrow-right rtl-flip text-10"></i>
                                <?php etc_print_html($settings['readmore_text']); ?>
                            </a>
                        </div>
                    <?php
                        break;
                    case '10':
                ?>
                    <div class="cms-shadow-4 cms-gradient-hover-8">
                    <?php
                        ob_start();
                    ?>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore3 absolute center" title="<?php etc_print_html($settings['readmore_text']); ?>">
                            <i class="cmsi-plus text-10"></i>
                        </a>
                    <?php
                        $readmore = ob_get_clean();
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'before'      => '<div class="relative overflow-hidden">',
                            'after'       => '<div class="cms-gradient-render"></div>'.$readmore.'</div>'  
                        ]);
                    ?>
                        <div class="cms--content bg-white p-40 p-lr-smobile-20">
                            <?php 
                            // post category
                            the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post-meta3 text-14 pb-7">', ', ','</div>');
                            ?>
                            <h4 class="cms-heading text-line-2 font-500"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4 text-16 pt-20 empty-none"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'],'');
                                // Read More
                            ?></div>
                        </div>
                    </div>
                    <?php
                        break;
                    case '9':
                    ?>
                        <div class="cms-content bg-white pt-35 p-lr-40 p-lr-smobile-20">
                            <?php fortis_post_icon_render([
                                'id'         => $post->ID,
                                'class'      => 'pb-35',
                                'icon_color' => 'secondary'
                            ]); ?>
                            <h4 class="cms-heading text-19 text-line-1"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-15 text-line-4 mb-22"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-secondary btn-hover-primary btn-slide-text icon-first relative z-top">
                                <i class="cmsi-plus text-10 rtl-flip"></i>
                                <span class="cms-btn-text"><?php etc_print_html($settings['readmore_text']); ?></span>
                            </a>
                        </div>
                    <?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'before'      => '<div class="cms-gradient-5 mt-n29 relative overflow-hidden">',
                            'after'       => '<div class="cms-gradient-render"></div></div>'    
                        ]);
                        break;
                    case '8':
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'before'      => '<div class="overflow-hidden cms-overlay">',
                            'after'       => '</div>'
                        ]);
                    ?>
                    <div class="cms-gradient-8 cms-gradient-hover-6">
                        <div class="cms-gradient-render cms-overlay cms-transition"></div>
                        <div class="cms--content relative z-top d-flex">
                            <a class="cms-readmore2" href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php etc_print_html($settings['readmore_text']); ?>">
                                <i class="cmsi-chevron-right text-10 rtl-flip cms-transition"></i>
                            </a>
                            <div class="cms---content cms-transition align-self-end">
                                <?php fortis_post_icon_render([
                                    'id'         => $post->ID,
                                    'icon_color' => 'white',
                                    'class'      => 'pb-35'
                                ]); ?>
                                <h4 class="cms-heading text-ellipsis"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                                <div class="cms-excerpt text-line-4 mb-n7"><?php 
                                    echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                    // Read More
                                ?></div>
                            </div>
                        </div>
                    </div>
                    <?php
                        break;
                    case '7':
                        // post image
                    fortis_elementor_post_thumbnail_render($settings, [
                        'post_id'     => $post->ID,
                        'custom_size' => $posts_data['thumbnail_custom_dimension'],
                        'max_height'  => true,
                        'img_class'   => 'img-cover',
                        'before'      => '<div class="overflow-hidden">',
                        'after'       => '</div>'
                    ]);
                ?>
                <div class="cms-content relative z-top">
                    <div class="cms--content bg-white cms-shadow-3">
                        <?php 
                            // post taxonomy
                            the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post--meta">', ', ','</div>');
                        ?>
                        <h4 class="cms-heading text-line-2"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                    </div>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore2" title="<?php etc_print_html($settings['readmore_text']); ?>">
                        <i class="cmsi-arrow-right rtl-flip"></i>
                    </a>
                </div>
                <?php
                    break;
                    case '6':
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,  
                            'before'      => '<div class="cms-item-banner cms-gradient-6 clip-path-3 absolute z-top cms-transition overflow-hidden">',
                            'after'       => '<div class="cms-gradient-render"></div>'.fortis_post_icon_render([
                                'id'         => $post->ID,
                                'class'      => 'absolute center',
                                'icon_color' => 'white',
                                'echo'       => false
                            ]).'</div>'
                        ]);
                    ?>
                    <div class="cms--content bg-white cms-transition">
                        <?php fortis_post_icon_render([
                            'id'         => $post->ID,
                            'class'      => 'pb-35',
                            'icon_color' => 'secondary'
                        ]); ?>
                        <h4 class="cms-heading text-21 text-ellipsis"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4 mb-22"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-link">
                            <i class="cmsi-arrow-circle-right-large text-32 rtl-flip"></i>
                            <?php etc_print_html($settings['readmore_text']); ?>
                        </a>
                    </div>
                    <?php
                        break;
                    case '5':
                ?>
                <div class="cms-content relative cms-shadow-3">
                    <?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'class'       => '',  
                            'img_class'   => 'img-cover',
                            'max_height'  => false,
                            'before'      => '<div class="cms-gradient-5 cms-overlay overflow-hidden">',  
                            'after'       => '<div class="cms-gradient-render"></div></div>'
                        ]);
                    ?>
                    <div class="cms--content5 bg-white pt-35 p-lr-40 p-lr-smobile-20 mr-40 mr-mobile-20 clip-path-1 relative z-top cms-shadow-4 cms-transition">
                        <h4 class="cms-heading text-19"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4 text-15 mb-20"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn">
                            <i class="cmsi-plus text-10"></i>
                            <?php etc_print_html($settings['readmore_text']); ?>
                        </a>
                    </div>
                </div>
                    <?php
                        break;
                    case '4':
                ?>
                    <div class="cms-shadow-4 relative">
                    <?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'before'      => '<div class="overflow-hidden">',
                            'after'       => '</div>'
                        ]);
                        // post category
                        the_terms($post->ID, $posts_data['taxonomy'], '<div class="cms-post-meta cms-post-meta2"><span>', ', ','</span></div>');
                    ?>
                        <div class="cms--content bg-white p-40 p-lr-smobile-20">
                            <h4 class="cms-heading text-line-2"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-line-4 text-16 mb-20"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-outline btn-4">
                                <i class="cmsi-plus text-10"></i>
                                <?php etc_print_html($settings['readmore_text']); ?>
                            </a>
                        </div>
                    </div>
                    <?php
                        break;
                    case '3':
                    ?>
                        <div class="cms-content bg-white pt-35 p-lr-40 p-lr-smobile-20">
                            <?php fortis_post_icon_render([
                                'id'         => $post->ID,
                                'class'      => 'pb-35',
                                'icon_color' => 'secondary'
                            ]); ?>
                            <h4 class="cms-heading text-19 text-line-1"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                            <div class="cms-excerpt text-15 text-line-4 mb-22"><?php 
                                echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                // Read More
                            ?></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-secondary btn-hover-primary btn-slide-text icon-first relative z-top">
                                <i class="cmsi-plus text-10 rtl-flip"></i>
                                <span class="cms-btn-text"><?php etc_print_html($settings['readmore_text']); ?></span>
                            </a>
                        </div>
                    <?php
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'before'      => '<div class="cms-gradient-5 mt-n29 relative overflow-hidden">',
                            'after'       => '<div class="cms-gradient-render"></div></div>'    
                        ]);
                        break;
                    case '2':
                    ?>
                    <div class="cms--item cms-shadow-3 relative">
                    <?php 
                        // post image
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => $posts_data['thumbnail_custom_dimension'],
                            'img_class'   => 'img-cover',
                            'max_height'  => true,
                            'before'      => '<div class="cms-overlay overflow-hidden">',
                            'after'       => '</div>' 
                        ]);
                    ?>
                        <div class="cms-content relative p-40 p-lr-smobile-20 hover-stroke gradient-1 gradient-hover">
                            <div class="cms--content gradient-content bg-white clip-path-1 hover-stroke cms-transition">
                                <?php fortis_post_icon_render([
                                    'id'         => $post->ID,
                                    'class'      => 'pb-35',
                                    'icon_color' => 'secondary'
                                ]); ?>
                                <h4 class="cms-heading text-21"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                                <div class="cms-excerpt text-line-4 mb-22"><?php 
                                    echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                                    // Read More
                                ?></div>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="btn btn-secondary btn-hover-primary icon-last">
                                    <i class="cmsi-arrow-right text-10 rtl-flip"></i>
                                    <?php etc_print_html($settings['readmore_text']); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php
                        break;
                    default:
                    // post image
                    fortis_elementor_post_thumbnail_render($settings, [
                        'post_id'     => $post->ID,
                        'custom_size' => $posts_data['thumbnail_custom_dimension'],
                        'img_class'   => 'img-cover', 
                        'max_height'  => true,
                        'before'      => '<div class="overflow-hidden">',
                        'after'       => '</div>'  
                    ]);
                ?>
                <div class="cms-content">
                    <?php 
                        // post category
                        the_terms($post->ID, 'category', '<div class="cms-post-meta bg-primary">', ', ','</div>');
                    ?>
                    <div class="cms--content bg-white cms-shadow-4">
                        <h4 class="cms-heading text-20 font-500"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <div class="cms-excerpt text-line-4"><?php 
                            echo wp_trim_words($post->post_excerpt, $settings['num_words'], '&hellip;');
                            // Read More
                        ?></div>
                        <div class="cms-meta d-flex justify-content-between align-items-center">
                            <div class="meta">
                                <div class="author"><?php fortis_the_author_posts_link([
                                    'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                    'link_class' => 'text-primary text-hover-secondary',
                                    'object'     => $post   
                                ]); ?></div>
                                <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                            </div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                <i class="cmsi-arrow-right rtl-flip"></i>
                                <?php etc_print_html($settings['readmore_text']); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php
                    break;
                } ?>
            </div>
        <?php
        endforeach;
    }
}
/**
 * Custom Post 
 * 
 * */
/**
 * Icon 
*/
if(!function_exists('fortis_post_icon_opts')){
    function fortis_post_icon_opts($args = []){
        return [
            'title'  => esc_html__('Icon', 'fortis'),
            'fields' => [
                'icon' => [
                    'type'        => Theme_Core_Options::ICON_PICKER_FIELD,
                    'title'       => __('Choose your icon', 'fortis')
                ]
            ]
        ];
    }
}
/**
 * Render Icon
*/
if(!function_exists('fortis_post_icon_render')){
    function fortis_post_icon_render($args = []){
        $args = wp_parse_args($args, [
            'id'          => get_the_ID(),
            'class'       => '',     
            'before'      => '',
            'after'       => '',
            'wrap_before' => '',
            'wrap_after'  => '',
            'icon_class'  => '',
            'icon_color'  => 'primary',
            'size'        => '64',
            'echo'        => true    
        ]);
        $icon = fortis_get_post_format_value($args['id'], 'icon', '');
        
        if(empty($icon)) return;
        
        $_icon = '<i class="'.implode(' ',array_filter([$icon,'cms-post--icon','cms-transition','d-block', $args['icon_class'], 'text-'.$args['icon_color'],'text-'.$args['size']])).'"></i>';

        ob_start();
        printf('%s', $args['wrap_before']);
        ?>
            <div class="<?php echo implode(' ',array_filter(['cms-post-icon', $args['class']]));?>"><?php 
                printf('%1$s %2$s %3$s', $args['before'], $_icon, $args['after'] ); 
            ?></div>
        <?php
        printf('%s', $args['wrap_after']);
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
/**
 * Career Opts 
*/
if(!function_exists('fortis_post_career_opts')){
    function fortis_post_career_opts($args = []){
        return [
            'title'  => esc_html__('General', 'fortis'),
            'fields' => [
                'job_type' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => __('Job Type', 'fortis')
                ],
                'job_address' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => __('Job Address', 'fortis')
                ],
                'job_salary' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => __('Job Salary', 'fortis')
                ]
            ]
        ];
    }
}
if(!function_exists('fortis_post_career_render')){
    function fortis_post_career_render($args = []){
        $args = wp_parse_args($args, [
            'id'    => null,
            'class' => ''
        ]);
        if(!$args['id']) return;
        $job_type   = fortis_get_post_format_value($args['id'], 'job_type', '');
        $job_add    = fortis_get_post_format_value($args['id'], 'job_address', '');
        $job_salary = fortis_get_post_format_value($args['id'], 'job_salary', '');

        $classes = ['cms-job-details d-flex gap', $args['class']];
    ?>
    <div class="<?php echo implode(' ', array_filter($classes)); ?>" style="--cms-gap:15px;--cms-gap-tablet:15px;--cms-gap-mobile:15px;">
        <div class="job-type empty-none"><?php echo esc_html($job_type); ?></div>
        <div class="job-add empty-none"><?php echo esc_html($job_add); ?></div>
        <div class="job-sallary empty-none"><?php echo esc_html($job_salary); ?></div>
    </div>
    <?php
    }
}
if(!function_exists('fortis_chart_data_settings')){
    function fortis_chart_data_settings($widget, $settings, $args = []){
        $args = wp_parse_args($args, [
            'name'            => 'cms_chart',
            'chart_container' => 'cms-charts',
            'class'           => ''
        ]);
        $charts = $widget->get_settings($args['name']);
        $chart_title = $chart_main_title = $chart_value = $chart_color = [];
        foreach ($charts as $key => $value) {
            $chart_title[] = $value['chart_title'];
            $chart_main_title[] = $value['chart_main_title'];
            $chart_value[] = $value['chart_value'];
            $chart_color[] = $value['chart_color'];
        }
        /*$charts_data = [
            'labels' => $chart_title,
            'value'  => implode(',', $chart_value),
            'colors' => implode(',', $chart_color)
        ];*/
        $opts = [
            'type'            => $settings['cms_chart_type'],   
            'labels'          => $chart_title,
            'value'           => $chart_value,
            'colors'          => $chart_color,
            'legend_display'  => $settings['legend_display'],
            'legend_position' => $settings['legend_position'],
            'title_display'   => $settings['title_display'],
            'title_position'  => $settings['title_position'],
            'title_text'      => $settings['title_text']
        ];
        $widget->add_render_attribute( 'cms-chart-settings', [
            'id'            => etc_get_element_id($settings),
            'class'         => implode( ' ', array_filter([$args['chart_container'], $args['class']]) ),
            'data-settings' => wp_json_encode($opts)
        ]);
        etc_print_html($widget->get_render_attribute_string( 'cms-chart-settings' ));
    }
}
?>